/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupParametersGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private int size;
    private int certainty;
    private SecureRandom random;

    public void init(int n3, int n4, SecureRandom secureRandom) {
        CramerShoupParametersGenerator cramerShoupParametersGenerator = this;
        cramerShoupParametersGenerator.size = n3;
        cramerShoupParametersGenerator.certainty = n4;
        cramerShoupParametersGenerator.random = secureRandom;
    }

    public CramerShoupParameters generateParameters() {
        SHA256Digest sHA256Digest;
        CramerShoupParametersGenerator cramerShoupParametersGenerator = sHA256Digest2;
        int n3 = cramerShoupParametersGenerator.certainty;
        BigInteger bigInteger = ParametersHelper.generateSafePrimes(((CramerShoupParametersGenerator)((Object)sHA256Digest2)).size, n3, cramerShoupParametersGenerator.random)[1];
        BigInteger bigInteger2 = ParametersHelper.selectGenerator(bigInteger, ((CramerShoupParametersGenerator)((Object)sHA256Digest2)).random);
        BigInteger bigInteger3 = ParametersHelper.selectGenerator(bigInteger, ((CramerShoupParametersGenerator)((Object)sHA256Digest2)).random);
        while (bigInteger2.equals(bigInteger3)) {
            bigInteger3 = ParametersHelper.selectGenerator(bigInteger, ((CramerShoupParametersGenerator)((Object)sHA256Digest2)).random);
        }
        SHA256Digest sHA256Digest2 = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        return new CramerShoupParameters(bigInteger, bigInteger2, bigInteger3, sHA256Digest2);
    }

    public CramerShoupParameters generateParameters(DHParameters object) {
        SHA256Digest sHA256Digest;
        BigInteger bigInteger = ((DHParameters)object).getP();
        object = ((DHParameters)object).getG();
        BigInteger bigInteger2 = ParametersHelper.selectGenerator(bigInteger, ((CramerShoupParametersGenerator)((Object)sHA256Digest2)).random);
        while (((BigInteger)object).equals(bigInteger2)) {
            bigInteger2 = ParametersHelper.selectGenerator(bigInteger, ((CramerShoupParametersGenerator)((Object)sHA256Digest2)).random);
        }
        SHA256Digest sHA256Digest2 = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        return new CramerShoupParameters(bigInteger, (BigInteger)object, bigInteger2, sHA256Digest2);
    }

    public static class ParametersHelper {
        private static final BigInteger TWO = BigInteger.valueOf(2L);

        private ParametersHelper() {
        }

        public static BigInteger[] generateSafePrimes(int n3, int n4, SecureRandom secureRandom) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            --n3;
            while (!(bigInteger2 = (bigInteger = BigIntegers.createRandomPrime(n3, 2, secureRandom)).shiftLeft(1).add(ONE)).isProbablePrime(n4) || n4 > 2 && !bigInteger.isProbablePrime(n4)) {
            }
            return new BigInteger[]{bigInteger2, bigInteger};
        }

        public static BigInteger selectGenerator(BigInteger bigInteger, SecureRandom secureRandom) {
            BigInteger bigInteger2;
            BigInteger bigInteger3 = bigInteger.subtract(TWO);
            do {
                bigInteger2 = TWO;
            } while ((bigInteger2 = BigIntegers.createRandomInRange(bigInteger2, bigInteger3, secureRandom).modPow(bigInteger2, bigInteger)).equals(ONE));
            return bigInteger2;
        }
    }
}

