/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        DESKeyGenerator dESKeyGenerator = this;
        super.init(keyGenerationParameters);
        int n3 = dESKeyGenerator.strength;
        if (n3 != 0 && n3 != 7) {
            if (n3 != 8) {
                throw new IllegalArgumentException("DES key must be 64 bits long.");
            }
        } else {
            this.strength = 8;
        }
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (DESParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

