/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DESKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESedeParameters;

public class DESedeKeyGenerator
extends DESKeyGenerator {
    private static final int MAX_IT = 20;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        int n3;
        this.random = keyGenerationParameters.getRandom();
        this.strength = n3 = (keyGenerationParameters.getStrength() + 7) / 8;
        if (n3 != 0 && n3 != 21) {
            if (n3 == 14) {
                this.strength = 16;
            } else if (n3 != 24 && n3 != 16) {
                throw new IllegalArgumentException("DESede key must be 192 or 128 bits long.");
            }
        } else {
            this.strength = 24;
        }
    }

    @Override
    public byte[] generateKey() {
        int n3 = this.strength;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (++n4 < 20 && (DESedeParameters.isWeakKey(byArray, 0, n3) || !DESedeParameters.isRealEDEKey(byArray, 0)));
        if (!DESedeParameters.isWeakKey(byArray, 0, n3) && DESedeParameters.isRealEDEKey(byArray, 0)) {
            return byArray;
        }
        throw new IllegalStateException("Unable to generate DES-EDE key");
    }
}

