/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

class DHKeyGeneratorHelper {
    public static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    public BigInteger calculatePrivate(DHParameters object, SecureRandom secureRandom) {
        int n3 = ((DHParameters)object).getL();
        if (n3 != 0) {
            int n4 = n3 >>> 2;
            while (WNafUtil.getNafWeight((BigInteger)(object = BigIntegers.createRandomBigInteger(n3, secureRandom).setBit(n3 - 1))) < n4) {
            }
            return object;
        }
        BigInteger bigInteger = TWO;
        int n5 = ((DHParameters)object).getM();
        BigInteger bigInteger2 = n5 != 0 ? ONE.shiftLeft(n5 - 1) : bigInteger;
        BigInteger bigInteger3 = ((DHParameters)object).getQ();
        if (bigInteger3 == null) {
            bigInteger3 = ((DHParameters)object).getP();
        }
        bigInteger = bigInteger3.subtract(bigInteger);
        int n6 = bigInteger.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger3 = BigIntegers.createRandomInRange(bigInteger2, bigInteger, secureRandom)) < n6) {
        }
        return bigInteger3;
    }

    public BigInteger calculatePublic(DHParameters dHParameters, BigInteger bigInteger) {
        return dHParameters.getG().modPow(bigInteger, dHParameters.getP());
    }
}

