/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    private static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n3 = bigInteger.bitLength() >>> 2;
        do {
            bigInteger2 = ONE;
        } while (WNafUtil.getNafWeight(bigInteger3 = BigIntegers.createRandomInRange(bigInteger2, bigInteger.subtract(bigInteger2), secureRandom)) < n3);
        return bigInteger3;
    }

    private static BigInteger calculatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAPrivateKeyParameters dSAPrivateKeyParameters;
        DSAParameters dSAParameters = ((DSAKeyPairGenerator)((Object)bigInteger)).param.getParameters();
        BigInteger bigInteger = DSAKeyPairGenerator.generatePrivateKey(dSAParameters.getQ(), ((DSAKeyPairGenerator)((Object)bigInteger)).param.getRandom());
        Object object = DSAKeyPairGenerator.calculatePublicKey(dSAParameters.getP(), dSAParameters.getG(), bigInteger);
        DSAPublicKeyParameters dSAPublicKeyParameters = new DSAPublicKeyParameters((BigInteger)object, dSAParameters);
        object = dSAPrivateKeyParameters;
        dSAPrivateKeyParameters = new DSAPrivateKeyParameters(bigInteger, dSAParameters);
        return new AsymmetricCipherKeyPair(dSAPublicKeyParameters, (AsymmetricKeyParameter)object);
    }
}

