/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA1Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAValidationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAParametersGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private boolean use186_3;
    private int usageIndex;

    public DSAParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public DSAParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_2() {
        v0 = this;
        var1_1 = 20;
        var2_3 = new byte[20];
        var3_4 = 20;
        var4_5 = new byte[20];
        var5_6 = new byte[20];
        var6_7 = 20;
        var7_8 = new byte[20];
        v1 = v0.L;
        var8_9 = (v1 - 1) / 160;
        var9_10 = v1 / 8;
        var10_11 = new byte[var9_10];
        if (v0.digest instanceof SHA1Digest) {
            block0: while (true) {
                v2 = this;
                v2.random.nextBytes(var2_3);
                DSAParametersGenerator.hash(v2.digest, var2_3, var4_5, 0);
                System.arraycopy(var2_3, 0, var5_6, 0, var1_1);
                DSAParametersGenerator.inc(var5_6);
                DSAParametersGenerator.hash(this.digest, var5_6, var5_6, 0);
                for (var11_13 = 0; var11_13 != var6_7; ++var11_13) {
                    var7_8[var11_13] = (byte)(var4_5[var11_13] ^ var5_6[var11_13]);
                }
                v3 = var7_8;
                v3[0] = (byte)(var7_8[0] | -128);
                v3[19] = (byte)(var7_8[19] | 1);
                var11_12 = v4;
                if (!this.isProbablePrime(new BigInteger(1, var7_8))) continue;
                var12_14 = Arrays.clone(var2_3);
                DSAParametersGenerator.inc(var12_14);
                var13_15 = 0;
                while (true) {
                    if (var13_15 < 4096) ** break;
                    continue block0;
                    for (var14_17 = 1; var14_17 <= var8_9; ++var14_17) {
                        DSAParametersGenerator.inc(var12_14);
                        DSAParametersGenerator.hash(this.digest, var12_14, var10_11, var9_10 - var14_17 * var3_4);
                    }
                    var14_17 = var9_10 - var8_9 * var3_4;
                    DSAParametersGenerator.inc(var12_14);
                    DSAParametersGenerator.hash(this.digest, var12_14, var4_5, 0);
                    System.arraycopy(var4_5, var3_4 - var14_17, var10_11, 0, var14_17);
                    var10_11[0] = (byte)(var10_11[0] | -128);
                    v5 = new BigInteger(1, var10_11);
                    var14_16 = v5.subtract(v5.mod(var11_12.shiftLeft(1)).subtract(DSAParametersGenerator.ONE));
                    if (var14_16.bitLength() == this.L && this.isProbablePrime(var14_16)) {
                        this = DSAParametersGenerator.calculateGenerator_FIPS186_2(var14_16, var11_12, this.random);
                        var1_2 = v6;
                        v6 = new DSAValidationParameters(var2_3, var13_15);
                        return new DSAParameters(var14_16, var11_12, this, var1_2);
                    }
                    ++var13_15;
                }
                break;
            }
        }
        throw new IllegalStateException("can only use SHA-1 for generating FIPS 186-2 parameters");
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger;
        bigInteger2 = bigInteger4.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.subtract(TWO);
        while ((bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger5, secureRandom).modPow(bigInteger2, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger3;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_3() {
        var1_2 = this.digest;
        v0 = this;
        var2_3 = var1_2.getDigestSize() * 8;
        var3_5 = new byte[v0.N / 8];
        v1 = v0.L;
        var4_6 = (v1 - 1) / var2_3;
        (v1 - 1) % var2_3;
        var2_3 = v1 / 8;
        var5_7 = new byte[var2_3];
        var6_8 = var1_2.getDigestSize();
        var7_9 = new byte[var6_8];
        block0: while (true) {
            this.random.nextBytes(var3_5);
            DSAParametersGenerator.hash((Digest)var1_2, var3_5, var7_9, 0);
            var8_10 = new BigInteger(1, var7_9).mod(DSAParametersGenerator.ONE.shiftLeft(this.N - 1)).setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(var8_10)) continue;
            var9_11 = Arrays.clone(var3_5);
            var10_12 = this.L * 4;
            var11_13 = 0;
            while (true) {
                if (var11_13 < var10_12) ** break;
                continue block0;
                for (var12_15 = 1; var12_15 <= var4_6; ++var12_15) {
                    DSAParametersGenerator.inc(var9_11);
                    DSAParametersGenerator.hash((Digest)var1_2, var9_11, var5_7, var2_3 - var12_15 * var6_8);
                }
                var12_15 = var2_3 - var4_6 * var6_8;
                DSAParametersGenerator.inc(var9_11);
                DSAParametersGenerator.hash((Digest)var1_2, var9_11, var7_9, 0);
                System.arraycopy(var7_9, var6_8 - var12_15, var5_7, 0, var12_15);
                var5_7[0] = (byte)(var5_7[0] | -128);
                v2 = new BigInteger(1, var5_7);
                var12_14 = v2.subtract(v2.mod(var8_10.shiftLeft(1)).subtract(DSAParametersGenerator.ONE));
                if (var12_14.bitLength() == this.L && this.isProbablePrime(var12_14)) {
                    var2_3 = this.usageIndex;
                    if (var2_3 >= 0 && (var1_2 = DSAParametersGenerator.calculateGenerator_FIPS186_3_Verifiable((Digest)var1_2, var12_14, var8_10, var3_5, var2_3)) != null) {
                        var2_4 = v3;
                        var0_1 = this.usageIndex;
                        v3 = new DSAValidationParameters(var3_5, var11_13, var0_1);
                        return new DSAParameters(var12_14, var8_10, (BigInteger)var1_2, var2_4);
                    }
                    this = DSAParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(var12_14, var8_10, this.random);
                    var1_2 = v4;
                    v4 = new DSAValidationParameters(var3_5, var11_13);
                    return new DSAParameters(var12_14, var8_10, this, (DSAValidationParameters)var1_2);
                }
                ++var11_13;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger bigInteger) {
        return bigInteger.isProbablePrime(this.certainty);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DSAParametersGenerator.calculateGenerator_FIPS186_2(bigInteger, bigInteger2, secureRandom);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n3) {
        bigInteger2 = bigInteger.subtract(ONE).divide(bigInteger2);
        Object object = Hex.decodeStrict("6767656E");
        int n4 = b.a(byArray.length, ((byte[])object).length, 1, 2);
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = byArray2;
        int n5 = n3;
        int n6 = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n6);
        n6 = byArray.length;
        n3 = ((byte[])object).length;
        System.arraycopy(object, 0, byArray3, n6, n3);
        n6 = n4 - 3;
        byArray2[n6] = (byte)n5;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (n3 = 1; n3 < 65536; ++n3) {
            DSAParametersGenerator.inc(byArray3);
            DSAParametersGenerator.hash(digest, byArray3, byArray4, 0);
            BigInteger bigInteger3 = new BigInteger(1, byArray4).modPow(bigInteger2, bigInteger);
            object = bigInteger3;
            if (bigInteger3.compareTo(TWO) < 0) continue;
            return object;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n3) {
        Digest digest2 = digest;
        int n4 = byArray.length;
        digest2.update(byArray, 0, n4);
        digest2.doFinal(byArray2, n3);
    }

    private static int getDefaultN(int n3) {
        return n3 > 1024 ? 256 : 160;
    }

    private static int getMinimumIterations(int n3) {
        return n3 <= 1024 ? 40 : (n3 - 1) / 1024 * 8 + 48;
    }

    private static void inc(byte[] byArray) {
        for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
            byte by;
            byArray[i3] = by = (byte)(byArray[i3] + 1 & 0xFF);
            if (by != 0) break;
        }
    }

    public void init(int n3, int n4, SecureRandom secureRandom) {
        DSAParametersGenerator dSAParametersGenerator = this;
        this.L = n3;
        this.N = DSAParametersGenerator.getDefaultN(n3);
        this.certainty = n4;
        this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations(this.L), (n4 + 1) / 2);
        dSAParametersGenerator.random = secureRandom;
        dSAParametersGenerator.use186_3 = false;
        dSAParametersGenerator.usageIndex = -1;
    }

    public void init(DSAParameterGenerationParameters dSAParameterGenerationParameters) {
        int n3 = dSAParameterGenerationParameters.getL();
        int n4 = dSAParameterGenerationParameters.getN();
        if (n3 >= 1024 && n3 <= 3072 && n3 % 1024 == 0) {
            if (n3 == 1024 && n4 != 160) {
                throw new IllegalArgumentException("N must be 160 for L = 1024");
            }
            if (n3 == 2048 && n4 != 224 && n4 != 256) {
                throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
            }
            if (n3 == 3072 && n4 != 256) {
                throw new IllegalArgumentException("N must be 256 for L = 3072");
            }
            if (this.digest.getDigestSize() * 8 >= n4) {
                DSAParametersGenerator dSAParametersGenerator = this;
                this.L = n3;
                this.N = n4;
                this.certainty = dSAParameterGenerationParameters.getCertainty();
                this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations(n3), (this.certainty + 1) / 2);
                dSAParametersGenerator.random = dSAParameterGenerationParameters.getRandom();
                dSAParametersGenerator.use186_3 = true;
                this.usageIndex = dSAParameterGenerationParameters.getUsageIndex();
                return;
            }
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
    }

    public DSAParameters generateParameters() {
        return this.use186_3 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }
}

