/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MacDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFCounterParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFCounterBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputDataCtrPrefix;
    private byte[] fixedInputData_afterCtr;
    private int maxSizeExcl;
    private byte[] ios;
    private int generatedBytes;
    private byte[] k;

    public KDFCounterBytesGenerator(Mac mac) {
        int n3;
        KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
        this.prf = mac;
        kDFCounterBytesGenerator.h = n3 = mac.getMacSize();
        kDFCounterBytesGenerator.k = new byte[n3];
    }

    private void generateNext() {
        KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
        int n3 = kDFCounterBytesGenerator.generatedBytes / this.h + 1;
        byte[] byArray = kDFCounterBytesGenerator.ios;
        switch (kDFCounterBytesGenerator.ios.length) {
            default: {
                throw new IllegalStateException("Unsupported size of counter i");
            }
            case 4: {
                byArray[0] = (byte)(n3 >>> 24);
            }
            case 3: {
                int n4 = byArray.length - 3;
                byArray[n4] = (byte)(n3 >>> 16);
            }
            case 2: {
                int n4 = byArray.length - 2;
                byArray[n4] = (byte)(n3 >>> 8);
            }
            case 1: 
        }
        KDFCounterBytesGenerator kDFCounterBytesGenerator2 = this;
        int n5 = n3;
        n3 = byArray.length - 1;
        byArray[n3] = (byte)n5;
        kDFCounterBytesGenerator2.prf.update(this.fixedInputDataCtrPrefix, 0, this.fixedInputDataCtrPrefix.length);
        kDFCounterBytesGenerator2.prf.update(this.ios, 0, this.ios.length);
        kDFCounterBytesGenerator2.prf.update(this.fixedInputData_afterCtr, 0, this.fixedInputData_afterCtr.length);
        kDFCounterBytesGenerator2.prf.doFinal(this.k, 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFCounterParameters) {
            derivationParameters = (KDFCounterParameters)derivationParameters;
            this.prf.init(new KeyParameter(((KDFCounterParameters)derivationParameters).getKI()));
            this.fixedInputDataCtrPrefix = ((KDFCounterParameters)derivationParameters).getFixedInputDataCounterPrefix();
            this.fixedInputData_afterCtr = ((KDFCounterParameters)derivationParameters).getFixedInputDataCounterSuffix();
            int n3 = ((KDFCounterParameters)derivationParameters).getR();
            this.ios = new byte[n3 / 8];
            BigInteger bigInteger = TWO.pow(n3).multiply(BigInteger.valueOf(this.h));
            int n4 = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
            KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
            kDFCounterBytesGenerator.maxSizeExcl = n4;
            kDFCounterBytesGenerator.generatedBytes = 0;
            return;
        }
        throw new IllegalArgumentException("Wrong type of arguments given");
    }

    @Override
    public Mac getMac() {
        return this.prf;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        int n5 = this.generatedBytes;
        int n6 = n5 + n4;
        if (n6 >= 0 && n6 < this.maxSizeExcl) {
            if (n5 % this.h == 0) {
                this.generateNext();
            }
            int n7 = n3;
            KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
            n5 = kDFCounterBytesGenerator.generatedBytes;
            n6 = kDFCounterBytesGenerator.h;
            int n8 = n5;
            n5 %= n6;
            n6 = Math.min(n6 - n8 % n6, n4);
            System.arraycopy(kDFCounterBytesGenerator.k, n5, byArray, n3, n6);
            kDFCounterBytesGenerator.generatedBytes += n6;
            n3 = n4 - n6;
            n5 = n7 + n6;
            while (n3 > 0) {
                int n9 = n5;
                int n10 = n3;
                KDFCounterBytesGenerator kDFCounterBytesGenerator2 = this;
                kDFCounterBytesGenerator2.generateNext();
                n3 = Math.min(kDFCounterBytesGenerator2.h, n3);
                System.arraycopy(kDFCounterBytesGenerator2.k, 0, byArray, n5, n3);
                kDFCounterBytesGenerator2.generatedBytes += n3;
                n5 = n10 - n3;
                n3 = n9 + n3;
                int n11 = n5;
                n5 = n3;
                n3 = n11;
            }
            return n4;
        }
        throw new DataLengthException(b.a(b.b.a("Current KDFCTR may only be used for "), this.maxSizeExcl, " bytes"));
    }
}

