/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MacDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFDoublePipelineIterationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFDoublePipelineIterationBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputData;
    private int maxSizeExcl;
    private byte[] ios;
    private boolean useCounter;
    private int generatedBytes;
    private byte[] a;
    private byte[] k;

    public KDFDoublePipelineIterationBytesGenerator(Mac mac) {
        int n3;
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
        this.prf = mac;
        kDFDoublePipelineIterationBytesGenerator.h = n3 = mac.getMacSize();
        kDFDoublePipelineIterationBytesGenerator.a = new byte[n3];
        kDFDoublePipelineIterationBytesGenerator.k = new byte[n3];
    }

    private void generateNext() {
        if (this.generatedBytes == 0) {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.prf.update(this.fixedInputData, 0, this.fixedInputData.length);
            kDFDoublePipelineIterationBytesGenerator.prf.doFinal(this.a, 0);
        } else {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.prf.update(this.a, 0, this.a.length);
            kDFDoublePipelineIterationBytesGenerator.prf.doFinal(this.a, 0);
        }
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
        kDFDoublePipelineIterationBytesGenerator.prf.update(this.a, 0, this.a.length);
        if (kDFDoublePipelineIterationBytesGenerator.useCounter) {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator2 = this;
            int n3 = kDFDoublePipelineIterationBytesGenerator2.generatedBytes / this.h + 1;
            byte[] byArray = kDFDoublePipelineIterationBytesGenerator2.ios;
            switch (kDFDoublePipelineIterationBytesGenerator2.ios.length) {
                default: {
                    throw new IllegalStateException("Unsupported size of counter i");
                }
                case 4: {
                    byArray[0] = (byte)(n3 >>> 24);
                }
                case 3: {
                    int n4 = byArray.length - 3;
                    byArray[n4] = (byte)(n3 >>> 16);
                }
                case 2: {
                    int n4 = byArray.length - 2;
                    byArray[n4] = (byte)(n3 >>> 8);
                }
                case 1: 
            }
            int n5 = n3;
            n3 = byArray.length - 1;
            byArray[n3] = (byte)n5;
            this.prf.update(byArray, 0, byArray.length);
        }
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator3 = this;
        kDFDoublePipelineIterationBytesGenerator3.prf.update(this.fixedInputData, 0, this.fixedInputData.length);
        kDFDoublePipelineIterationBytesGenerator3.prf.doFinal(this.k, 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFDoublePipelineIterationParameters) {
            derivationParameters = (KDFDoublePipelineIterationParameters)derivationParameters;
            this.prf.init(new KeyParameter(((KDFDoublePipelineIterationParameters)derivationParameters).getKI()));
            this.fixedInputData = ((KDFDoublePipelineIterationParameters)derivationParameters).getFixedInputData();
            int n3 = ((KDFDoublePipelineIterationParameters)derivationParameters).getR();
            this.ios = new byte[n3 / 8];
            if (((KDFDoublePipelineIterationParameters)derivationParameters).useCounter()) {
                BigInteger bigInteger = TWO.pow(n3).multiply(BigInteger.valueOf(this.h));
                int n4 = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
                this.maxSizeExcl = n4;
            } else {
                this.maxSizeExcl = Integer.MAX_VALUE;
            }
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.useCounter = ((KDFDoublePipelineIterationParameters)derivationParameters).useCounter();
            kDFDoublePipelineIterationBytesGenerator.generatedBytes = 0;
            return;
        }
        throw new IllegalArgumentException("Wrong type of arguments given");
    }

    @Override
    public Mac getMac() {
        return this.prf;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        int n5 = this.generatedBytes;
        int n6 = n5 + n4;
        if (n6 >= 0 && n6 < this.maxSizeExcl) {
            if (n5 % this.h == 0) {
                this.generateNext();
            }
            int n7 = n3;
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            n5 = kDFDoublePipelineIterationBytesGenerator.generatedBytes;
            n6 = kDFDoublePipelineIterationBytesGenerator.h;
            int n8 = n5;
            n5 %= n6;
            n6 = Math.min(n6 - n8 % n6, n4);
            System.arraycopy(kDFDoublePipelineIterationBytesGenerator.k, n5, byArray, n3, n6);
            kDFDoublePipelineIterationBytesGenerator.generatedBytes += n6;
            n3 = n4 - n6;
            n5 = n7 + n6;
            while (n3 > 0) {
                int n9 = n5;
                int n10 = n3;
                KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator2 = this;
                kDFDoublePipelineIterationBytesGenerator2.generateNext();
                n3 = Math.min(kDFDoublePipelineIterationBytesGenerator2.h, n3);
                System.arraycopy(kDFDoublePipelineIterationBytesGenerator2.k, 0, byArray, n5, n3);
                kDFDoublePipelineIterationBytesGenerator2.generatedBytes += n3;
                n5 = n10 - n3;
                n3 = n9 + n3;
                int n11 = n5;
                n5 = n3;
                n3 = n11;
            }
            return n4;
        }
        throw new DataLengthException(b.a(b.b.a("Current KDFCTR may only be used for "), this.maxSizeExcl, " bytes"));
    }
}

