/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] seed;
    private int hLen;

    public MGF1BytesGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    private void ItoOSP(int n3, byte[] byArray) {
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)(n3 >>> 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof MGFParameters) {
            this.seed = ((MGFParameters)derivationParameters).getSeed();
            return;
        }
        throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (byArray.length - n4 >= n3) {
            MGF1BytesGenerator mGF1BytesGenerator = this;
            byte[] byArray2 = new byte[mGF1BytesGenerator.hLen];
            int n5 = 4;
            byte[] byArray3 = new byte[4];
            int n6 = 0;
            mGF1BytesGenerator.digest.reset();
            if (n4 > mGF1BytesGenerator.hLen) {
                do {
                    MGF1BytesGenerator mGF1BytesGenerator2 = this;
                    mGF1BytesGenerator2.ItoOSP(n6, byArray3);
                    mGF1BytesGenerator2.digest.update(this.seed, 0, this.seed.length);
                    mGF1BytesGenerator2.digest.update(byArray3, 0, n5);
                    mGF1BytesGenerator2.digest.doFinal(byArray2, 0);
                    int n7 = mGF1BytesGenerator2.hLen;
                    int n8 = n6 * n7 + n3;
                    System.arraycopy(byArray2, 0, byArray, n8, n7);
                } while (++n6 < n4 / this.hLen);
            }
            if (n6 * this.hLen < n4) {
                int n9 = n6;
                MGF1BytesGenerator mGF1BytesGenerator3 = this;
                mGF1BytesGenerator3.ItoOSP(n6, byArray3);
                mGF1BytesGenerator3.digest.update(this.seed, 0, this.seed.length);
                mGF1BytesGenerator3.digest.update(byArray3, 0, n5);
                mGF1BytesGenerator3.digest.doFinal(byArray2, 0);
                int n10 = mGF1BytesGenerator3.hLen;
                n3 = n9 * n10 + n3;
                n10 = n4 - n9 * n10;
                System.arraycopy(byArray2, 0, byArray, n3, n10);
            }
            return n4;
        }
        throw new OutputLengthException("output buffer too small");
    }
}

