/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;

public class NaccacheSternKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static int[] smallPrimes = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557};
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private NaccacheSternKeyGenerationParameters param;

    private static BigInteger generatePrime(int n3, int n4, SecureRandom secureRandom) {
        BigInteger bigInteger = BigIntegers.createRandomPrime(n3, n4, secureRandom);
        while (bigInteger.bitLength() != n3) {
            bigInteger = BigIntegers.createRandomPrime(n3, n4, secureRandom);
        }
        return bigInteger;
    }

    private static Vector permuteList(Vector vector, SecureRandom secureRandom) {
        Vector vector2;
        Vector vector3;
        Vector vector4 = vector3;
        vector3 = new Vector();
        Vector vector5 = vector2;
        vector2 = new Vector();
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            vector5.addElement(vector.elementAt(i3));
        }
        vector4.addElement(vector5.elementAt(0));
        vector5.removeElementAt(0);
        while (vector5.size() != 0) {
            vector = vector5.elementAt(0);
            vector4.insertElementAt(vector, NaccacheSternKeyPairGenerator.getInt(secureRandom, vector4.size() + 1));
            vector5.removeElementAt(0);
        }
        return vector4;
    }

    private static int getInt(SecureRandom secureRandom, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3;
        if ((n7 & -n7) == n3) {
            return (int)((long)n3 * (long)(secureRandom.nextInt() & Integer.MAX_VALUE) >> 31);
        }
        do {
            n5 = secureRandom.nextInt() & Integer.MAX_VALUE;
        } while (n3 - 1 + (n6 = n5 - (n4 = n5 % n3)) < 0);
        return n4;
    }

    private static Vector findFirstPrimes(int n3) {
        Vector<BigInteger> vector;
        Vector<BigInteger> vector2 = vector;
        vector = new Vector<BigInteger>(n3);
        for (int i3 = 0; i3 != n3; ++i3) {
            vector2.addElement(BigInteger.valueOf(smallPrimes[i3]));
        }
        return vector2;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (NaccacheSternKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters;
        NaccacheSternKeyParameters naccacheSternKeyParameters;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Serializable serializable;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n3;
        NaccacheSternKeyPairGenerator naccacheSternKeyPairGenerator = vector;
        int n4 = naccacheSternKeyPairGenerator.param.getStrength();
        SecureRandom secureRandom = naccacheSternKeyPairGenerator.param.getRandom();
        int n5 = naccacheSternKeyPairGenerator.param.getCertainty();
        boolean bl = naccacheSternKeyPairGenerator.param.isDebug();
        if (bl) {
            System.out.println(b.a("Fetching first ").append(((NaccacheSternKeyPairGenerator)((Object)vector)).param.getCntSmallPrimes()).append(" primes.").toString());
        }
        Vector vector = NaccacheSternKeyPairGenerator.permuteList(NaccacheSternKeyPairGenerator.findFirstPrimes(((NaccacheSternKeyPairGenerator)((Object)vector)).param.getCntSmallPrimes()), secureRandom);
        BigInteger bigInteger6 = ONE;
        BigInteger bigInteger7 = bigInteger6;
        for (n3 = 0; n3 < vector.size() / 2; ++n3) {
            bigInteger7 = bigInteger7.multiply((BigInteger)vector.elementAt(n3));
        }
        for (n3 = vector.size() / 2; n3 < vector.size(); ++n3) {
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n3));
        }
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger6);
        int n6 = (n4 - bigInteger8.bitLength() - 48) / 2 + 1;
        BigInteger bigInteger9 = NaccacheSternKeyPairGenerator.generatePrime(n6, n5, secureRandom);
        BigInteger bigInteger10 = NaccacheSternKeyPairGenerator.generatePrime(n6, n5, secureRandom);
        long l3 = 0L;
        if (bl) {
            System.out.println("generating p and q");
        }
        BigInteger bigInteger11 = bigInteger6;
        bigInteger6 = bigInteger9.multiply(bigInteger7).shiftLeft(1);
        bigInteger7 = bigInteger10.multiply(bigInteger11).shiftLeft(1);
        while (true) {
            ++l3;
            bigInteger5 = NaccacheSternKeyPairGenerator.generatePrime(24, n5, secureRandom);
            bigInteger4 = bigInteger5.multiply(bigInteger6).add(ONE);
            if (!bigInteger4.isProbablePrime(n5)) continue;
            while (true) {
                if (bigInteger5.equals(bigInteger3 = NaccacheSternKeyPairGenerator.generatePrime(24, n5, secureRandom))) {
                    continue;
                }
                serializable = ONE;
                bigInteger2 = bigInteger3.multiply(bigInteger7).add((BigInteger)serializable);
                if (bigInteger2.isProbablePrime(n5)) break;
            }
            if (!bigInteger8.gcd(bigInteger5.multiply(bigInteger3)).equals(serializable)) continue;
            if (bigInteger4.multiply(bigInteger2).bitLength() >= n4) break;
            if (!bl) continue;
            System.out.println("key size too small. Should be " + n4 + " but is actually " + bigInteger4.multiply(bigInteger2).bitLength());
        }
        if (bl) {
            System.out.println("needed " + l3 + " tries to generate p and q.");
        }
        bigInteger6 = bigInteger4.multiply(bigInteger2);
        bigInteger7 = bigInteger4.subtract((BigInteger)serializable).multiply(bigInteger2.subtract((BigInteger)serializable));
        l3 = 0L;
        if (bl) {
            System.out.println("generating g");
        }
        while (true) {
            int n7;
            Vector vector2;
            serializable = vector2;
            vector2 = new Vector();
            for (int i3 = 0; i3 != vector.size(); ++i3) {
                BigInteger bigInteger12;
                BigInteger bigInteger13 = bigInteger7.divide((BigInteger)vector.elementAt(i3));
                do {
                    ++l3;
                } while ((bigInteger12 = BigIntegers.createRandomPrime(n4, n5, secureRandom)).modPow(bigInteger13, bigInteger6).equals(ONE));
                ((Vector)serializable).addElement(bigInteger12);
            }
            bigInteger = ONE;
            for (n7 = 0; n7 < vector.size(); ++n7) {
                bigInteger = bigInteger.multiply(((BigInteger)((Vector)serializable).elementAt(n7)).modPow(bigInteger8.divide((BigInteger)vector.elementAt(n7)), bigInteger6)).mod(bigInteger6);
            }
            boolean bl2 = false;
            for (n7 = 0; n7 < vector.size(); ++n7) {
                if (!bigInteger.modPow(bigInteger7.divide((BigInteger)vector.elementAt(n7)), bigInteger6).equals(ONE)) continue;
                if (bl) {
                    System.out.println(b.a("g has order phi(n)/").append(vector.elementAt(n7)).append("\n g: ").append(bigInteger).toString());
                }
                bl2 = true;
                break;
            }
            if (bl2) continue;
            BigInteger bigInteger14 = ONE;
            if (bigInteger.modPow(bigInteger7.divide(BigInteger.valueOf(4L)), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/4\n g:" + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger5), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/p'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger3), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/q'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger9), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/a\n g: " + bigInteger);
                continue;
            }
            if (!bigInteger.modPow(bigInteger7.divide(bigInteger10), bigInteger6).equals(bigInteger14)) break;
            if (!bl) continue;
            System.out.println("g has order phi(n)/b\n g: " + bigInteger);
        }
        if (bl) {
            System.out.println("needed " + l3 + " tries to generate g");
            System.out.println();
            System.out.println("found new NaccacheStern cipher variables:");
            System.out.println("smallPrimes: " + vector);
            System.out.println("sigma:...... " + bigInteger8 + " (" + bigInteger8.bitLength() + " bits)");
            System.out.println("a:.......... " + bigInteger9);
            System.out.println("b:.......... " + bigInteger10);
            System.out.println("p':......... " + bigInteger5);
            System.out.println("q':......... " + bigInteger3);
            System.out.println("p:.......... " + bigInteger4);
            System.out.println("q:.......... " + bigInteger2);
            System.out.println("n:.......... " + bigInteger6);
            System.out.println("phi(n):..... " + bigInteger7);
            System.out.println("g:.......... " + bigInteger);
            System.out.println();
        }
        NaccacheSternKeyParameters naccacheSternKeyParameters2 = naccacheSternKeyParameters;
        int n8 = bigInteger8.bitLength();
        naccacheSternKeyParameters = new NaccacheSternKeyParameters(false, bigInteger, bigInteger6, n8);
        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters2 = naccacheSternPrivateKeyParameters;
        n5 = bigInteger8.bitLength();
        naccacheSternPrivateKeyParameters = new NaccacheSternPrivateKeyParameters(bigInteger, bigInteger6, n5, vector, bigInteger7);
        return new AsymmetricCipherKeyPair(naccacheSternKeyParameters2, naccacheSternPrivateKeyParameters2);
    }
}

