/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest digest;
    private int u;
    private int v;

    public PKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (digest instanceof ExtendedDigest) {
            this.u = digest.getDigestSize();
            this.v = ((ExtendedDigest)digest).getByteLength();
            return;
        }
        throw new IllegalArgumentException(b.a("Digest ").append(digest.getAlgorithmName()).append(" unsupported").toString());
    }

    private void adjust(byte[] byArray, int n3, byte[] byArray2) {
        int n4 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n3 + byArray2.length - 1] & 0xFF) + 1;
        int n5 = n3 + byArray2.length - 1;
        byArray[n5] = (byte)n4;
        n5 = n4 >>> 8;
        for (int i3 = byArray2.length - 2; i3 >= 0; --i3) {
            int n6 = n3 + i3;
            n5 = (byArray2[i3] & 0xFF) + (byArray[n6] & 0xFF) + n5;
            byArray[n6] = (byte)n5;
            n5 >>>= 8;
        }
    }

    private byte[] generateDerivedKey(int n3, int n4) {
        int n5;
        byte[] byArray;
        byte[] byArray2;
        int n6 = this.v;
        byte[] byArray3 = new byte[n6];
        byte[] byArray4 = new byte[n4];
        for (int i3 = 0; i3 != n6; ++i3) {
            byArray3[i3] = (byte)n3;
        }
        byte[] byArray5 = this.salt;
        if (this.salt != null && byArray5.length != 0) {
            int n7 = this.v;
            n7 = (byArray5.length + n7 - 1) / n7 * n7;
            byArray2 = new byte[n7];
            for (int i4 = 0; i4 != n7; ++i4) {
                byArray2[i4] = this.salt[i4 % this.salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        byte[] byArray6 = this.password;
        if (this.password != null && byArray6.length != 0) {
            int n8 = this.v;
            n8 = (byArray6.length + n8 - 1) / n8 * n8;
            byArray = new byte[n8];
            for (n5 = 0; n5 != n8; ++n5) {
                byArray[n5] = this.password[n5 % this.password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        PKCS12ParametersGenerator pKCS12ParametersGenerator = this;
        byte[] byArray7 = byArray2;
        byte[] byArray8 = byArray2;
        int n9 = byArray7.length + byArray.length;
        byArray2 = new byte[n9];
        int n10 = byArray8.length;
        System.arraycopy(byArray7, 0, byArray2, 0, n10);
        n10 = byArray8.length;
        n5 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, n10, n5);
        n10 = pKCS12ParametersGenerator.v;
        byte[] byArray9 = new byte[n10];
        int n11 = pKCS12ParametersGenerator.u;
        int n12 = (n4 + n11 - 1) / n11;
        byte[] byArray10 = new byte[n11];
        for (int i5 = 1; i5 <= n12; ++i5) {
            int n13;
            int n14;
            PKCS12ParametersGenerator pKCS12ParametersGenerator2 = this;
            pKCS12ParametersGenerator2.digest.update(byArray3, 0, n6);
            pKCS12ParametersGenerator2.digest.update(byArray2, 0, n9);
            pKCS12ParametersGenerator2.digest.doFinal(byArray10, 0);
            for (n14 = 1; n14 < this.iterationCount; ++n14) {
                PKCS12ParametersGenerator pKCS12ParametersGenerator3 = this;
                pKCS12ParametersGenerator3.digest.update(byArray10, 0, n11);
                pKCS12ParametersGenerator3.digest.doFinal(byArray10, 0);
            }
            for (n14 = 0; n14 != n10; ++n14) {
                byArray9[n14] = byArray10[n14 % n11];
            }
            for (n14 = 0; n14 != n9 / (n13 = this.v); ++n14) {
                this.adjust(byArray2, n14 * n13, byArray9);
            }
            if (i5 == n12) {
                int n15 = i5 - 1;
                n14 = this.u;
                n13 = n15 * n14;
                n14 = n4 - n15 * n14;
                System.arraycopy(byArray10, 0, byArray4, n13, n14);
                continue;
            }
            n14 = (i5 - 1) * this.u;
            System.arraycopy(byArray10, 0, byArray4, n14, n11);
        }
        return byArray4;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n3) {
        int n4 = n3 / 8;
        byte[] byArray = this.generateDerivedKey(1, n4);
        return new KeyParameter(byArray, 0, n4);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n3, int n4) {
        KeyParameter keyParameter;
        PKCS12ParametersGenerator pKCS12ParametersGenerator = this;
        int n5 = n3 / 8;
        n3 = n4 / 8;
        byte[] byArray = pKCS12ParametersGenerator.generateDerivedKey(1, n5);
        byte[] byArray2 = pKCS12ParametersGenerator.generateDerivedKey(2, n3);
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(byArray, 0, n5);
        return new ParametersWithIV(keyParameter2, byArray2, 0, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n3) {
        int n4 = n3 / 8;
        byte[] byArray = this.generateDerivedKey(3, n4);
        return new KeyParameter(byArray, 0, n4);
    }
}

