/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Salsa20Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SCrypt {
    private SCrypt() {
    }

    public static byte[] generate(byte[] byArray, byte[] byArray2, int n3, int n4, int n5, int n6) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (n3 > 1 && SCrypt.isPowerOf2(n3)) {
                    if (n4 == 1 && n3 >= 65536) {
                        throw new IllegalArgumentException("Cost parameter N must be > 1 and < 65536.");
                    }
                    if (n4 >= 1) {
                        int n7 = Integer.MAX_VALUE / (n4 * 128 * 8);
                        if (n5 >= 1 && n5 <= n7) {
                            if (n6 >= 1) {
                                return SCrypt.MFcrypt(byArray, byArray2, n3, n4, n5, n6);
                            }
                            throw new IllegalArgumentException("Generated key length dkLen must be >= 1.");
                        }
                        throw new IllegalArgumentException("Parallelisation parameter p must be >= 1 and <= " + n7 + " (based on block size r of " + n4 + ")");
                    }
                    throw new IllegalArgumentException("Block size r must be >= 1.");
                }
                throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
            }
            throw new IllegalArgumentException("Salt S must be provided.");
        }
        throw new IllegalArgumentException("Passphrase P must be provided.");
    }

    private static byte[] MFcrypt(byte[] byArray, byte[] byArray2, int n3, int n4, int n5, int n6) {
        byte[] byArray3;
        int n7;
        int n8 = n4 * 128;
        byte[] byArray4 = SCrypt.SingleIterationPBKDF2(byArray, byArray2, n5 * n8);
        int[] nArray = null;
        int n9 = byArray4.length >>> 2;
        nArray = new int[n9];
        Pack.littleEndianToInt(byArray4, 0, nArray);
        int n10 = 0;
        for (n7 = n3 * n4; n3 - n10 > 2 && n7 > 1024; n7 >>>= 1) {
            ++n10;
        }
        n8 >>>= 2;
        for (n7 = 0; n7 < n9; n7 += n8) {
            SCrypt.SMix(nArray, n7, n3, n10, n4);
            continue;
        }
        try {
            Pack.intToLittleEndian(nArray, byArray4, 0);
            byArray3 = SCrypt.SingleIterationPBKDF2(byArray, byArray4, n6);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(byArray4);
            SCrypt.Clear(nArray);
            throw throwable;
        }
        SCrypt.Clear(byArray4);
        SCrypt.Clear(nArray);
        return byArray3;
    }

    private static byte[] SingleIterationPBKDF2(byte[] byArray, byte[] byArray2, int n3) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator2 = pKCS5S2ParametersGenerator;
        pKCS5S2ParametersGenerator2(new SHA256Digest());
        pKCS5S2ParametersGenerator2.init(byArray, byArray2, 1);
        return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedMacParameters(n3 * 8)).getKey();
    }

    private static void SMix(int[] nArray, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n4;
        int n9 = Integers.numberOfTrailingZeros(n8);
        int n10 = n8 >>> n5;
        int n11 = 1 << n5;
        int n12 = n5;
        n5 = n10 - 1;
        n9 -= n12;
        int n13 = n6 * 32;
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[n13];
        int[] nArray5 = new int[n13];
        int[][] nArrayArray = new int[n11][];
        System.arraycopy(nArray, n3, nArray5, 0, n13);
        for (n7 = 0; n7 < n11; ++n7) {
            int[] nArray6 = new int[n10 * n13];
            nArrayArray[n7] = nArray6;
            int n14 = 0;
            for (int i3 = 0; i3 < n10; i3 += 2) {
                int[] nArray7 = nArray4;
                int[] nArray8 = nArray2;
                System.arraycopy(nArray5, 0, nArray6, n14, n13);
                n14 += n13;
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n6);
                System.arraycopy(nArray4, 0, nArray6, n14, n13);
                n14 += n13;
                SCrypt.BlockMix(nArray7, nArray8, nArray3, nArray5, n6);
                continue;
            }
        }
        n10 = n4 - 1;
        for (n11 = 0; n11 < n4; ++n11) {
            n7 = nArray5[n13 - 16] & n10;
            int[] nArray9 = nArrayArray[n7 >>> n9];
            System.arraycopy(nArray9, (n7 & n5) * n13, nArray4, 0, n13);
            SCrypt.Xor(nArray4, nArray5, 0, nArray4);
            SCrypt.BlockMix(nArray4, nArray2, nArray3, nArray5, n6);
            continue;
        }
        try {
            System.arraycopy(nArray5, 0, nArray, n3, n13);
            SCrypt.ClearAll(nArrayArray);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(nArrayArray);
            SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
            throw throwable;
        }
        SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
    }

    private static void BlockMix(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n3) {
        int n4 = n3;
        int[] nArray5 = nArray;
        System.arraycopy(nArray5, nArray5.length - 16, nArray2, 0, 16);
        n3 = 0;
        int n5 = 0;
        int n6 = nArray.length >>> 1;
        for (int i3 = (v822030) * 2; i3 > 0; --i3) {
            SCrypt.Xor(nArray2, nArray, n3, nArray3);
            Salsa20Engine.salsaCore(8, nArray3, nArray2);
            System.arraycopy(nArray2, 0, nArray4, n5, 16);
            n5 = n6 + n3 - n5;
            n3 += 16;
        }
    }

    private static void Xor(int[] nArray, int[] nArray2, int n3, int[] nArray3) {
        for (int i3 = nArray3.length - 1; i3 >= 0; --i3) {
            nArray3[i3] = nArray[i3] ^ nArray2[n3 + i3];
        }
    }

    private static void Clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    private static void Clear(int[] nArray) {
        if (nArray != null) {
            Arrays.fill(nArray, 0);
        }
    }

    private static void ClearAll(int[][] nArray) {
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            SCrypt.Clear(nArray[i3]);
        }
    }

    private static boolean isPowerOf2(int n3) {
        int n4 = n3;
        return (n4 & n4 - 1) == 0;
    }
}

