/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SkippingCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.CipherIOException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.InvalidCipherTextIOException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import f.a;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private static final int INPUT_BUF_SIZE = 2048;
    private SkippingCipher skippingCipher;
    private byte[] inBuf;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private byte[] buf;
    private byte[] markBuf;
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private long markPosition;
    private int markBufOff;

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher) {
        this(inputStream, bufferedBlockCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher) {
        this(inputStream, streamCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher) {
        this(inputStream, aEADBlockCipher, 2048);
    }

    public CipherInputStream(InputStream object, BufferedBlockCipher bufferedBlockCipher, int n3) {
        super((InputStream)object);
        this.bufferedBlockCipher = bufferedBlockCipher;
        this.inBuf = new byte[n3];
        object = bufferedBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)bufferedBlockCipher) : null;
        this.skippingCipher = object;
    }

    public CipherInputStream(InputStream object, StreamCipher streamCipher, int n3) {
        super((InputStream)object);
        this.streamCipher = streamCipher;
        this.inBuf = new byte[n3];
        object = streamCipher instanceof SkippingCipher ? (SkippingCipher)((Object)streamCipher) : null;
        this.skippingCipher = object;
    }

    public CipherInputStream(InputStream object, AEADBlockCipher aEADBlockCipher, int n3) {
        super((InputStream)object);
        this.aeadBlockCipher = aEADBlockCipher;
        this.inBuf = new byte[n3];
        object = aEADBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)aEADBlockCipher) : null;
        this.skippingCipher = object;
    }

    /*
     * Unable to fully structure code
     */
    private int nextChunk() {
        if (this.finalized) {
            return -1;
        }
        v0 = this;
        v0.bufOff = 0;
        v0.maxBuf = 0;
        block11: while ((var1_3 = this.maxBuf) == 0) {
            var1_3 = this.in.read(this.inBuf);
            if (var1_3 == -1) {
                v1 = this;
                v1.finaliseCipher();
                var0_1 = v1.maxBuf;
                if (var0_1 == 0) {
                    return -1;
                }
                return var0_1;
            }
            v2 = this;
            v2.ensureCapacity(var1_3, false);
            var2_4 = v2.bufferedBlockCipher;
            if (var2_4 == null) ** GOTO lbl34
            v3 = this;
            v4 = var2_4;
            v5 = this;
            v6 = v5;
            var2_4 = v5.inBuf;
            var3_5 = 0;
            var4_6 = v6.buf;
            v7 = v4.processBytes((byte[])var2_4, var3_5, var1_3, var4_6, 0);
lbl31:
            // 2 sources

            while (true) {
                v3.maxBuf = v7;
                continue block11;
                break;
            }
lbl34:
            // 1 sources

            var2_4 = this.aeadBlockCipher;
            if (var2_4 == null) ** GOTO lbl50
            try {
                v3 = this;
                v8 = var2_4;
                v9 = this;
                v10 = v9;
                var2_4 = v9.inBuf;
                var3_5 = 0;
            }
            catch (Exception var0_2) {
                throw new CipherIOException("Error processing stream ", var0_2);
            }
            var4_6 = v10.buf;
            v7 = v8.processBytes((byte[])var2_4, var3_5, var1_3, var4_6, 0);
            ** continue;
lbl50:
            // 1 sources

            v11 = this;
            v12 = var1_3;
            v13 = this.streamCipher;
            v14 = this;
            v15 = v14;
            var2_4 = v14.inBuf;
            var3_5 = 0;
            var4_6 = v15.buf;
            v13.processBytes((byte[])var2_4, var3_5, var1_3, var4_6, 0);
            v11.maxBuf = v12;
        }
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    private void finaliseCipher() {
        block7: {
            v0 = this;
            v0.finalized = true;
            v0.ensureCapacity(0, true);
            var1_3 = v0.bufferedBlockCipher;
            if (var1_3 == null) break block7;
            v1 = var1_3.doFinal(this.buf, 0);
lbl9:
            // 2 sources

            while (true) {
                var1_4 = v1;
                ** GOTO lbl19
                break;
            }
        }
        var1_3 = this.aeadBlockCipher;
        if (var1_3 == null) ** GOTO lbl21
        try {
            block8: {
                v1 = var1_3.doFinal(this.buf, 0);
                ** continue;
lbl19:
                // 1 sources

                this.maxBuf = var1_4;
                break block8;
lbl21:
                // 1 sources

                this.maxBuf = 0;
            }
            return;
        }
        catch (Exception var0_1) {
            throw new IOException(a.a("Error finalising cipher ", var0_1));
        }
        catch (InvalidCipherTextException var0_2) {
            throw new InvalidCipherTextIOException("Error finalising cipher", var0_2);
        }
    }

    private void ensureCapacity(int n3, boolean bl) {
        Object object;
        if (bl) {
            object = this.bufferedBlockCipher;
            if (object != null) {
                n3 = ((BufferedBlockCipher)object).getOutputSize(n3);
            } else {
                object = this.aeadBlockCipher;
                if (object != null) {
                    n3 = object.getOutputSize(n3);
                }
            }
        } else {
            object = this.bufferedBlockCipher;
            if (object != null) {
                n3 = ((BufferedBlockCipher)object).getUpdateOutputSize(n3);
            } else {
                object = this.aeadBlockCipher;
                if (object != null) {
                    n3 = object.getUpdateOutputSize(n3);
                }
            }
        }
        object = this.buf;
        if (this.buf == null || ((Object)object).length < n3) {
            this.buf = new byte[n3];
        }
    }

    @Override
    public int read() {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        return this.buf[n3] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n3, int n4) {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        n4 = Math.min(n4, this.available());
        CipherInputStream cipherInputStream = this;
        System.arraycopy(cipherInputStream.buf, this.bufOff, byArray, n3, n4);
        cipherInputStream.bufOff += n4;
        return n4;
    }

    @Override
    public long skip(long l3) {
        if (l3 <= 0L) {
            return 0L;
        }
        if (this.skippingCipher != null) {
            long l4 = this.available();
            if (l3 <= l4) {
                this.bufOff = (int)((long)this.bufOff + l3);
                return l3;
            }
            CipherInputStream cipherInputStream = this;
            cipherInputStream.bufOff = cipherInputStream.maxBuf;
            if ((l3 = cipherInputStream.in.skip(l3 - l4)) == this.skippingCipher.skip(l3)) {
                return l3 + l4;
            }
            throw new IOException("Unable to skip cipher " + l3 + " bytes.");
        }
        int n3 = (int)Math.min(l3, (long)this.available());
        this.bufOff += n3;
        return n3;
    }

    @Override
    public int available() {
        return this.maxBuf - this.bufOff;
    }

    @Override
    public void close() {
        byte[] byArray;
        block5: {
            try {
                CipherInputStream cipherInputStream = this;
                cipherInputStream.in.close();
                if (!cipherInputStream.finalized) {
                    this.finaliseCipher();
                }
                CipherInputStream cipherInputStream2 = this;
                cipherInputStream2.bufOff = 0;
                cipherInputStream2.maxBuf = 0;
                cipherInputStream2.markBufOff = 0;
                cipherInputStream2.markPosition = 0L;
                byArray = cipherInputStream2.markBuf;
                if (cipherInputStream2.markBuf == null) break block5;
            }
            catch (Throwable throwable) {
                if (!this.finalized) {
                    this.finaliseCipher();
                }
                throw throwable;
            }
            Arrays.fill(byArray, (byte)0);
            this.markBuf = null;
        }
        byArray = this.buf;
        if (this.buf != null) {
            Arrays.fill(byArray, (byte)0);
            this.buf = null;
        }
        Arrays.fill(this.inBuf, (byte)0);
    }

    @Override
    public void mark(int n3) {
        CipherInputStream cipherInputStream = this;
        cipherInputStream.in.mark(n3);
        Object object = cipherInputStream.skippingCipher;
        if (object != null) {
            this.markPosition = object.getPosition();
        }
        object = this.buf;
        if (this.buf != null) {
            Object object2 = object;
            byte[] byArray = new byte[((Object)object).length];
            object = byArray;
            this.markBuf = byArray;
            int n4 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, 0, n4);
        }
        this.markBufOff = this.bufOff;
    }

    @Override
    public void reset() {
        if (this.skippingCipher != null) {
            CipherInputStream cipherInputStream = this;
            cipherInputStream.in.reset();
            cipherInputStream.skippingCipher.seekTo(this.markPosition);
            byte[] byArray = cipherInputStream.markBuf;
            if (cipherInputStream.markBuf != null) {
                this.buf = byArray;
            }
            this.bufOff = this.markBufOff;
            return;
        }
        throw new IOException("cipher must implement SkippingCipher to be used with reset()");
    }

    @Override
    public boolean markSupported() {
        if (this.skippingCipher != null) {
            return this.in.markSupported();
        }
        return false;
    }
}

