/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.kems;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyEncapsulation;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom, boolean bl, boolean bl2, boolean bl3) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = bl;
        this.OldCofactorMode = bl ? false : bl2;
        this.SingleHashMode = bl3;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ECKeyParameters) {
            this.key = (ECKeyParameters)cipherParameters;
            return;
        }
        throw new IllegalArgumentException("EC key required");
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n3, int n4) {
        ECKeyParameters eCKeyParameters = ((ECIESKeyEncapsulation)object).key;
        if (eCKeyParameters instanceof ECPublicKeyParameters) {
            eCKeyParameters = (ECPublicKeyParameters)eCKeyParameters;
            ECDomainParameters eCDomainParameters = eCKeyParameters.getParameters();
            ECCurve eCCurve = eCDomainParameters.getCurve();
            BigInteger bigInteger = eCDomainParameters.getN();
            BigInteger bigInteger2 = eCDomainParameters.getH();
            BigInteger bigInteger3 = BigIntegers.createRandomInRange(ONE, bigInteger, ((ECIESKeyEncapsulation)object).rnd);
            bigInteger = ((ECIESKeyEncapsulation)object).OldCofactorMode ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
            ECIESKeyEncapsulation eCIESKeyEncapsulation = object;
            Object object = ((ECIESKeyEncapsulation)object).createBasePointMultiplier();
            Object[] objectArray = new ECPoint[]{object.multiply(eCDomainParameters.getG(), bigInteger3), ((ECPublicKeyParameters)eCKeyParameters).getQ().multiply(bigInteger)};
            eCCurve.normalizeAll((ECPoint[])objectArray);
            object = objectArray[1];
            objectArray = objectArray[0].getEncoded(false);
            int n5 = objectArray.length;
            System.arraycopy(objectArray, 0, byArray, n3, n5);
            return eCIESKeyEncapsulation.deriveKey(n4, (byte[])objectArray, ((ECPoint)object).getAffineXCoord().getEncoded());
        }
        throw new IllegalArgumentException("Public key required for encryption");
    }

    public CipherParameters encrypt(byte[] byArray, int n3) {
        return this.encrypt(byArray, 0, n3);
    }

    @Override
    public CipherParameters decrypt(byte[] object, int n3, int n4, int n5) {
        ECKeyParameters eCKeyParameters = this.key;
        if (eCKeyParameters instanceof ECPrivateKeyParameters) {
            eCKeyParameters = (ECPrivateKeyParameters)eCKeyParameters;
            ECDomainParameters eCDomainParameters = eCKeyParameters.getParameters();
            ECCurve eCCurve = eCDomainParameters.getCurve();
            byte[] byArray = object;
            ECDomainParameters eCDomainParameters2 = eCDomainParameters;
            object = eCDomainParameters2.getN();
            BigInteger bigInteger = eCDomainParameters2.getH();
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            ECPoint eCPoint = eCCurve.decodePoint(byArray2);
            if (this.CofactorMode || this.OldCofactorMode) {
                eCPoint = eCPoint.multiply(bigInteger);
            }
            bigInteger = ((ECPrivateKeyParameters)eCKeyParameters).getD();
            if (this.CofactorMode) {
                bigInteger = bigInteger.multiply(eCDomainParameters.getHInv()).mod((BigInteger)object);
            }
            return this.deriveKey(n5, byArray2, eCPoint.multiply(bigInteger).normalize().getAffineXCoord().getEncoded());
        }
        throw new IllegalArgumentException("Private key required for encryption");
    }

    public CipherParameters decrypt(byte[] byArray, int n3) {
        return this.decrypt(byArray, 0, byArray.length, n3);
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    public KeyParameter deriveKey(int n3, byte[] byArray, byte[] byArray2) {
        ECIESKeyEncapsulation eCIESKeyEncapsulation;
        if (!((ECIESKeyEncapsulation)object).SingleHashMode) {
            byte[] byArray3 = byArray2;
            byArray2 = Arrays.concatenate(byArray, byArray2);
            Arrays.fill(byArray3, (byte)0);
        }
        try {
            eCIESKeyEncapsulation = object;
            ((ECIESKeyEncapsulation)object).kdf.init(new KDFParameters(byArray2, null));
            Object object = new byte[n3];
        }
        catch (Throwable throwable) {
            Arrays.fill(byArray2, (byte)0);
            throw throwable;
        }
        DerivationFunction derivationFunction = eCIESKeyEncapsulation.kdf;
        derivationFunction.generateBytes((byte[])object, 0, n3);
        KeyParameter keyParameter = new KeyParameter((byte[])object);
        Arrays.fill(byArray2, (byte)0);
        return keyParameter;
    }
}

