/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.kems;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyEncapsulation;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private RSAKeyParameters key;

    public RSAKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof RSAKeyParameters) {
            this.key = (RSAKeyParameters)cipherParameters;
            return;
        }
        throw new IllegalArgumentException("RSA key required");
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n3, int n4) {
        if (!((RSAKeyEncapsulation)object).key.isPrivate()) {
            RSAKeyEncapsulation rSAKeyEncapsulation = object;
            BigInteger bigInteger = rSAKeyEncapsulation.key.getModulus();
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = ((RSAKeyEncapsulation)object).key.getExponent();
            RSAKeyEncapsulation rSAKeyEncapsulation2 = object;
            Object object = bigInteger2.subtract(ONE);
            object = BigIntegers.createRandomInRange(ZERO, (BigInteger)object, rSAKeyEncapsulation2.rnd);
            bigInteger2 = ((BigInteger)object).modPow(bigInteger3, bigInteger2);
            byte[] byArray2 = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger2);
            int n5 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n5);
            return rSAKeyEncapsulation.generateKey(bigInteger, (BigInteger)object, n4);
        }
        throw new IllegalArgumentException("Public key required for encryption");
    }

    public CipherParameters encrypt(byte[] byArray, int n3) {
        return this.encrypt(byArray, 0, n3);
    }

    @Override
    public CipherParameters decrypt(byte[] object, int n3, int n4, int n5) {
        if (((RSAKeyEncapsulation)((Object)bigInteger2)).key.isPrivate()) {
            BigInteger bigInteger;
            RSAKeyEncapsulation rSAKeyEncapsulation = bigInteger2;
            byte[] byArray = object;
            RSAKeyEncapsulation rSAKeyEncapsulation2 = bigInteger2;
            BigInteger bigInteger2 = rSAKeyEncapsulation2.key.getModulus();
            object = rSAKeyEncapsulation2.key.getExponent();
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            BigInteger bigInteger3 = bigInteger;
            bigInteger3(1, byArray2);
            return rSAKeyEncapsulation.generateKey(bigInteger2, bigInteger.modPow((BigInteger)object, bigInteger2), n5);
        }
        throw new IllegalArgumentException("Private key required for decryption");
    }

    public CipherParameters decrypt(byte[] byArray, int n3) {
        return this.decrypt(byArray, 0, byArray.length, n3);
    }

    public KeyParameter generateKey(BigInteger bigInteger, BigInteger bigInteger2, int n3) {
        RSAKeyEncapsulation rSAKeyEncapsulation = object;
        RSAKeyEncapsulation rSAKeyEncapsulation2 = object;
        Object object = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger2);
        rSAKeyEncapsulation2.kdf.init(new KDFParameters((byte[])object, null));
        object = new byte[n3];
        rSAKeyEncapsulation.kdf.generateBytes((byte[])object, 0, n3);
        return new KeyParameter((byte[])object);
    }
}

