/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;

public class BlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;

    public BlockCipherMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8 / 2);
    }

    public BlockCipherMac(BlockCipher blockCipher, int n3) {
        if (n3 % 8 == 0) {
            BlockCipherMac blockCipherMac = this;
            this.cipher = new CBCBlockCipher(blockCipher);
            this.macSize = n3 / 8;
            this.mac = new byte[blockCipher.getBlockSize()];
            blockCipherMac.buf = new byte[blockCipher.getBlockSize()];
            blockCipherMac.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        BlockCipherMac blockCipherMac = this;
        blockCipherMac.reset();
        blockCipherMac.cipher.init(true, cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5;
            int n6 = ((BlockCipherMac)object).cipher.getBlockSize();
            int n7 = n6 - (n5 = ((BlockCipherMac)object).bufOff);
            if (n4 > n7) {
                int n8 = n3;
                System.arraycopy(byArray, n3, ((BlockCipherMac)object).buf, n5, n7);
                Object object = object;
                byte[] byArray2 = ((BlockCipherMac)object).buf;
                byte[] byArray3 = ((BlockCipherMac)object).mac;
                ((BlockCipherMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((BlockCipherMac)object).bufOff = 0;
                n3 = n4 - n7;
                n4 = n8 + n7;
                int n9 = n3;
                n3 = n4;
                n4 = n9;
                while (n4 > n6) {
                    int n10 = n3;
                    ((BlockCipherMac)object).cipher.processBlock(byArray, n3, ((BlockCipherMac)object).mac, 0);
                    n3 = n4 - n6;
                    n4 = n10 + n6;
                    int n11 = n3;
                    n3 = n4;
                    n4 = n11;
                }
            }
            BlockCipherMac blockCipherMac = object;
            BlockCipherMac blockCipherMac2 = object;
            Object object = blockCipherMac2.buf;
            System.arraycopy(byArray, n3, object, blockCipherMac2.bufOff, n4);
            blockCipherMac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        int n4;
        int n5 = this.cipher.getBlockSize();
        while ((n4 = this.bufOff) < n5) {
            this.buf[n4] = 0;
            this.bufOff = n4 + 1;
        }
        BlockCipherMac blockCipherMac = this;
        BlockCipherMac blockCipherMac2 = this;
        byte[] byArray2 = blockCipherMac2.buf;
        byte[] byArray3 = blockCipherMac2.mac;
        blockCipherMac.cipher.processBlock(byArray2, 0, byArray3, 0);
        int n6 = this.macSize;
        System.arraycopy(blockCipherMac.mac, 0, byArray, n3, n6);
        blockCipherMac.reset();
        return blockCipherMac.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

