/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CBCBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;

    public CBCBlockCipherMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8 / 2, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n3) {
        this(blockCipher, n3, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n3, BlockCipherPadding blockCipherPadding) {
        if (n3 % 8 == 0) {
            CBCBlockCipherMac cBCBlockCipherMac = this;
            this.cipher = new CBCBlockCipher(blockCipher);
            this.padding = blockCipherPadding;
            this.macSize = n3 / 8;
            this.mac = new byte[blockCipher.getBlockSize()];
            cBCBlockCipherMac.buf = new byte[blockCipher.getBlockSize()];
            cBCBlockCipherMac.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        CBCBlockCipherMac cBCBlockCipherMac = this;
        cBCBlockCipherMac.reset();
        cBCBlockCipherMac.cipher.init(true, cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5;
            int n6 = ((CBCBlockCipherMac)object).cipher.getBlockSize();
            int n7 = n6 - (n5 = ((CBCBlockCipherMac)object).bufOff);
            if (n4 > n7) {
                int n8 = n3;
                System.arraycopy(byArray, n3, ((CBCBlockCipherMac)object).buf, n5, n7);
                Object object = object;
                byte[] byArray2 = ((CBCBlockCipherMac)object).buf;
                byte[] byArray3 = ((CBCBlockCipherMac)object).mac;
                ((CBCBlockCipherMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((CBCBlockCipherMac)object).bufOff = 0;
                n3 = n4 - n7;
                n4 = n8 + n7;
                int n9 = n3;
                n3 = n4;
                n4 = n9;
                while (n4 > n6) {
                    int n10 = n3;
                    ((CBCBlockCipherMac)object).cipher.processBlock(byArray, n3, ((CBCBlockCipherMac)object).mac, 0);
                    n3 = n4 - n6;
                    n4 = n10 + n6;
                    int n11 = n3;
                    n3 = n4;
                    n4 = n11;
                }
            }
            CBCBlockCipherMac cBCBlockCipherMac = object;
            CBCBlockCipherMac cBCBlockCipherMac2 = object;
            Object object = cBCBlockCipherMac2.buf;
            System.arraycopy(byArray, n3, object, cBCBlockCipherMac2.bufOff, n4);
            cBCBlockCipherMac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        CBCBlockCipherMac cBCBlockCipherMac = this;
        int n4 = cBCBlockCipherMac.cipher.getBlockSize();
        if (cBCBlockCipherMac.padding == null) {
            int n5;
            while ((n5 = this.bufOff) < n4) {
                this.buf[n5] = 0;
                this.bufOff = n5 + 1;
            }
        } else {
            if (this.bufOff == n4) {
                CBCBlockCipherMac cBCBlockCipherMac2 = this;
                byte[] byArray2 = cBCBlockCipherMac2.buf;
                byte[] byArray3 = cBCBlockCipherMac2.mac;
                this.cipher.processBlock(byArray2, 0, byArray3, 0);
                this.bufOff = 0;
            }
            CBCBlockCipherMac cBCBlockCipherMac3 = this;
            byte[] byArray4 = cBCBlockCipherMac3.buf;
            this.padding.addPadding(byArray4, cBCBlockCipherMac3.bufOff);
        }
        CBCBlockCipherMac cBCBlockCipherMac4 = this;
        CBCBlockCipherMac cBCBlockCipherMac5 = this;
        byte[] byArray5 = cBCBlockCipherMac5.buf;
        byte[] byArray6 = cBCBlockCipherMac5.mac;
        cBCBlockCipherMac4.cipher.processBlock(byArray5, 0, byArray6, 0);
        int n6 = this.macSize;
        System.arraycopy(cBCBlockCipherMac4.mac, 0, byArray, n3, n6);
        cBCBlockCipherMac4.reset();
        return cBCBlockCipherMac4.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

