/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.MacCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private MacCFBBlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;

    public CFBBlockCipherMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, 8, blockCipher2.getBlockSize() * 8 / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, 8, blockCipher2.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n3, int n4) {
        this(blockCipher, n3, n4, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n3, int n4, BlockCipherPadding blockCipherPadding) {
        ((CFBBlockCipherMac)((Object)macCFBBlockCipher2)).padding = null;
        if (n4 % 8 == 0) {
            MacCFBBlockCipher macCFBBlockCipher;
            CFBBlockCipherMac cFBBlockCipherMac = macCFBBlockCipher2;
            CFBBlockCipherMac cFBBlockCipherMac2 = macCFBBlockCipher2;
            CFBBlockCipherMac cFBBlockCipherMac3 = macCFBBlockCipher2;
            cFBBlockCipherMac3.mac = new byte[blockCipher.getBlockSize()];
            MacCFBBlockCipher macCFBBlockCipher2 = macCFBBlockCipher;
            cFBBlockCipherMac3.cipher = new MacCFBBlockCipher(blockCipher, n3);
            cFBBlockCipherMac2.padding = blockCipherPadding;
            cFBBlockCipherMac.macSize = n4 / 8;
            cFBBlockCipherMac.buf = new byte[macCFBBlockCipher2.getBlockSize()];
            cFBBlockCipherMac.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        CFBBlockCipherMac cFBBlockCipherMac = this;
        cFBBlockCipherMac.reset();
        cFBBlockCipherMac.cipher.init(cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5;
            int n6 = ((CFBBlockCipherMac)object).cipher.getBlockSize();
            int n7 = n6 - (n5 = ((CFBBlockCipherMac)object).bufOff);
            if (n4 > n7) {
                int n8 = n3;
                System.arraycopy(byArray, n3, ((CFBBlockCipherMac)object).buf, n5, n7);
                Object object = object;
                byte[] byArray2 = ((CFBBlockCipherMac)object).buf;
                byte[] byArray3 = ((CFBBlockCipherMac)object).mac;
                ((CFBBlockCipherMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((CFBBlockCipherMac)object).bufOff = 0;
                n3 = n4 - n7;
                n4 = n8 + n7;
                int n9 = n3;
                n3 = n4;
                n4 = n9;
                while (n4 > n6) {
                    int n10 = n3;
                    ((CFBBlockCipherMac)object).cipher.processBlock(byArray, n3, ((CFBBlockCipherMac)object).mac, 0);
                    n3 = n4 - n6;
                    n4 = n10 + n6;
                    int n11 = n3;
                    n3 = n4;
                    n4 = n11;
                }
            }
            CFBBlockCipherMac cFBBlockCipherMac = object;
            CFBBlockCipherMac cFBBlockCipherMac2 = object;
            Object object = cFBBlockCipherMac2.buf;
            System.arraycopy(byArray, n3, object, cFBBlockCipherMac2.bufOff, n4);
            cFBBlockCipherMac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        CFBBlockCipherMac cFBBlockCipherMac = this;
        int n4 = cFBBlockCipherMac.cipher.getBlockSize();
        BlockCipherPadding blockCipherPadding = cFBBlockCipherMac.padding;
        if (blockCipherPadding == null) {
            int n5;
            while ((n5 = this.bufOff) < n4) {
                this.buf[n5] = 0;
                this.bufOff = n5 + 1;
            }
        } else {
            CFBBlockCipherMac cFBBlockCipherMac2 = this;
            byte[] byArray2 = cFBBlockCipherMac2.buf;
            blockCipherPadding.addPadding(byArray2, cFBBlockCipherMac2.bufOff);
        }
        CFBBlockCipherMac cFBBlockCipherMac3 = this;
        CFBBlockCipherMac cFBBlockCipherMac4 = this;
        byte[] byArray3 = cFBBlockCipherMac4.buf;
        byte[] byArray4 = cFBBlockCipherMac4.mac;
        cFBBlockCipherMac3.cipher.processBlock(byArray3, 0, byArray4, 0);
        cFBBlockCipherMac3.cipher.getMacBlock(this.mac);
        int n6 = this.macSize;
        System.arraycopy(cFBBlockCipherMac3.mac, 0, byArray, n3, n6);
        cFBBlockCipherMac3.reset();
        return cFBBlockCipherMac3.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

