/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class CMac
implements Mac {
    private byte[] poly;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8);
    }

    public CMac(BlockCipher blockCipher, int n3) {
        if (n3 % 8 == 0) {
            if (n3 <= blockCipher.getBlockSize() * 8) {
                CMac cMac = this;
                this.cipher = new CBCBlockCipher(blockCipher);
                this.macSize = n3 / 8;
                this.poly = CMac.lookupPoly(blockCipher.getBlockSize());
                this.mac = new byte[blockCipher.getBlockSize()];
                this.buf = new byte[blockCipher.getBlockSize()];
                cMac.ZEROES = new byte[blockCipher.getBlockSize()];
                cMac.bufOff = 0;
                return;
            }
            throw new IllegalArgumentException(b.a("MAC size must be less or equal to ").append(blockCipher.getBlockSize() * 8).toString());
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    private static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n3 = byArray.length;
        int n4 = 0;
        while ((n3 += -1) >= 0) {
            int n5 = byArray[n3] & 0xFF;
            byArray2[n3] = (byte)(n5 << 1 | n4);
            n4 = n5 >>> 7 & 1;
        }
        return n4;
    }

    private byte[] doubleLu(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = byArray2;
        int n3 = -CMac.shiftLeft(byArray, byArray3) & 0xFF;
        int n4 = byArray.length - 3;
        Object object = ((CMac)object).poly;
        byArray3[n4] = (byte)(byArray3[n4] ^ ((CMac)object).poly[1] & n3);
        n4 = byArray.length - 2;
        byArray3[n4] = (byte)(byArray3[n4] ^ object[2] & n3);
        n4 = byArray.length - 1;
        byArray2[n4] = (byte)(byArray2[n4] ^ object[3] & n3);
        return byArray2;
    }

    private static byte[] lookupPoly(int n3) {
        int n4;
        switch (n3 *= 8) {
            default: {
                throw new IllegalArgumentException(a.a("Unknown block size for CMAC: ", n3));
            }
            case 2048: {
                n4 = 548865;
                break;
            }
            case 1024: {
                n4 = 524355;
                break;
            }
            case 768: {
                n4 = 655377;
                break;
            }
            case 512: {
                n4 = 293;
                break;
            }
            case 448: {
                n4 = 2129;
                break;
            }
            case 384: {
                n4 = 4109;
                break;
            }
            case 256: {
                n4 = 1061;
                break;
            }
            case 224: {
                n4 = 777;
                break;
            }
            case 160: {
                n4 = 45;
                break;
            }
            case 128: 
            case 192: {
                n4 = 135;
                break;
            }
            case 64: 
            case 320: {
                n4 = 27;
            }
        }
        return Pack.intToBigEndian(n4);
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters object) {
        CMac cMac = object2;
        cMac.validate((CipherParameters)object);
        cMac.cipher.init(true, (CipherParameters)object);
        object = cMac.ZEROES;
        byte[] byArray = new byte[cMac.ZEROES.length];
        ((CMac)object2).cipher.processBlock((byte[])object, 0, byArray, 0);
        byte[] byArray2 = cMac.doubleLu(byArray);
        Object object2 = byArray2;
        cMac.Lu = byArray2;
        cMac.Lu2 = cMac.doubleLu((byte[])object2);
        cMac.reset();
    }

    public void validate(CipherParameters cipherParameters) {
        if (cipherParameters != null && !(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5;
            int n6 = ((CMac)object).cipher.getBlockSize();
            int n7 = n6 - (n5 = ((CMac)object).bufOff);
            if (n4 > n7) {
                int n8 = n3;
                System.arraycopy(byArray, n3, ((CMac)object).buf, n5, n7);
                Object object = object;
                byte[] byArray2 = ((CMac)object).buf;
                byte[] byArray3 = ((CMac)object).mac;
                ((CMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((CMac)object).bufOff = 0;
                n3 = n4 - n7;
                n4 = n8 + n7;
                int n9 = n3;
                n3 = n4;
                n4 = n9;
                while (n4 > n6) {
                    int n10 = n3;
                    ((CMac)object).cipher.processBlock(byArray, n3, ((CMac)object).mac, 0);
                    n3 = n4 - n6;
                    n4 = n10 + n6;
                    int n11 = n3;
                    n3 = n4;
                    n4 = n11;
                }
            }
            CMac cMac = object;
            CMac cMac2 = object;
            Object object = cMac2.buf;
            System.arraycopy(byArray, n3, object, cMac2.bufOff, n4);
            cMac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        byte[] byArray2;
        Object object;
        CMac cMac = this;
        int n4 = cMac.cipher.getBlockSize();
        if (cMac.bufOff == n4) {
            object = this.Lu;
        } else {
            ISO7816d4Padding iSO7816d4Padding;
            object = iSO7816d4Padding;
            CMac cMac2 = this;
            object();
            object = cMac2.buf;
            iSO7816d4Padding.addPadding((byte[])object, cMac2.bufOff);
            object = this.Lu2;
        }
        int n5 = 0;
        while (true) {
            byArray2 = this.mac;
            if (n5 >= this.mac.length) break;
            this.buf[n5] = (byte)(this.buf[n5] ^ object[n5]);
            ++n5;
        }
        CMac cMac3 = this;
        cMac3.cipher.processBlock(this.buf, 0, byArray2, 0);
        int n6 = this.macSize;
        System.arraycopy(cMac3.mac, 0, byArray, n3, n6);
        cMac3.reset();
        return cMac3.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

