/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.DSTU7564Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class DSTU7564Mac
implements Mac {
    private static final int BITS_IN_BYTE = 8;
    private DSTU7564Digest engine;
    private int macSize;
    private byte[] paddedKey;
    private byte[] invertedKey;
    private long inputLength;

    public DSTU7564Mac(int n3) {
        DSTU7564Mac dSTU7564Mac = this;
        this.engine = new DSTU7564Digest(n3);
        dSTU7564Mac.macSize = n3 / 8;
        dSTU7564Mac.paddedKey = null;
        dSTU7564Mac.invertedKey = null;
    }

    private void pad() {
        int n3 = ((DSTU7564Mac)object).engine.getByteLength() - (int)(((DSTU7564Mac)object).inputLength % (long)((DSTU7564Mac)object).engine.getByteLength());
        if (n3 < 13) {
            n3 = ((DSTU7564Mac)object).engine.getByteLength() + n3;
        }
        DSTU7564Mac dSTU7564Mac = object;
        byte[] byArray = new byte[n3];
        Object object = byArray;
        byArray[0] = -128;
        Pack.longToLittleEndian(dSTU7564Mac.inputLength * 8L, (byte[])object, n3 - 12);
        dSTU7564Mac.engine.update((byte[])object, 0, n3);
    }

    private byte[] padKey(byte[] byArray) {
        DSTU7564Mac dSTU7564Mac = object;
        int n3 = byArray.length;
        n3 = (dSTU7564Mac.engine.getByteLength() + n3 - 1) / ((DSTU7564Mac)object).engine.getByteLength();
        n3 = dSTU7564Mac.engine.getByteLength() * n3;
        if (n3 - byArray.length < 13) {
            n3 = ((DSTU7564Mac)object).engine.getByteLength() + n3;
        }
        byte[] byArray2 = new byte[n3];
        Object object = byArray2;
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n4);
        object[byArray.length] = -128;
        Pack.intToLittleEndian(byArray.length * 8, (byte[])object, n3 - 12);
        return byArray2;
    }

    @Override
    public void init(CipherParameters object) {
        this.paddedKey = null;
        this.reset();
        if (object instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)object).getKey();
            object = byArray;
            this.invertedKey = new byte[byArray.length];
            this.paddedKey = this.padKey((byte[])object);
            int n3 = 0;
            while (true) {
                byte[] byArray2 = this.invertedKey;
                if (n3 >= this.invertedKey.length) break;
                byArray2[n3] = (byte)(~object[n3]);
                ++n3;
            }
            this.engine.update(this.paddedKey, 0, this.paddedKey.length);
            return;
        }
        throw new IllegalArgumentException("Bad parameter passed");
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564Mac";
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        DSTU7564Mac dSTU7564Mac = this;
        dSTU7564Mac.engine.update(by);
        ++dSTU7564Mac.inputLength;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (byArray.length - n3 >= n4) {
            if (this.paddedKey != null) {
                DSTU7564Mac dSTU7564Mac = this;
                dSTU7564Mac.engine.update(byArray, n3, n4);
                dSTU7564Mac.inputLength += (long)n4;
                return;
            }
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        if (this.paddedKey != null) {
            if (byArray.length - n3 >= this.macSize) {
                DSTU7564Mac dSTU7564Mac = this;
                dSTU7564Mac.pad();
                dSTU7564Mac.engine.update(this.invertedKey, 0, this.invertedKey.length);
                dSTU7564Mac.inputLength = 0L;
                int n4 = dSTU7564Mac.engine.doFinal(byArray, n3);
                this.reset();
                return n4;
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        DSTU7564Mac dSTU7564Mac = this;
        dSTU7564Mac.inputLength = 0L;
        dSTU7564Mac.engine.reset();
        byte[] byArray = dSTU7564Mac.paddedKey;
        if (dSTU7564Mac.paddedKey != null) {
            this.engine.update(byArray, 0, byArray.length);
        }
    }
}

