/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithSBox;

public class GOST28147Mac
implements Mac {
    private int blockSize = 8;
    private int macSize = 4;
    private int bufOff = 0;
    private byte[] buf;
    private byte[] mac;
    private boolean firstStep = true;
    private int[] workingKey = null;
    private byte[] macIV = null;
    private byte[] S = new byte[]{9, 6, 3, 2, 8, 11, 1, 7, 10, 4, 14, 15, 12, 0, 13, 5, 3, 7, 14, 9, 8, 10, 15, 0, 5, 2, 6, 12, 11, 4, 13, 1, 14, 4, 6, 2, 11, 3, 13, 8, 12, 15, 5, 10, 0, 7, 1, 9, 14, 7, 10, 12, 13, 1, 3, 9, 0, 2, 11, 4, 15, 8, 5, 6, 11, 5, 1, 9, 8, 13, 15, 0, 14, 4, 2, 3, 12, 7, 10, 6, 3, 10, 13, 12, 1, 2, 0, 11, 7, 5, 9, 4, 8, 15, 14, 6, 1, 13, 2, 9, 7, 10, 6, 0, 8, 12, 4, 5, 15, 3, 11, 14, 11, 10, 15, 5, 0, 12, 14, 8, 6, 2, 3, 9, 1, 7, 13, 4};

    public GOST28147Mac() {
        this.mac = new byte[8];
        this.buf = new byte[8];
    }

    private int[] generateWorkingKey(byte[] byArray) {
        if (byArray.length == 32) {
            int[] nArray = new int[8];
            for (int i3 = 0; i3 != 8; ++i3) {
                nArray[i3] = this.bytesToint(byArray, i3 * 4);
            }
            return nArray;
        }
        throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
    }

    private void recursiveInit(CipherParameters object) {
        block7: {
            CipherParameters cipherParameters;
            block5: {
                block6: {
                    block4: {
                        if (object == null) {
                            return;
                        }
                        cipherParameters = null;
                        if (!(object instanceof ParametersWithSBox)) break block4;
                        ParametersWithSBox parametersWithSBox = (ParametersWithSBox)object;
                        object = parametersWithSBox;
                        CipherParameters cipherParameters2 = object;
                        object = this.S;
                        int n3 = ((ParametersWithSBox)cipherParameters2).getSBox().length;
                        System.arraycopy(parametersWithSBox.getSBox(), 0, object, 0, n3);
                        cipherParameters = parametersWithSBox.getParameters();
                        break block5;
                    }
                    if (!(object instanceof KeyParameter)) break block6;
                    this.workingKey = this.generateWorkingKey(((KeyParameter)object).getKey());
                    break block5;
                }
                if (!(object instanceof ParametersWithIV)) break block7;
                ParametersWithIV parametersWithIV = (ParametersWithIV)object;
                object = this.mac;
                int n4 = this.mac.length;
                System.arraycopy(parametersWithIV.getIV(), 0, object, 0, n4);
                this.macIV = parametersWithIV.getIV();
                cipherParameters = parametersWithIV.getParameters();
            }
            this.recursiveInit(cipherParameters);
            return;
        }
        throw new IllegalArgumentException(a.a((CipherParameters)object, b.a("invalid parameter passed to GOST28147 init - ")));
    }

    private int gost28147_mainStep(int n3, int n4) {
        int n5 = n4 + n3;
        byte[] byArray = this.S;
        n5 = (this.S[(n5 >> 0 & 0xF) + 0] << 0) + (byArray[(n5 >> 4 & 0xF) + 16] << 4) + (byArray[(n5 >> 8 & 0xF) + 32] << 8) + (byArray[(n5 >> 12 & 0xF) + 48] << 12) + (byArray[(n5 >> 16 & 0xF) + 64] << 16) + (byArray[(n5 >> 20 & 0xF) + 80] << 20) + (byArray[(n5 >> 24 & 0xF) + 96] << 24) + (byArray[(n5 >> 28 & 0xF) + 112] << 28);
        return n5 << 11 | n5 >>> 21;
    }

    private void gost28147MacFunc(int[] nArray, byte[] byArray, int n3, byte[] byArray2, int n4) {
        GOST28147Mac gOST28147Mac = this;
        int n5 = gOST28147Mac.bytesToint(byArray, n3);
        int n6 = gOST28147Mac.bytesToint(byArray, n3 + 4);
        for (n3 = 0; n3 < 2; ++n3) {
            for (int i3 = 0; i3 < 8; ++i3) {
                int n7 = n6 ^= this.gost28147_mainStep(n5, nArray[i3]);
                n6 = n5;
                n5 = n7;
            }
        }
        GOST28147Mac gOST28147Mac2 = this;
        gOST28147Mac2.intTobytes(n5, byArray2, n4);
        int n8 = n4 + 4;
        gOST28147Mac2.intTobytes(n6, byArray2, n8);
    }

    private int bytesToint(byte[] byArray, int n3) {
        return (byArray[n3 + 3] << 24 & 0xFF000000) + (byArray[n3 + 2] << 16 & 0xFF0000) + (byArray[n3 + 1] << 8 & 0xFF00) + (byArray[n3] & 0xFF);
    }

    private void intTobytes(int n3, byte[] byArray, int n4) {
        int n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >>> 24);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >>> 16);
        n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >>> 8);
        byArray[n4] = (byte)n3;
    }

    private byte[] CM5func(byte[] byArray, int n3, byte[] byArray2) {
        Object object = new byte[byArray.length - n3];
        int n4 = byArray2.length;
        System.arraycopy(byArray, n3, object, 0, n4);
        for (n4 = 0; n4 != byArray2.length; ++n4) {
            object[n4] = (byte)(object[n4] ^ byArray2[n4]);
        }
        return object;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        GOST28147Mac gOST28147Mac = this;
        gOST28147Mac.reset();
        gOST28147Mac.buf = new byte[gOST28147Mac.blockSize];
        gOST28147Mac.macIV = null;
        this.recursiveInit(cipherParameters);
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            Object[] objectArray;
            byte[] byArray2 = byArray;
            byArray = new byte[byArray.length];
            int n3 = this.mac.length;
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            if (this.firstStep) {
                GOST28147Mac gOST28147Mac = this;
                gOST28147Mac.firstStep = false;
                objectArray = gOST28147Mac.macIV;
                if (gOST28147Mac.macIV != null) {
                    GOST28147Mac gOST28147Mac2 = this;
                    byArray = gOST28147Mac2.CM5func(gOST28147Mac2.buf, 0, (byte[])objectArray);
                }
            } else {
                GOST28147Mac gOST28147Mac = this;
                byArray = gOST28147Mac.buf;
                objectArray = gOST28147Mac.mac;
                byArray = gOST28147Mac.CM5func(byArray, 0, (byte[])objectArray);
            }
            GOST28147Mac gOST28147Mac = this;
            objectArray = gOST28147Mac.workingKey;
            byte[] byArray3 = gOST28147Mac.mac;
            gOST28147Mac.gost28147MacFunc((int[])objectArray, byArray, 0, byArray3, 0);
            gOST28147Mac.bufOff = 0;
        }
        int n4 = this.bufOff;
        this.bufOff = n4 + 1;
        this.buf[n4] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5 = ((GOST28147Mac)object).bufOff;
            int n6 = ((GOST28147Mac)object).blockSize - n5;
            if (n4 > n6) {
                byte[] byArray2;
                GOST28147Mac gOST28147Mac = object;
                System.arraycopy(byArray, n3, ((GOST28147Mac)object).buf, n5, n6);
                byte[] byArray3 = new byte[gOST28147Mac.buf.length];
                int n7 = ((GOST28147Mac)object).mac.length;
                System.arraycopy(gOST28147Mac.buf, 0, byArray3, 0, n7);
                if (gOST28147Mac.firstStep) {
                    Object object = object;
                    ((GOST28147Mac)object).firstStep = false;
                    byArray2 = ((GOST28147Mac)object).macIV;
                    if (((GOST28147Mac)object).macIV != null) {
                        Object object2 = object;
                        byArray3 = super.CM5func(((GOST28147Mac)object2).buf, 0, byArray2);
                    }
                } else {
                    Object object = object;
                    byArray3 = ((GOST28147Mac)object).buf;
                    byArray2 = ((GOST28147Mac)object).mac;
                    byArray3 = super.CM5func(byArray3, 0, byArray2);
                }
                int n8 = n3;
                Object object = object;
                int[] nArray = ((GOST28147Mac)object).workingKey;
                byte[] byArray4 = ((GOST28147Mac)object).mac;
                super.gost28147MacFunc(nArray, byArray3, 0, byArray4, 0);
                ((GOST28147Mac)object).bufOff = 0;
                n3 = n4 - n6;
                n4 = n8 + n6;
                int n9 = n3;
                n3 = n4;
                for (n4 = v828521; n4 > ((GOST28147Mac)object).blockSize; n4 -= n3) {
                    int n10 = n3;
                    Object object3 = object;
                    Object[] objectArray = ((GOST28147Mac)object3).mac;
                    byte[] byArray5 = super.CM5func(byArray, n3, (byte[])objectArray);
                    objectArray = ((GOST28147Mac)object3).workingKey;
                    byArray3 = ((GOST28147Mac)object3).mac;
                    super.gost28147MacFunc((int[])objectArray, byArray5, 0, byArray3, 0);
                    n3 = ((GOST28147Mac)object3).blockSize;
                    n3 = n10 + n3;
                }
            }
            GOST28147Mac gOST28147Mac = object;
            GOST28147Mac gOST28147Mac2 = object;
            Object object = gOST28147Mac2.buf;
            System.arraycopy(byArray, n3, object, gOST28147Mac2.bufOff, n4);
            gOST28147Mac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        int n4;
        while ((n4 = this.bufOff) < this.blockSize) {
            this.buf[n4] = 0;
            this.bufOff = n4 + 1;
        }
        GOST28147Mac gOST28147Mac = this;
        byte[] byArray2 = new byte[gOST28147Mac.buf.length];
        int n5 = this.mac.length;
        System.arraycopy(gOST28147Mac.buf, 0, byArray2, 0, n5);
        if (gOST28147Mac.firstStep) {
            this.firstStep = false;
        } else {
            GOST28147Mac gOST28147Mac2 = this;
            byArray2 = gOST28147Mac2.buf;
            byte[] byArray3 = gOST28147Mac2.mac;
            byArray2 = gOST28147Mac2.CM5func(byArray2, 0, byArray3);
        }
        GOST28147Mac gOST28147Mac3 = this;
        int[] nArray = gOST28147Mac3.workingKey;
        byte[] byArray4 = gOST28147Mac3.mac;
        gOST28147Mac3.gost28147MacFunc(nArray, byArray2, 0, byArray4, 0);
        int n6 = this.macSize;
        System.arraycopy(gOST28147Mac3.mac, gOST28147Mac3.mac.length / 2 - n6, byArray, n3, n6);
        gOST28147Mac3.reset();
        return gOST28147Mac3.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        GOST28147Mac gOST28147Mac = this;
        gOST28147Mac.bufOff = 0;
        gOST28147Mac.firstStep = true;
    }
}

