/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import java.util.Hashtable;

public class HMac
implements Mac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private static Hashtable blockLengths = new Hashtable<String, Integer>();
    private Digest digest;
    private int digestSize;
    private int blockLength;
    private Memoable ipadState;
    private Memoable opadState;
    private byte[] inputPad;
    private byte[] outputBuf;

    private static int getByteLength(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer n3 = (Integer)blockLengths.get(digest.getAlgorithmName());
        if (n3 != null) {
            return n3;
        }
        throw new IllegalArgumentException(b.a("unknown digest passed: ").append(digest.getAlgorithmName()).toString());
    }

    public HMac(Digest digest) {
        this(digest, HMac.getByteLength(digest));
    }

    private HMac(Digest digest, int n3) {
        int n4;
        this.digest = digest;
        this.digestSize = n4 = digest.getDigestSize();
        this.blockLength = n3;
        this.inputPad = new byte[n3];
        this.outputBuf = new byte[n3 + n4];
    }

    private static void xorPad(byte[] byArray, int n3, byte by) {
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray[i3] = (byte)(byArray[i3] ^ by);
        }
    }

    static {
        blockLengths.put("GOST3411", Integers.valueOf(32));
        blockLengths.put("MD2", Integers.valueOf(16));
        blockLengths.put("MD4", Integers.valueOf(64));
        blockLengths.put("MD5", Integers.valueOf(64));
        blockLengths.put("RIPEMD128", Integers.valueOf(64));
        blockLengths.put("RIPEMD160", Integers.valueOf(64));
        blockLengths.put("SHA-1", Integers.valueOf(64));
        blockLengths.put("SHA-224", Integers.valueOf(64));
        blockLengths.put("SHA-256", Integers.valueOf(64));
        blockLengths.put("SHA-384", Integers.valueOf(128));
        blockLengths.put("SHA-512", Integers.valueOf(128));
        blockLengths.put("Tiger", Integers.valueOf(64));
        blockLengths.put("Whirlpool", Integers.valueOf(64));
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters object) {
        this.digest.reset();
        byte[] byArray = ((KeyParameter)object).getKey();
        object = byArray;
        int n3 = byArray.length;
        if (n3 > this.blockLength) {
            HMac hMac = this;
            hMac.digest.update((byte[])object, 0, n3);
            hMac.digest.doFinal(this.inputPad, 0);
            n3 = hMac.digestSize;
        } else {
            System.arraycopy(object, 0, this.inputPad, 0, n3);
        }
        while (true) {
            object = this.inputPad;
            if (n3 >= this.inputPad.length) break;
            object[n3] = false;
            ++n3;
        }
        HMac hMac = this;
        Object object2 = object;
        HMac hMac2 = this;
        object = hMac2.outputBuf;
        n3 = hMac2.blockLength;
        System.arraycopy(object2, 0, object, 0, n3);
        HMac.xorPad(hMac.inputPad, this.blockLength, (byte)54);
        HMac.xorPad(hMac.outputBuf, this.blockLength, (byte)92);
        object = hMac.digest;
        if (object instanceof Memoable) {
            object = ((Memoable)object).copy();
            this.opadState = object;
            Digest digest = (Digest)object;
            HMac hMac3 = this;
            object = hMac3.outputBuf;
            n3 = hMac3.blockLength;
            digest.update((byte[])object, 0, n3);
        }
        HMac hMac4 = this;
        hMac4.digest.update(this.inputPad, 0, this.inputPad.length);
        object = hMac4.digest;
        if (object instanceof Memoable) {
            this.ipadState = ((Memoable)object).copy();
        }
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        HMac hMac = this;
        HMac hMac2 = this;
        Object object = hMac2.outputBuf;
        hMac.digest.doFinal((byte[])object, hMac2.blockLength);
        Memoable memoable = hMac.opadState;
        object = memoable;
        if (memoable != null) {
            HMac hMac3 = this;
            ((Memoable)((Object)hMac3.digest)).reset((Memoable)object);
            Digest digest = hMac3.digest;
            HMac hMac4 = this;
            object = hMac4.outputBuf;
            int n4 = hMac4.blockLength;
            int n5 = digest.getDigestSize();
            digest.update((byte[])object, n4, n5);
        } else {
            this.digest.update(this.outputBuf, 0, this.outputBuf.length);
        }
        HMac hMac5 = this;
        int n6 = hMac5.digest.doFinal(byArray, n3);
        n3 = hMac5.blockLength;
        while (true) {
            object = this.outputBuf;
            if (n3 >= this.outputBuf.length) break;
            object[n3] = 0;
            ++n3;
        }
        Memoable memoable2 = this.ipadState;
        if (memoable2 != null) {
            ((Memoable)((Object)this.digest)).reset(memoable2);
        } else {
            this.digest.update(this.inputPad, 0, this.inputPad.length);
        }
        return n6;
    }

    @Override
    public void reset() {
        HMac hMac = this;
        hMac.digest.reset();
        hMac.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

