/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class ISO9797Alg3Mac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;
    private KeyParameter lastKey2;
    private KeyParameter lastKey3;

    public ISO9797Alg3Mac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8, blockCipherPadding);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n3) {
        this(blockCipher, n3, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n3, BlockCipherPadding blockCipherPadding) {
        if (n3 % 8 == 0) {
            if (blockCipher instanceof DESEngine) {
                ISO9797Alg3Mac iSO9797Alg3Mac = this;
                this.cipher = new CBCBlockCipher(blockCipher);
                this.padding = blockCipherPadding;
                this.macSize = n3 / 8;
                this.mac = new byte[blockCipher.getBlockSize()];
                iSO9797Alg3Mac.buf = new byte[blockCipher.getBlockSize()];
                iSO9797Alg3Mac.bufOff = 0;
                return;
            }
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    @Override
    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        block8: {
            KeyParameter keyParameter;
            block7: {
                KeyParameter keyParameter2;
                KeyParameter keyParameter3;
                KeyParameter keyParameter4;
                byte[] byArray;
                block6: {
                    KeyParameter keyParameter5;
                    KeyParameter keyParameter6;
                    ((ISO9797Alg3Mac)((Object)parametersWithIV2)).reset();
                    boolean bl = cipherParameters instanceof KeyParameter;
                    if (!bl && !(cipherParameters instanceof ParametersWithIV)) {
                        throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
                    }
                    byArray = (bl ? (KeyParameter)cipherParameters : (KeyParameter)((ParametersWithIV)cipherParameters).getParameters()).getKey();
                    if (byArray.length != 16) break block6;
                    ISO9797Alg3Mac iSO9797Alg3Mac = parametersWithIV2;
                    keyParameter = keyParameter6;
                    keyParameter6 = new KeyParameter(byArray, 0, 8);
                    KeyParameter keyParameter7 = keyParameter5;
                    keyParameter5 = new KeyParameter(byArray, 8, 8);
                    iSO9797Alg3Mac.lastKey2 = keyParameter7;
                    iSO9797Alg3Mac.lastKey3 = keyParameter;
                    break block7;
                }
                if (byArray.length != 24) break block8;
                ISO9797Alg3Mac iSO9797Alg3Mac = parametersWithIV2;
                keyParameter = keyParameter4;
                keyParameter4 = new KeyParameter(byArray, 0, 8);
                KeyParameter keyParameter8 = keyParameter3;
                keyParameter3 = new KeyParameter(byArray, 8, 8);
                iSO9797Alg3Mac.lastKey2 = keyParameter8;
                keyParameter8 = keyParameter2;
                keyParameter2 = new KeyParameter(byArray, 16, 8);
                iSO9797Alg3Mac.lastKey3 = keyParameter8;
            }
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV;
                ParametersWithIV parametersWithIV2 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(keyParameter, ((ParametersWithIV)cipherParameters).getIV());
                ((ISO9797Alg3Mac)((Object)parametersWithIV2)).cipher.init(true, parametersWithIV2);
            } else {
                ((ISO9797Alg3Mac)((Object)parametersWithIV2)).cipher.init(true, keyParameter);
            }
            return;
        }
        throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n4 >= 0) {
            int n5;
            int n6 = ((ISO9797Alg3Mac)object).cipher.getBlockSize();
            int n7 = n6 - (n5 = ((ISO9797Alg3Mac)object).bufOff);
            if (n4 > n7) {
                int n8 = n3;
                System.arraycopy(byArray, n3, ((ISO9797Alg3Mac)object).buf, n5, n7);
                Object object = object;
                byte[] byArray2 = ((ISO9797Alg3Mac)object).buf;
                byte[] byArray3 = ((ISO9797Alg3Mac)object).mac;
                ((ISO9797Alg3Mac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((ISO9797Alg3Mac)object).bufOff = 0;
                n3 = n4 - n7;
                n4 = n8 + n7;
                int n9 = n3;
                n3 = n4;
                n4 = n9;
                while (n4 > n6) {
                    int n10 = n3;
                    ((ISO9797Alg3Mac)object).cipher.processBlock(byArray, n3, ((ISO9797Alg3Mac)object).mac, 0);
                    n3 = n4 - n6;
                    n4 = n10 + n6;
                    int n11 = n3;
                    n3 = n4;
                    n4 = n11;
                }
            }
            ISO9797Alg3Mac iSO9797Alg3Mac = object;
            ISO9797Alg3Mac iSO9797Alg3Mac2 = object;
            Object object = iSO9797Alg3Mac2.buf;
            System.arraycopy(byArray, n3, object, iSO9797Alg3Mac2.bufOff, n4);
            iSO9797Alg3Mac.bufOff += n4;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        DESEngine dESEngine;
        ISO9797Alg3Mac iSO9797Alg3Mac = this;
        int n4 = iSO9797Alg3Mac.cipher.getBlockSize();
        if (iSO9797Alg3Mac.padding == null) {
            int n5;
            while ((n5 = this.bufOff) < n4) {
                this.buf[n5] = 0;
                this.bufOff = n5 + 1;
            }
        } else {
            if (this.bufOff == n4) {
                ISO9797Alg3Mac iSO9797Alg3Mac2 = this;
                byte[] byArray2 = iSO9797Alg3Mac2.buf;
                byte[] byArray3 = iSO9797Alg3Mac2.mac;
                this.cipher.processBlock(byArray2, 0, byArray3, 0);
                this.bufOff = 0;
            }
            ISO9797Alg3Mac iSO9797Alg3Mac3 = this;
            byte[] byArray4 = iSO9797Alg3Mac3.buf;
            this.padding.addPadding(byArray4, iSO9797Alg3Mac3.bufOff);
        }
        ISO9797Alg3Mac iSO9797Alg3Mac4 = this;
        ISO9797Alg3Mac iSO9797Alg3Mac5 = this;
        Object object = iSO9797Alg3Mac5.buf;
        byte[] byArray5 = iSO9797Alg3Mac5.mac;
        iSO9797Alg3Mac4.cipher.processBlock((byte[])object, 0, byArray5, 0);
        object = dESEngine;
        ((DESEngine)object)();
        ((DESEngine)object).init(false, this.lastKey2);
        ((DESEngine)object).processBlock(this.mac, 0, this.mac, 0);
        ((DESEngine)object).init(true, this.lastKey3);
        dESEngine.processBlock(this.mac, 0, this.mac, 0);
        int n6 = this.macSize;
        System.arraycopy(iSO9797Alg3Mac4.mac, 0, byArray, n3, n6);
        iSO9797Alg3Mac4.reset();
        return iSO9797Alg3Mac4.macSize;
    }

    @Override
    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

