/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KGCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class KGMac
implements Mac {
    private final KGCMBlockCipher cipher;
    private final int macSizeBits;

    public KGMac(KGCMBlockCipher kGCMBlockCipher) {
        this.cipher = kGCMBlockCipher;
        this.macSizeBits = kGCMBlockCipher.getUnderlyingCipher().getBlockSize() * 8;
    }

    public KGMac(KGCMBlockCipher kGCMBlockCipher, int n3) {
        this.cipher = kGCMBlockCipher;
        this.macSizeBits = n3;
    }

    @Override
    public void init(CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            AEADParameters aEADParameters;
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            object = parametersWithIV.getIV();
            KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
            AEADParameters aEADParameters2 = aEADParameters;
            aEADParameters = new AEADParameters(keyParameter, this.macSizeBits, (byte[])object);
            this.cipher.init(true, aEADParameters2);
            return;
        }
        throw new IllegalArgumentException("KGMAC requires ParametersWithIV");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-KGMAC";
    }

    @Override
    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    @Override
    public void update(byte by) {
        this.cipher.processAADByte(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.cipher.processAADBytes(byArray, n3, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        try {
            return this.cipher.doFinal(byArray, n3);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(((Object)invalidCipherTextException).toString());
        }
    }

    @Override
    public void reset() {
        this.cipher.reset();
    }
}

