/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

class MacCFBBlockCipher {
    private byte[] IV;
    private byte[] cfbV;
    private byte[] cfbOutV;
    private int blockSize;
    private BlockCipher cipher;

    public MacCFBBlockCipher(BlockCipher blockCipher, int n3) {
        this.cipher = blockCipher;
        this.blockSize = n3 / 8;
        this.IV = new byte[blockCipher.getBlockSize()];
        this.cfbV = new byte[blockCipher.getBlockSize()];
        this.cfbOutV = new byte[blockCipher.getBlockSize()];
    }

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)cipherParameters;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                int n3 = byArray2.length - byArray.length;
                int n4 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, n3, n4);
            } else {
                int n5 = byArray2.length;
                System.arraycopy(byArray, 0, byArray2, 0, n5);
            }
            MacCFBBlockCipher macCFBBlockCipher = this;
            macCFBBlockCipher.reset();
            macCFBBlockCipher.cipher.init(true, ((ParametersWithIV)cipherParameters).getParameters());
        } else {
            MacCFBBlockCipher macCFBBlockCipher = this;
            macCFBBlockCipher.reset();
            macCFBBlockCipher.cipher.init(true, cipherParameters);
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CFB" + this.blockSize * 8;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blockSize;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                int n6;
                MacCFBBlockCipher macCFBBlockCipher = this;
                byte[] byArray3 = macCFBBlockCipher.cfbV;
                byte[] byArray4 = macCFBBlockCipher.cfbOutV;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int i3 = 0; i3 < (n6 = this.blockSize); ++i3) {
                    byArray2[n4 + i3] = (byte)(this.cfbOutV[i3] ^ byArray[n3 + i3]);
                }
                MacCFBBlockCipher macCFBBlockCipher2 = this;
                byArray = macCFBBlockCipher2.cfbV;
                n3 = byArray.length - n6;
                System.arraycopy(macCFBBlockCipher2.cfbV, n6, byArray, 0, n3);
                byArray = macCFBBlockCipher2.cfbV;
                int n7 = this.blockSize;
                System.arraycopy(byArray2, n4, byArray, macCFBBlockCipher2.cfbV.length - n7, n7);
                return this.blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public void reset() {
        MacCFBBlockCipher macCFBBlockCipher = object;
        Object object = ((MacCFBBlockCipher)object).cfbV;
        int n3 = macCFBBlockCipher.IV.length;
        System.arraycopy(macCFBBlockCipher.IV, 0, object, 0, n3);
        macCFBBlockCipher.cipher.reset();
    }

    public void getMacBlock(byte[] byArray) {
        this.cipher.processBlock(this.cfbV, 0, byArray, 0);
    }
}

