/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Poly1305
implements Mac {
    private static final int BLOCK_SIZE = 16;
    private final BlockCipher cipher;
    private final byte[] singleByte = new byte[1];
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private final byte[] currentBlock = new byte[16];
    private int currentBlockOffset = 0;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;

    public Poly1305() {
        this.cipher = null;
    }

    public Poly1305(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() == 16) {
            this.cipher = blockCipher;
            return;
        }
        throw new IllegalArgumentException("Poly1305 requires a 128 bit block cipher.");
    }

    private void setKey(byte[] object, byte[] byArray) {
        if (((byte[])object).length == 32) {
            int n3;
            if (this.cipher != null && (byArray == null || byArray.length != 16)) {
                throw new IllegalArgumentException("Poly1305 requires a 128 bit IV.");
            }
            int n4 = Pack.littleEndianToInt(object, 0);
            int n5 = Pack.littleEndianToInt(object, 4);
            int n6 = Pack.littleEndianToInt(object, 8);
            int n7 = Pack.littleEndianToInt(object, 12);
            this.r0 = n4 & 0x3FFFFFF;
            this.r1 = n4 = (n4 >>> 26 | n5 << 6) & 0x3FFFF03;
            this.r2 = n5 = (n5 >>> 20 | n6 << 12) & 0x3FFC0FF;
            this.r3 = n6 = (n6 >>> 14 | n7 << 18) & 0x3F03FFF;
            this.r4 = n7 = n7 >>> 8 & 0xFFFFF;
            this.s1 = n4 * 5;
            this.s2 = n5 * 5;
            this.s3 = n6 * 5;
            this.s4 = n7 * 5;
            Object object2 = this.cipher;
            if (object2 == null) {
                n3 = 16;
            } else {
                KeyParameter keyParameter;
                BlockCipher blockCipher = object2;
                object2 = new byte[16];
                n5 = 0;
                KeyParameter keyParameter2 = keyParameter;
                keyParameter = new KeyParameter((byte[])object, 16, 16);
                blockCipher.init(true, keyParameter2);
                this.cipher.processBlock(byArray, 0, (byte[])object2, 0);
                n3 = n5;
                object = object2;
            }
            this.k0 = Pack.littleEndianToInt(object, n3 + 0);
            this.k1 = Pack.littleEndianToInt(object, n3 + 4);
            this.k2 = Pack.littleEndianToInt(object, n3 + 8);
            this.k3 = Pack.littleEndianToInt(object, n3 + 12);
            return;
        }
        throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
    }

    private void processBlock() {
        int n3;
        int n4;
        int n5 = this.currentBlockOffset;
        if (n5 < 16) {
            this.currentBlock[n5] = 1;
            ++n5;
            while (n5 < 16) {
                this.currentBlock[n5] = 0;
                ++n5;
            }
        }
        Poly1305 poly1305 = this;
        long l3 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 0) & 0xFFFFFFFFL;
        long l4 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 4) & 0xFFFFFFFFL;
        long l5 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 8) & 0xFFFFFFFFL;
        long l6 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 12) & 0xFFFFFFFFL;
        poly1305.h0 = n4 = (int)((long)poly1305.h0 + (l3 & 0x3FFFFFFL));
        poly1305.h1 = (int)((long)poly1305.h1 + ((l4 << 32 | l3) >>> 26 & 0x3FFFFFFL));
        poly1305.h2 = (int)((long)poly1305.h2 + ((l5 << 32 | l4) >>> 20 & 0x3FFFFFFL));
        poly1305.h3 = (int)((long)poly1305.h3 + ((l6 << 32 | l5) >>> 14 & 0x3FFFFFFL));
        poly1305.h4 = n3 = (int)((long)poly1305.h4 + (l6 >>> 8));
        if (poly1305.currentBlockOffset == 16) {
            this.h4 = n3 + 0x1000000;
        }
        Poly1305 poly13052 = this;
        long l7 = Poly1305.mul32x32_64(n4, this.r0) + Poly1305.mul32x32_64(this.h1, this.s4) + Poly1305.mul32x32_64(this.h2, this.s3) + Poly1305.mul32x32_64(this.h3, this.s2) + Poly1305.mul32x32_64(this.h4, this.s1);
        l4 = Poly1305.mul32x32_64(poly13052.h0, this.r1) + Poly1305.mul32x32_64(this.h1, this.r0) + Poly1305.mul32x32_64(this.h2, this.s4) + Poly1305.mul32x32_64(this.h3, this.s3) + Poly1305.mul32x32_64(this.h4, this.s2);
        l5 = Poly1305.mul32x32_64(poly13052.h0, this.r2) + Poly1305.mul32x32_64(this.h1, this.r1) + Poly1305.mul32x32_64(this.h2, this.r0) + Poly1305.mul32x32_64(this.h3, this.s4) + Poly1305.mul32x32_64(this.h4, this.s3);
        l6 = Poly1305.mul32x32_64(poly13052.h0, this.r3) + Poly1305.mul32x32_64(this.h1, this.r2) + Poly1305.mul32x32_64(this.h2, this.r1) + Poly1305.mul32x32_64(this.h3, this.r0) + Poly1305.mul32x32_64(this.h4, this.s4);
        long l8 = l7;
        int n6 = (int)l8 & 0x3FFFFFF;
        long l9 = l4 + (l8 >>> 26);
        int n7 = (int)l9 & 0x3FFFFFF;
        l4 = l5 + (l9 >>> 26);
        this.h2 = (int)l4 & 0x3FFFFFF;
        l4 = l6 + (l4 >>> 26);
        this.h3 = (int)l4 & 0x3FFFFFF;
        l4 = Poly1305.mul32x32_64(poly13052.h0, this.r4) + Poly1305.mul32x32_64(this.h1, this.r3) + Poly1305.mul32x32_64(this.h2, this.r2) + Poly1305.mul32x32_64(this.h3, this.r1) + Poly1305.mul32x32_64(this.h4, this.r0) + (l4 >>> 26);
        this.h4 = (int)l4 & 0x3FFFFFF;
        n6 = (int)(l4 >>> 26) * 5 + n6;
        this.h1 = n7 + (n6 >>> 26);
        poly13052.h0 = n6 & 0x3FFFFFF;
    }

    private static final long mul32x32_64(int n3, int n4) {
        return ((long)n3 & 0xFFFFFFFFL) * (long)n4;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        byte[] byArray = null;
        if (this.cipher != null) {
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray = parametersWithIV.getIV();
                cipherParameters = parametersWithIV.getParameters();
            } else {
                throw new IllegalArgumentException("Poly1305 requires an IV when used with a block cipher.");
            }
        }
        if (cipherParameters instanceof KeyParameter) {
            Poly1305 poly1305 = this;
            poly1305.setKey(((KeyParameter)cipherParameters).getKey(), byArray);
            poly1305.reset();
            return;
        }
        throw new IllegalArgumentException("Poly1305 requires a key.");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher == null ? "Poly1305" : b.a("Poly1305-").append(this.cipher.getAlgorithmName()).toString();
    }

    @Override
    public int getMacSize() {
        return 16;
    }

    @Override
    public void update(byte by) {
        Poly1305 poly1305 = object;
        Object object = poly1305.singleByte;
        poly1305.singleByte[0] = by;
        poly1305.update((byte[])object, 0, 1);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n4 > n5) {
            if (this.currentBlockOffset == 16) {
                this.processBlock();
                this.currentBlockOffset = 0;
            }
            int n6 = n5;
            Poly1305 poly1305 = this;
            int n7 = n5;
            n5 = Math.min(n4 - n5, 16 - this.currentBlockOffset);
            int n8 = n7 + n3;
            byte[] byArray2 = poly1305.currentBlock;
            int n9 = poly1305.currentBlockOffset;
            System.arraycopy(byArray, n8, byArray2, n9, n5);
            n8 = n6 + n5;
            this.currentBlockOffset += n5;
            n5 = n8;
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        if (n3 + 16 <= byArray.length) {
            if (this.currentBlockOffset > 0) {
                this.processBlock();
            }
            Poly1305 poly1305 = this;
            int n4 = this.h0;
            int n5 = poly1305.h1 + (n4 >>> 26);
            n4 &= 0x3FFFFFF;
            int n6 = this.h2 + (n5 >>> 26);
            int n7 = n5 & 0x3FFFFFF;
            int n8 = poly1305.h3 + (n6 >>> 26);
            int n9 = this.h4 + (n8 >>> 26);
            int n10 = n8 & 0x3FFFFFF;
            int n11 = n10;
            int n12 = n6 &= 0x3FFFFFF;
            int n13 = n7;
            n4 = (n9 >>> 26) * 5 + n4;
            n7 = n9 & 0x3FFFFFF;
            int n14 = n13 + (n4 >>> 26);
            n9 = n14;
            int n15 = n4 & 0x3FFFFFF;
            n4 = n15;
            int n16 = n11;
            int n17 = n6;
            int n18 = n4 + 5;
            n4 = n18 >>> 26;
            n6 = n18 & 0x3FFFFFF;
            int n19 = n9 + n4;
            n4 = n19 >>> 26;
            n9 = n19 & 0x3FFFFFF;
            int n20 = n17 + n4;
            n4 = n20 >>> 26;
            n11 = n20 & 0x3FFFFFF;
            int n21 = n16 + n4;
            n4 = n21 >>> 26;
            int n22 = n21 & 0x3FFFFFF;
            n4 = n7 + n4 - 0x4000000;
            int n23 = (n4 >>> 31) - 1;
            int n24 = ~n23;
            this.h0 = n6 = n15 & n24 | n6 & n23;
            this.h1 = n9 = n14 & n24 | n9 & n23;
            this.h2 = n11 = n12 & n24 | n11 & n23;
            this.h3 = n22 = n10 & n24 | n22 & n23;
            this.h4 = n4 = n7 & n24 | n4 & n23;
            long l3 = ((long)(n6 | n9 << 26) & 0xFFFFFFFFL) + ((long)this.k0 & 0xFFFFFFFFL);
            long l4 = ((long)(n9 >>> 6 | n11 << 20) & 0xFFFFFFFFL) + ((long)this.k1 & 0xFFFFFFFFL);
            long l5 = ((long)(n11 >>> 12 | n22 << 14) & 0xFFFFFFFFL) + ((long)this.k2 & 0xFFFFFFFFL);
            long l6 = ((long)(n22 >>> 18 | n4 << 8) & 0xFFFFFFFFL) + ((long)this.k3 & 0xFFFFFFFFL);
            long l7 = l3;
            Pack.intToLittleEndian((int)l7, byArray, n3);
            long l8 = l4 + (l7 >>> 32);
            Pack.intToLittleEndian((int)l8, byArray, n3 + 4);
            long l9 = l5 + (l8 >>> 32);
            Pack.intToLittleEndian((int)l9, byArray, n3 + 8);
            Pack.intToLittleEndian((int)(l6 + (l9 >>> 32)), byArray, n3 + 12);
            poly1305.reset();
            return 16;
        }
        throw new OutputLengthException("Output buffer is too short.");
    }

    @Override
    public void reset() {
        Poly1305 poly1305 = this;
        poly1305.currentBlockOffset = 0;
        poly1305.h4 = 0;
        poly1305.h3 = 0;
        poly1305.h2 = 0;
        poly1305.h1 = 0;
        poly1305.h0 = 0;
    }
}

