/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SipHash
implements Mac {
    public final int c;
    public final int d;
    public long k0;
    public long k1;
    public long v0;
    public long v1;
    public long v2;
    public long v3;
    public long m = 0L;
    public int wordPos = 0;
    public int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int n3, int n4) {
        this.c = n3;
        this.d = n4;
    }

    public static long rotateLeft(long l3, int n3) {
        return l3 << n3 | l3 >>> -n3;
    }

    @Override
    public String getAlgorithmName() {
        return b.a("SipHash-").append(this.c).append("-").append(this.d).toString();
    }

    @Override
    public int getMacSize() {
        return 8;
    }

    @Override
    public void init(CipherParameters object) {
        if (object instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)object).getKey();
            object = byArray;
            if (byArray.length == 16) {
                this.k0 = Pack.littleEndianToLong((byte[])object, 0);
                this.k1 = Pack.littleEndianToLong((byte[])object, 8);
                this.reset();
                return;
            }
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
    }

    @Override
    public void update(byte by) {
        SipHash sipHash = this;
        sipHash.m = sipHash.m >>> 8 | ((long)by & 0xFFL) << 56;
        this.wordPos = sipHash.wordPos + 1;
        if (this.wordPos == 8) {
            this.processMessageWord();
            this.wordPos = 0;
        }
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        int n5;
        int n6 = n4 & 0xFFFFFFF8;
        int n7 = this.wordPos;
        if (n7 == 0) {
            for (n5 = 0; n5 < n6; n5 += 8) {
                this.m = Pack.littleEndianToLong(byArray, n3 + n5);
                this.processMessageWord();
            }
            while (n5 < n4) {
                this.m = this.m >>> 8 | ((long)byArray[n3 + n5] & 0xFFL) << 56;
                ++n5;
            }
            this.wordPos = n4 - n6;
        } else {
            n7 <<= 3;
            while (n5 < n6) {
                long l3 = Pack.littleEndianToLong(byArray, n3 + n5);
                this.m = l3 << n7 | this.m >>> -n7;
                this.processMessageWord();
                this.m = l3;
                n5 += 8;
            }
            while (n5 < n4) {
                SipHash sipHash = this;
                sipHash.m = sipHash.m >>> 8 | ((long)byArray[n3 + n5] & 0xFFL) << 56;
                this.wordPos = sipHash.wordPos + 1;
                if (this.wordPos == 8) {
                    this.processMessageWord();
                    this.wordPos = 0;
                }
                ++n5;
            }
        }
    }

    public long doFinal() {
        SipHash sipHash = this;
        int n3 = this.wordPos;
        sipHash.m = sipHash.m >>> (7 - n3 << 3) >>> 8 | ((long)((this.wordCount << 3) + n3) & 0xFFL) << 56;
        sipHash.processMessageWord();
        sipHash.v2 ^= 0xFFL;
        sipHash.applySipRounds(sipHash.d);
        long l3 = sipHash.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return l3;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        Pack.longToLittleEndian(this.doFinal(), byArray, n3);
        return 8;
    }

    @Override
    public void reset() {
        SipHash sipHash = this;
        long l3 = sipHash.k0;
        sipHash.v0 = l3 ^ 0x736F6D6570736575L;
        long l4 = sipHash.k1;
        this.v1 = l4 ^ 0x646F72616E646F6DL;
        this.v2 = l3 ^ 0x6C7967656E657261L;
        sipHash.v3 = l4 ^ 0x7465646279746573L;
        sipHash.m = 0L;
        sipHash.wordPos = 0;
        sipHash.wordCount = 0;
    }

    public void processMessageWord() {
        SipHash sipHash = this;
        ++sipHash.wordCount;
        sipHash.v3 ^= this.m;
        sipHash.applySipRounds(sipHash.c);
        sipHash.v0 ^= this.m;
    }

    public void applySipRounds(int n3) {
        SipHash sipHash = this;
        long l3 = sipHash.v0;
        long l4 = sipHash.v1;
        long l5 = sipHash.v2;
        long l6 = sipHash.v3;
        for (int i3 = 0; i3 < n3; ++i3) {
            long l7 = l5 + l6;
            l5 = l7;
            long l8 = l3 += l4;
            l4 = SipHash.rotateLeft(l4, 13);
            l3 = l4 ^ l3;
            l4 = SipHash.rotateLeft(l6, 16) ^ l5;
            l5 = SipHash.rotateLeft(l8, 32);
            long l9 = l7 + l3;
            l6 = l9;
            long l10 = l4;
            long l11 = l3;
            l3 = l5 + l4;
            l4 = SipHash.rotateLeft(l11, 17);
            l4 ^= l6;
            l6 = SipHash.rotateLeft(l10, 21) ^ l3;
            l5 = SipHash.rotateLeft(l9, 32);
        }
        SipHash sipHash2 = this;
        sipHash2.v0 = l3;
        sipHash2.v1 = l4;
        sipHash2.v2 = l5;
        sipHash2.v3 = l6;
    }
}

