/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class VMPCMac
implements Mac {
    private byte g;
    private byte n = 0;
    private byte[] P = null;
    private byte s = 0;
    private byte[] T;
    private byte[] workingIV;
    private byte[] workingKey;
    private byte x1;
    private byte x2;
    private byte x3;
    private byte x4;

    private void initKey(byte[] byArray, byte[] byArray2) {
        byte by;
        int n3;
        VMPCMac vMPCMac = this;
        vMPCMac.s = 0;
        vMPCMac.P = new byte[256];
        int n4 = 0;
        while (n4 < 256) {
            int n5 = n4++;
            this.P[n5] = (byte)n5;
        }
        for (n4 = 0; n4 < 768; ++n4) {
            byte by2;
            byte[] byArray3 = this.P;
            n3 = n4 & 0xFF;
            by = byArray3[n3];
            this.s = by2 = byArray3[this.s + by + byArray[n4 % byArray.length] & 0xFF];
            byArray3[n3] = byArray3[by2 & 0xFF];
            this.P[by2 & 0xFF] = by;
        }
        for (int i3 = 0; i3 < 768; ++i3) {
            byte[] byArray4 = this.P;
            int n6 = i3 & 0xFF;
            n3 = byArray4[n6];
            this.s = by = byArray4[this.s + n3 + byArray2[i3 % byArray2.length] & 0xFF];
            byArray4[n6] = byArray4[by & 0xFF];
            this.P[by & 0xFF] = n3;
        }
        this.n = 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        byte by;
        int n4;
        byte by2;
        int n5;
        int n6;
        for (n6 = 1; n6 < 25; ++n6) {
            int n7;
            VMPCMac vMPCMac = this;
            byte[] byArray2 = vMPCMac.P;
            n5 = vMPCMac.s;
            byte by3 = vMPCMac.n;
            by2 = by3;
            int n8 = byArray2[n5 + byArray2[by2 & 0xFF] & 0xFF];
            int n9 = n5 = n8;
            byte by4 = by2;
            byte by5 = by2;
            VMPCMac vMPCMac2 = this;
            VMPCMac vMPCMac3 = this;
            vMPCMac3.s = (byte)n5;
            by2 = vMPCMac3.x4;
            byte by6 = vMPCMac3.x3;
            n4 = by6;
            this.x4 = by2 = byArray2[by2 + n4 + n6 & 0xFF];
            byte by7 = this.x2;
            n4 = by7;
            this.x3 = by = byArray2[by6 + by7 + n6 & 0xFF];
            byte by8 = this.x1;
            this.x2 = n7 = byArray2[n4 + by8 + n6 & 0xFF];
            n5 = byArray2[by8 + n5 + n6 & 0xFF];
            vMPCMac2.x1 = (byte)n5;
            byte[] byArray3 = vMPCMac2.T;
            byte by9 = by8 = vMPCMac2.g;
            byte by10 = by8;
            byte by11 = by8;
            byte by12 = by8;
            n4 = by12 & 0x1F;
            byArray3[n4] = (byte)(byArray3[by12 & 0x1F] ^ n5);
            n5 = by11 + 1 & 0x1F;
            byArray3[n5] = (byte)(byArray3[by11 + 1 & 0x1F] ^ n7);
            n7 = by10 + 2 & 0x1F;
            byArray3[n7] = (byte)(byArray3[by10 + 2 & 0x1F] ^ by);
            n7 = by9 + 3 & 0x1F;
            byArray3[n7] = (byte)(byArray3[by9 + 3 & 0x1F] ^ by2);
            vMPCMac2.g = (byte)(by8 + 4 & 0x1F);
            n7 = byArray2[by5 & 0xFF];
            n5 = by4 & 0xFF;
            byArray2[n5] = byArray2[n9 & 0xFF];
            byArray2[n8 & 0xFF] = n7;
            vMPCMac.n = (byte)(by3 + 1 & 0xFF);
        }
        for (n6 = 0; n6 < 768; ++n6) {
            byte[] byArray4 = this.P;
            n5 = n6 & 0xFF;
            by2 = byArray4[n5];
            n4 = byArray4[this.s + by2 + this.T[n6 & 0x1F] & 0xFF];
            this.s = (byte)n4;
            byArray4[n5] = byArray4[n4 & 0xFF];
            this.P[n4 & 0xFF] = by2;
        }
        n6 = 20;
        byte[] byArray5 = new byte[20];
        for (n5 = 0; n5 < 20; ++n5) {
            byte[] byArray6 = this.P;
            n4 = n5 & 0xFF;
            this.s = by = byArray6[this.s + byArray6[n4] & 0xFF];
            byArray5[n5] = byArray6[byArray6[byArray6[by & 0xFF] & 0xFF] + 1 & 0xFF];
            by2 = byArray6[n4];
            byArray6[n4] = byArray6[by & 0xFF];
            this.P[by & 0xFF] = by2;
        }
        System.arraycopy(byArray5, 0, byArray, n3, n6);
        this.reset();
        return n6;
    }

    @Override
    public String getAlgorithmName() {
        return "VMPC-MAC";
    }

    @Override
    public int getMacSize() {
        return 20;
    }

    @Override
    public void init(CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            object = (ParametersWithIV)object;
            KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            if (((ParametersWithIV)object).getParameters() instanceof KeyParameter) {
                byte[] byArray = ((ParametersWithIV)object).getIV();
                object = byArray;
                this.workingIV = (byte[])object;
                if (byArray != null && ((Object)object).length >= 1 && ((Object)object).length <= 768) {
                    this.workingKey = keyParameter.getKey();
                    this.reset();
                    return;
                }
                throw new IllegalArgumentException("VMPC-MAC requires 1 to 768 bytes of IV");
            }
            throw new IllegalArgumentException("VMPC-MAC Init parameters must include a key");
        }
        throw new IllegalArgumentException("VMPC-MAC Init parameters must include an IV");
    }

    @Override
    public void reset() {
        VMPCMac vMPCMac = this;
        byte[] byArray = vMPCMac.workingKey;
        vMPCMac.initKey(byArray, vMPCMac.workingIV);
        vMPCMac.n = 0;
        vMPCMac.x4 = 0;
        vMPCMac.x3 = 0;
        vMPCMac.x2 = 0;
        vMPCMac.x1 = 0;
        vMPCMac.g = 0;
        vMPCMac.T = new byte[32];
        for (int i3 = 0; i3 < 32; ++i3) {
            this.T[i3] = 0;
        }
    }

    @Override
    public void update(byte by) {
        int n3;
        byte by2;
        VMPCMac vMPCMac = this;
        byte[] byArray = vMPCMac.P;
        byte by3 = vMPCMac.s;
        byte by4 = vMPCMac.n;
        byte by5 = by4;
        byte by6 = byArray[by3 + byArray[by5 & 0xFF] & 0xFF];
        byte by7 = by3 = by6;
        byte by8 = by5;
        byte[] byArray2 = byArray;
        byte by9 = by5;
        VMPCMac vMPCMac2 = this;
        VMPCMac vMPCMac3 = this;
        this.s = by3;
        by = (byte)(by ^ byArray[byArray[byArray[by3 & 0xFF] & 0xFF] + 1 & 0xFF]);
        by5 = vMPCMac3.x4;
        byte by10 = vMPCMac3.x3;
        byte by11 = by10;
        this.x4 = by5 = byArray[by5 + by11 & 0xFF];
        by11 = this.x2;
        this.x3 = by2 = byArray[by10 + by11 & 0xFF];
        byte by12 = this.x1;
        this.x2 = n3 = byArray[by11 + by12 & 0xFF];
        vMPCMac2.x1 = by = byArray[by12 + by3 + by & 0xFF];
        byArray = vMPCMac2.T;
        byte by13 = by3 = vMPCMac2.g;
        byte by14 = by3;
        byte by15 = by3;
        byte by16 = by3;
        int n4 = by16 & 0x1F;
        byArray[n4] = (byte)(byArray[by16 & 0x1F] ^ by);
        by = (byte)(by15 + 1 & 0x1F);
        byArray[by] = (byte)(byArray[by15 + 1 & 0x1F] ^ n3);
        n3 = by14 + 2 & 0x1F;
        byArray[n3] = (byte)(byArray[by14 + 2 & 0x1F] ^ by2);
        n3 = by13 + 3 & 0x1F;
        byArray[n3] = (byte)(byArray[by13 + 3 & 0x1F] ^ by5);
        vMPCMac2.g = (byte)(by3 + 4 & 0x1F);
        n3 = byArray2[by9 & 0xFF];
        by = (byte)(by8 & 0xFF);
        byArray[by] = byArray[by7 & 0xFF];
        byArray[by6 & 0xFF] = n3;
        vMPCMac.n = (byte)(by4 + 1 & 0xFF);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (n3 + n4 <= byArray.length) {
            for (int i3 = 0; i3 < n4; ++i3) {
                this.update(byArray[n3 + i3]);
            }
            return;
        }
        throw new DataLengthException("input buffer too short");
    }
}

