/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc128CoreEngine;

public final class Zuc128Mac
implements Mac {
    private static final int TOPBIT = 128;
    private final InternalZuc128Engine theEngine = new InternalZuc128Engine(null);
    private int theMac;
    private final int[] theKeyStream = new int[2];
    private Zuc128CoreEngine theState;
    private int theWordIndex;
    private int theByteIndex;

    private void initKeyStream() {
        int[] nArray;
        this.theMac = 0;
        int n3 = 0;
        while (true) {
            nArray = this.theKeyStream;
            if (n3 >= this.theKeyStream.length - 1) break;
            nArray[n3] = this.theEngine.createKeyStreamWord();
            ++n3;
        }
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.theWordIndex = nArray.length - 1;
        zuc128Mac.theByteIndex = 3;
    }

    private void shift4NextByte() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            Zuc128Mac zuc128Mac = this;
            zuc128Mac.theKeyStream[this.theWordIndex] = this.theEngine.createKeyStreamWord();
            zuc128Mac.theWordIndex = (zuc128Mac.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void updateMac(int n3) {
        this.theMac ^= this.getKeyStreamWord(n3);
    }

    private int getKeyStreamWord(int n3) {
        int[] nArray = this.theKeyStream;
        int n4 = this.theWordIndex;
        int n5 = this.theKeyStream[n4];
        if (n3 == 0) {
            return n5;
        }
        n4 = nArray[(n4 + 1) % nArray.length];
        return n5 << n3 | n4 >>> 32 - n3;
    }

    private int getFinalWord() {
        int n3;
        if (this.theByteIndex != 0) {
            return this.theEngine.createKeyStreamWord();
        }
        Zuc128Mac zuc128Mac = this;
        int n4 = zuc128Mac.theWordIndex + 1;
        int[] nArray = zuc128Mac.theKeyStream;
        this.theWordIndex = n3 = n4 % nArray.length;
        return zuc128Mac.theKeyStream[n3];
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc128Mac";
    }

    @Override
    public int getMacSize() {
        return 4;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.theEngine.init(true, cipherParameters);
        zuc128Mac.theState = (Zuc128CoreEngine)zuc128Mac.theEngine.copy();
        zuc128Mac.initKeyStream();
    }

    @Override
    public void update(byte by) {
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.shift4NextByte();
        int n3 = zuc128Mac.theByteIndex * 8;
        int n4 = 128;
        int n5 = 0;
        while (n4 > 0) {
            if ((by & n4) != 0) {
                this.updateMac(n3 + n5);
            }
            n4 >>= 1;
            ++n5;
        }
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            this.update(byArray[n3 + i3]);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        int n4;
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.shift4NextByte();
        Zuc128Mac zuc128Mac2 = this;
        this.theMac = n4 = zuc128Mac.theMac ^ zuc128Mac2.getKeyStreamWord(zuc128Mac2.theByteIndex * 8);
        this.theMac = n4 ^= this.getFinalWord();
        Zuc128CoreEngine.encode32be(n4, byArray, n3);
        zuc128Mac.reset();
        return zuc128Mac.getMacSize();
    }

    @Override
    public void reset() {
        Zuc128CoreEngine zuc128CoreEngine = this.theState;
        if (zuc128CoreEngine != null) {
            this.theEngine.reset(zuc128CoreEngine);
        }
        this.initKeyStream();
    }

    public static class InternalZuc128Engine
    extends Zuc128CoreEngine {
        private InternalZuc128Engine() {
        }

        public /* synthetic */ InternalZuc128Engine(1 var1_1) {
            this();
        }

        public int createKeyStreamWord() {
            return super.makeKeyStreamWord();
        }
    }
}

