/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc128CoreEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc256CoreEngine;

public final class Zuc256Mac
implements Mac {
    private static final int TOPBIT = 128;
    private final InternalZuc256Engine theEngine;
    private final int theMacLength;
    private final int[] theMac;
    private final int[] theKeyStream;
    private Zuc256CoreEngine theState;
    private int theWordIndex;
    private int theByteIndex;

    public Zuc256Mac(int n3) {
        this.theEngine = new InternalZuc256Engine(n3);
        this.theMacLength = n3;
        int n4 = n3 / 32;
        this.theMac = new int[n4];
        this.theKeyStream = new int[n4 + 1];
    }

    private void initKeyStream() {
        int[] nArray;
        int n3 = 0;
        while (true) {
            nArray = this.theMac;
            if (n3 >= this.theMac.length) break;
            nArray[n3] = this.theEngine.createKeyStreamWord();
            ++n3;
        }
        n3 = 0;
        while (true) {
            nArray = this.theKeyStream;
            if (n3 >= this.theKeyStream.length - 1) break;
            nArray[n3] = this.theEngine.createKeyStreamWord();
            ++n3;
        }
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.theWordIndex = nArray.length - 1;
        zuc256Mac.theByteIndex = 3;
    }

    private void shift4NextByte() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            Zuc256Mac zuc256Mac = this;
            zuc256Mac.theKeyStream[this.theWordIndex] = this.theEngine.createKeyStreamWord();
            zuc256Mac.theWordIndex = (zuc256Mac.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void shift4Final() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            this.theWordIndex = (this.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void updateMac(int n3) {
        int n4 = 0;
        while (true) {
            int[] nArray = this.theMac;
            if (n4 >= this.theMac.length) break;
            nArray[n4] = nArray[n4] ^ this.getKeyStreamWord(n4, n3);
            ++n4;
        }
    }

    private int getKeyStreamWord(int n3, int n4) {
        int[] nArray = this.theKeyStream;
        int n5 = this.theWordIndex;
        int n6 = this.theKeyStream[(n5 + n3) % nArray.length];
        if (n4 == 0) {
            return n6;
        }
        n5 = nArray[(n5 + n3 + 1) % nArray.length];
        return n6 << n4 | n5 >>> 32 - n4;
    }

    @Override
    public String getAlgorithmName() {
        return b.a("Zuc256Mac-").append(this.theMacLength).toString();
    }

    @Override
    public int getMacSize() {
        return this.theMacLength / 8;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.theEngine.init(true, cipherParameters);
        zuc256Mac.theState = (Zuc256CoreEngine)zuc256Mac.theEngine.copy();
        zuc256Mac.initKeyStream();
    }

    @Override
    public void update(byte by) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.shift4NextByte();
        int n3 = zuc256Mac.theByteIndex * 8;
        int n4 = 128;
        int n5 = 0;
        while (n4 > 0) {
            if ((by & n4) != 0) {
                this.updateMac(n3 + n5);
            }
            n4 >>= 1;
            ++n5;
        }
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            this.update(byArray[n3 + i3]);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.shift4Final();
        zuc256Mac.updateMac(zuc256Mac.theByteIndex * 8);
        int n4 = 0;
        while (true) {
            int[] nArray = this.theMac;
            if (n4 >= this.theMac.length) break;
            Zuc128CoreEngine.encode32be(nArray[n4], byArray, n4 * 4 + n3);
            ++n4;
        }
        Zuc256Mac zuc256Mac2 = this;
        zuc256Mac2.reset();
        return zuc256Mac2.getMacSize();
    }

    @Override
    public void reset() {
        Zuc256CoreEngine zuc256CoreEngine = this.theState;
        if (zuc256CoreEngine != null) {
            this.theEngine.reset(zuc256CoreEngine);
        }
        this.initKeyStream();
    }

    public static class InternalZuc256Engine
    extends Zuc256CoreEngine {
        public InternalZuc256Engine(int n3) {
            super(n3);
        }

        public int createKeyStreamWord() {
            return super.makeKeyStreamWord();
        }
    }
}

