/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CBCBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] cbcV;
    private byte[] cbcNextV;
    private int blockSize;
    private BlockCipher cipher;
    private boolean encrypting;

    public CBCBlockCipher(BlockCipher blockCipher) {
        int n3;
        CBCBlockCipher cBCBlockCipher = this;
        this.cipher = blockCipher;
        cBCBlockCipher.blockSize = n3 = blockCipher.getBlockSize();
        cBCBlockCipher.IV = new byte[n3];
        cBCBlockCipher.cbcV = new byte[n3];
        cBCBlockCipher.cbcNextV = new byte[n3];
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (n3 + ((CBCBlockCipher)object).blockSize <= byArray.length) {
            for (int i3 = 0; i3 < ((CBCBlockCipher)object).blockSize; ++i3) {
                ((CBCBlockCipher)object).cbcV[i3] = (byte)(((CBCBlockCipher)object).cbcV[i3] ^ byArray[n3 + i3]);
            }
            int n5 = ((CBCBlockCipher)object).cipher.processBlock(((CBCBlockCipher)object).cbcV, 0, byArray2, n4);
            Object object = ((CBCBlockCipher)object).cbcV;
            int n6 = ((CBCBlockCipher)object).cbcV.length;
            System.arraycopy(byArray2, n4, object, 0, n6);
            return n5;
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = ((CBCBlockCipher)object).blockSize;
        if (n3 + n5 <= byArray.length) {
            System.arraycopy(byArray, n3, ((CBCBlockCipher)object).cbcNextV, 0, n5);
            int n6 = ((CBCBlockCipher)object).cipher.processBlock(byArray, n3, byArray2, n4);
            for (n3 = 0; n3 < ((CBCBlockCipher)object).blockSize; ++n3) {
                n5 = n4 + n3;
                byArray2[n5] = (byte)(byArray2[n5] ^ ((CBCBlockCipher)object).cbcV[n3]);
            }
            CBCBlockCipher cBCBlockCipher = object;
            Object object = cBCBlockCipher.cbcV;
            cBCBlockCipher.cbcV = cBCBlockCipher.cbcNextV;
            cBCBlockCipher.cbcNextV = (byte[])object;
            return n6;
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block11: {
            block9: {
                boolean bl2;
                block10: {
                    block7: {
                        block8: {
                            bl2 = this.encrypting;
                            this.encrypting = bl;
                            if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                            byte[] byArray = ((ParametersWithIV)(cipherParameters = (ParametersWithIV)cipherParameters)).getIV();
                            if (byArray.length != this.blockSize) break block8;
                            byArray = this.IV;
                            int n3 = byArray.length;
                            System.arraycopy(byArray, 0, byArray, 0, n3);
                            this.reset();
                            if (((ParametersWithIV)cipherParameters).getParameters() != null) {
                                this.cipher.init(bl, ((ParametersWithIV)cipherParameters).getParameters());
                            } else if (bl2 != bl) {
                                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
                            }
                            break block9;
                        }
                        throw new IllegalArgumentException("initialisation vector must be the same length as block size");
                    }
                    this.reset();
                    if (cipherParameters == null) break block10;
                    this.cipher.init(bl, cipherParameters);
                    break block9;
                }
                if (bl2 != bl) break block11;
            }
            return;
        }
        throw new IllegalArgumentException("cannot change encrypting state without providing key.");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CBC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        return this.encrypting ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
    }

    @Override
    public void reset() {
        CBCBlockCipher cBCBlockCipher = object;
        Object object = ((CBCBlockCipher)object).cbcV;
        int n3 = cBCBlockCipher.IV.length;
        System.arraycopy(cBCBlockCipher.IV, 0, object, 0, n3);
        Arrays.fill(cBCBlockCipher.cbcNextV, (byte)0);
        cBCBlockCipher.cipher.reset();
    }
}

