/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CFBBlockCipher
extends StreamBlockCipher {
    private byte[] IV;
    private byte[] cfbV;
    private byte[] cfbOutV;
    private byte[] inBuf;
    private int blockSize;
    private BlockCipher cipher = null;
    private boolean encrypting;
    private int byteCount;

    public CFBBlockCipher(BlockCipher blockCipher, int n3) {
        super(blockCipher);
        if (n3 <= blockCipher.getBlockSize() * 8 && n3 >= 8 && n3 % 8 == 0) {
            this.cipher = blockCipher;
            this.blockSize = n3 / 8;
            this.IV = new byte[blockCipher.getBlockSize()];
            this.cfbV = new byte[blockCipher.getBlockSize()];
            this.cfbOutV = new byte[blockCipher.getBlockSize()];
            this.inBuf = new byte[this.blockSize];
            return;
        }
        throw new IllegalArgumentException(f.a("CFB", n3, " not supported"));
    }

    private byte encryptByte(byte by) {
        int n3;
        byte[] byArray;
        if (this.byteCount == 0) {
            CFBBlockCipher cFBBlockCipher = this;
            byte[] byArray2 = cFBBlockCipher.cfbV;
            byArray = cFBBlockCipher.cfbOutV;
            this.cipher.processBlock(byArray2, 0, byArray, 0);
        }
        CFBBlockCipher cFBBlockCipher = this;
        int n4 = this.byteCount;
        by = (byte)(cFBBlockCipher.cfbOutV[n4] ^ by);
        byArray = cFBBlockCipher.inBuf;
        this.byteCount = n3 = n4 + 1;
        byArray[n4] = by;
        n4 = this.blockSize;
        if (n3 == n4) {
            CFBBlockCipher cFBBlockCipher2 = this;
            cFBBlockCipher2.byteCount = 0;
            byArray = cFBBlockCipher2.cfbV;
            int n5 = n4;
            n4 = byArray.length - n4;
            System.arraycopy(cFBBlockCipher2.cfbV, n5, byArray, 0, n4);
            byte[] byArray3 = this.cfbV;
            int n6 = this.blockSize;
            int n7 = this.cfbV.length - n6;
            System.arraycopy(cFBBlockCipher2.inBuf, 0, byArray3, n7, n6);
        }
        return by;
    }

    private byte decryptByte(byte by) {
        int n3;
        byte[] byArray;
        if (this.byteCount == 0) {
            CFBBlockCipher cFBBlockCipher = this;
            byte[] byArray2 = cFBBlockCipher.cfbV;
            byArray = cFBBlockCipher.cfbOutV;
            this.cipher.processBlock(byArray2, 0, byArray, 0);
        }
        CFBBlockCipher cFBBlockCipher = this;
        int n4 = this.byteCount;
        cFBBlockCipher.inBuf[n4] = by;
        byArray = cFBBlockCipher.cfbOutV;
        this.byteCount = n3 = n4 + 1;
        by = (byte)(byArray[n4] ^ by);
        n4 = this.blockSize;
        if (n3 == n4) {
            CFBBlockCipher cFBBlockCipher2 = this;
            cFBBlockCipher2.byteCount = 0;
            byArray = cFBBlockCipher2.cfbV;
            int n5 = n4;
            n4 = byArray.length - n4;
            System.arraycopy(cFBBlockCipher2.cfbV, n5, byArray, 0, n4);
            byte[] byArray3 = this.cfbV;
            int n6 = this.blockSize;
            int n7 = this.cfbV.length - n6;
            System.arraycopy(cFBBlockCipher2.inBuf, 0, byArray3, n7, n6);
        }
        return by;
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.encrypting = bl;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n3 = byArray2.length - ((Object)object).length;
                int n4 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n3, n4);
                int n5 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n5 < this.IV.length - ((Object)object).length) {
                        byArray3[n5] = 0;
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else {
                int n6 = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n6);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CFB" + this.blockSize * 8;
    }

    @Override
    public byte calculateByte(byte by) {
        return this.encrypting ? this.encryptByte(by) : this.decryptByte(by);
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        CFBBlockCipher cFBBlockCipher = this;
        cFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return cFBBlockCipher.blockSize;
    }

    public int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        CFBBlockCipher cFBBlockCipher = this;
        cFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return cFBBlockCipher.blockSize;
    }

    public int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        CFBBlockCipher cFBBlockCipher = this;
        cFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return cFBBlockCipher.blockSize;
    }

    public byte[] getCurrentIV() {
        return Arrays.clone(this.cfbV);
    }

    @Override
    public void reset() {
        CFBBlockCipher cFBBlockCipher = object;
        Object object = ((CFBBlockCipher)object).cfbV;
        int n3 = cFBBlockCipher.IV.length;
        System.arraycopy(cFBBlockCipher.IV, 0, object, 0, n3);
        Arrays.fill(cFBBlockCipher.inBuf, (byte)0);
        cFBBlockCipher.byteCount = 0;
        cFBBlockCipher.cipher.reset();
    }
}

