/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;

public class CTSBlockCipher
extends BufferedBlockCipher {
    private int blockSize;

    public CTSBlockCipher(BlockCipher blockCipher) {
        if (!(blockCipher instanceof StreamBlockCipher)) {
            CTSBlockCipher cTSBlockCipher = this;
            this.cipher = blockCipher;
            this.blockSize = blockCipher.getBlockSize();
            cTSBlockCipher.buf = new byte[this.blockSize * 2];
            cTSBlockCipher.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("CTSBlockCipher can only accept ECB, or CBC ciphers");
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        Object object = ((BufferedBlockCipher)object).buf;
        int n4 = (n3 += ((BufferedBlockCipher)object).bufOff) % ((BufferedBlockCipher)object).buf.length;
        if (n4 == 0) {
            return n3 - ((Object)object).length;
        }
        return n3 - n4;
    }

    @Override
    public int getOutputSize(int n3) {
        return n3 + this.bufOff;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        int n4 = 0;
        byte[] byArray2 = this.buf;
        if (this.bufOff == this.buf.length) {
            CTSBlockCipher cTSBlockCipher = this;
            n4 = cTSBlockCipher.cipher.processBlock(byArray2, 0, byArray, n3);
            byArray = cTSBlockCipher.buf;
            n3 = this.blockSize;
            System.arraycopy(cTSBlockCipher.buf, n3, byArray, 0, n3);
            cTSBlockCipher.bufOff = cTSBlockCipher.blockSize;
        }
        int n5 = this.bufOff;
        this.bufOff = n5 + 1;
        this.buf[n5] = by;
        return n4;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n4 >= 0) {
            CTSBlockCipher cTSBlockCipher = object;
            int n6 = cTSBlockCipher.getBlockSize();
            int n7 = cTSBlockCipher.getUpdateOutputSize(n4);
            if (n7 > 0 && n5 + n7 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n7 = 0;
            byte[] byArray3 = ((BufferedBlockCipher)object).buf;
            int n8 = ((BufferedBlockCipher)object).bufOff;
            int n9 = ((BufferedBlockCipher)object).buf.length - n8;
            if (n4 > n9) {
                int n10 = n3;
                CTSBlockCipher cTSBlockCipher2 = object;
                System.arraycopy(byArray, n3, byArray3, n8, n9);
                n3 = cTSBlockCipher2.cipher.processBlock(((BufferedBlockCipher)object).buf, 0, byArray2, n5) + n7;
                System.arraycopy(cTSBlockCipher2.buf, n6, cTSBlockCipher2.buf, 0, n6);
                ((BufferedBlockCipher)object).bufOff = n6;
                n4 -= n9;
                int n11 = n7 = n10 + n9;
                n7 = n3;
                n3 = n11;
                while (n4 > n6) {
                    int n12 = n3;
                    int n13 = n4;
                    Object object = object;
                    Object object2 = object;
                    byte[] byArray4 = ((BufferedBlockCipher)object2).buf;
                    System.arraycopy(byArray, n3, byArray4, ((BufferedBlockCipher)object2).bufOff, n6);
                    byArray4 = ((BufferedBlockCipher)object).buf;
                    n4 = n5 + n7;
                    n3 = ((BufferedBlockCipher)object).cipher.processBlock(byArray4, 0, byArray2, n4) + n7;
                    System.arraycopy(((BufferedBlockCipher)object).buf, n6, ((BufferedBlockCipher)object).buf, 0, n6);
                    n4 = n13 - n6;
                    int n14 = n7 = n12 + n6;
                    n7 = n3;
                    n3 = n14;
                }
            }
            CTSBlockCipher cTSBlockCipher3 = object;
            CTSBlockCipher cTSBlockCipher4 = object;
            Object object = cTSBlockCipher4.buf;
            System.arraycopy(byArray, n3, object, cTSBlockCipher4.bufOff, n4);
            cTSBlockCipher3.bufOff += n4;
            return n7;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block14: {
            block18: {
                block17: {
                    byte[] byArray2;
                    int n4;
                    int n5;
                    int n6;
                    block15: {
                        block16: {
                            if (this.bufOff + n3 > byArray.length) break block14;
                            CTSBlockCipher cTSBlockCipher = this;
                            n6 = cTSBlockCipher.cipher.getBlockSize();
                            n5 = this.bufOff;
                            n4 = n5 - n6;
                            byArray2 = new byte[n6];
                            if (!cTSBlockCipher.forEncryption) break block15;
                            if (n5 < n6) break block16;
                            CTSBlockCipher cTSBlockCipher2 = this;
                            cTSBlockCipher2.cipher.processBlock(this.buf, 0, byArray2, 0);
                            n5 = cTSBlockCipher2.bufOff;
                            if (n5 > n6) {
                                while (true) {
                                    byte[] byArray3 = this.buf;
                                    if (n5 == this.buf.length) break;
                                    byArray3[n5] = byArray2[n5 - n6];
                                    ++n5;
                                }
                                for (n5 = n6; n5 != this.bufOff; ++n5) {
                                    this.buf[n5] = (byte)(this.buf[n5] ^ byArray2[n5 - n6]);
                                }
                                BlockCipher blockCipher = this.cipher;
                                if (blockCipher instanceof CBCBlockCipher) {
                                    ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, n6, byArray, n3);
                                } else {
                                    blockCipher.processBlock(this.buf, n6, byArray, n3);
                                }
                                System.arraycopy(byArray2, 0, byArray, n3 += n6, n4);
                            } else {
                                System.arraycopy(byArray2, 0, byArray, n3, n6);
                            }
                            break block17;
                        }
                        throw new DataLengthException("need at least one block of input for CTS");
                    }
                    if (n5 < n6) break block18;
                    byte[] byArray4 = new byte[n6];
                    if (n5 > n6) {
                        BlockCipher blockCipher = this.cipher;
                        if (blockCipher instanceof CBCBlockCipher) {
                            ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, 0, byArray2, 0);
                        } else {
                            blockCipher.processBlock(this.buf, 0, byArray2, 0);
                        }
                        for (int i3 = n6; i3 != this.bufOff; ++i3) {
                            int n7 = i3 - n6;
                            byArray4[n7] = (byte)(byArray2[n7] ^ this.buf[i3]);
                        }
                        CTSBlockCipher cTSBlockCipher = this;
                        System.arraycopy(cTSBlockCipher.buf, n6, byArray2, 0, n4);
                        cTSBlockCipher.cipher.processBlock(byArray2, 0, byArray, n3);
                        System.arraycopy(byArray4, 0, byArray, n3 += n6, n4);
                    } else {
                        this.cipher.processBlock(this.buf, 0, byArray2, 0);
                        System.arraycopy(byArray2, 0, byArray, n3, n6);
                    }
                }
                this.reset();
                return this.bufOff;
            }
            throw new DataLengthException("need at least one block of input for CTS");
        }
        throw new OutputLengthException("output buffer to small in doFinal");
    }
}

