/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.Poly1305;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class ChaCha20Poly1305
implements AEADCipher {
    private static final int BUF_SIZE = 64;
    private static final int KEY_SIZE = 32;
    private static final int NONCE_SIZE = 12;
    private static final int MAC_SIZE = 16;
    private static final byte[] ZEROES = new byte[15];
    private static final long AAD_LIMIT = -1L;
    private static final long DATA_LIMIT = 274877906880L;
    private final ChaCha7539Engine chacha20;
    private final Mac poly1305;
    private final byte[] key;
    private final byte[] nonce;
    private final byte[] buf;
    private final byte[] mac;
    private byte[] initialAAD;
    private long aadCount;
    private long dataCount;
    private int state;
    private int bufPos;

    public ChaCha20Poly1305() {
        Poly1305 poly1305;
        ChaCha20Poly1305 chaCha20Poly1305 = poly13052;
        Poly1305 poly13052 = poly1305;
        poly1305 = new Poly1305();
        chaCha20Poly1305(poly13052);
    }

    public ChaCha20Poly1305(Mac mac) {
        ((ChaCha20Poly1305)((Object)chaCha7539Engine2)).key = new byte[32];
        ((ChaCha20Poly1305)((Object)chaCha7539Engine2)).nonce = new byte[12];
        ((ChaCha20Poly1305)((Object)chaCha7539Engine2)).buf = new byte[80];
        ((ChaCha20Poly1305)((Object)chaCha7539Engine2)).mac = new byte[16];
        ((ChaCha20Poly1305)((Object)chaCha7539Engine2)).state = 0;
        if (mac != null) {
            if (16 == mac.getMacSize()) {
                ChaCha7539Engine chaCha7539Engine;
                ChaCha20Poly1305 chaCha20Poly1305 = chaCha7539Engine2;
                ChaCha7539Engine chaCha7539Engine2 = chaCha7539Engine;
                chaCha7539Engine = new ChaCha7539Engine();
                chaCha20Poly1305.chacha20 = chaCha7539Engine2;
                chaCha20Poly1305.poly1305 = mac;
                return;
            }
            throw new IllegalArgumentException("'poly1305' must be a 128-bit MAC");
        }
        throw new NullPointerException("'poly1305' cannot be null");
    }

    private void checkAAD() {
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 5: {
                this.state = 6;
                break;
            }
            case 4: {
                throw new IllegalStateException("ChaCha20Poly1305 cannot be reused for encryption");
            }
            case 1: {
                this.state = 2;
            }
            case 2: 
            case 6: 
        }
    }

    private void checkData() {
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 5: 
            case 6: {
                this.finishAAD(7);
                break;
            }
            case 4: {
                throw new IllegalStateException("ChaCha20Poly1305 cannot be reused for encryption");
            }
            case 1: 
            case 2: {
                this.finishAAD(3);
            }
            case 3: 
            case 7: 
        }
    }

    private void finishAAD(int n3) {
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.padMAC(chaCha20Poly1305.aadCount);
        this.state = n3;
    }

    private void finishData(int n3) {
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.padMAC(chaCha20Poly1305.dataCount);
        byte[] byArray = new byte[16];
        Pack.longToLittleEndian(chaCha20Poly1305.aadCount, byArray, 0);
        Pack.longToLittleEndian(chaCha20Poly1305.dataCount, byArray, 8);
        chaCha20Poly1305.poly1305.update(byArray, 0, 16);
        chaCha20Poly1305.poly1305.doFinal(this.mac, 0);
        this.state = n3;
    }

    private long incrementCount(long l3, int n3, long l4) {
        long l5 = n3;
        if (l3 + Long.MIN_VALUE <= l4 - l5 + Long.MIN_VALUE) {
            return l3 + l5;
        }
        throw new IllegalStateException("Limit exceeded");
    }

    private void initMAC() {
        ChaCha20Poly1305 chaCha20Poly1305;
        byte[] byArray = new byte[64];
        try {
            ChaCha20Poly1305 chaCha20Poly13052 = this;
            chaCha20Poly1305 = chaCha20Poly13052;
            chaCha20Poly13052.chacha20.processBytes(byArray, 0, 64, byArray, 0);
        }
        catch (Throwable throwable) {
            Arrays.clear(byArray);
            throw throwable;
        }
        chaCha20Poly1305.poly1305.init(new KeyParameter(byArray, 0, 32));
        Arrays.clear(byArray);
    }

    private void padMAC(long l3) {
        int n3 = (int)l3 & 0xF;
        if (n3 != 0) {
            this.poly1305.update(ZEROES, 0, 16 - n3);
        }
    }

    private void processData(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n5 <= byArray2.length - n4) {
            ChaCha20Poly1305 chaCha20Poly1305 = this;
            chaCha20Poly1305.chacha20.processBytes(byArray, n3, n4, byArray2, n5);
            chaCha20Poly1305.dataCount = chaCha20Poly1305.incrementCount(chaCha20Poly1305.dataCount, n4, 274877906880L);
            return;
        }
        throw new OutputLengthException("Output buffer too short");
    }

    private void reset(boolean bl, boolean bl2) {
        Arrays.clear(this.buf);
        if (bl) {
            Arrays.clear(this.mac);
        }
        this.aadCount = 0L;
        this.dataCount = 0L;
        this.bufPos = 0;
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 6: 
            case 7: 
            case 8: {
                this.state = 5;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.state = 4;
                return;
            }
            case 1: 
            case 5: 
        }
        if (bl2) {
            this.chacha20.reset();
        }
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.initMAC();
        byte[] byArray = chaCha20Poly1305.initialAAD;
        if (chaCha20Poly1305.initialAAD != null) {
            int n3 = byArray.length;
            this.processAADBytes(byArray, 0, n3);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "ChaCha20Poly1305";
    }

    @Override
    public void init(boolean n3, CipherParameters cipherParameters) {
        block11: {
            block14: {
                ParametersWithIV parametersWithIV;
                byte[] byArray;
                block13: {
                    block12: {
                        block10: {
                            block8: {
                                int n4;
                                block9: {
                                    ParametersWithIV parametersWithIV2;
                                    if (!(cipherParameters instanceof AEADParameters)) break block8;
                                    n4 = ((AEADParameters)(cipherParameters = (AEADParameters)cipherParameters)).getMacSize();
                                    if (128 != n4) break block9;
                                    CipherParameters cipherParameters2 = cipherParameters;
                                    cipherParameters = ((AEADParameters)cipherParameters2).getKey();
                                    byArray = ((AEADParameters)cipherParameters2).getNonce();
                                    parametersWithIV = parametersWithIV2;
                                    parametersWithIV2 = new ParametersWithIV(cipherParameters, byArray);
                                    this.initialAAD = ((AEADParameters)cipherParameters2).getAssociatedText();
                                    break block10;
                                }
                                throw new IllegalArgumentException(a.a("Invalid value for MAC size: ", n4));
                            }
                            if (!(cipherParameters instanceof ParametersWithIV)) break block11;
                            parametersWithIV = (ParametersWithIV)cipherParameters;
                            cipherParameters = (KeyParameter)parametersWithIV.getParameters();
                            byArray = parametersWithIV.getIV();
                            this.initialAAD = null;
                        }
                        if (cipherParameters != null) break block12;
                        if (this.state == 0) {
                            throw new IllegalArgumentException("Key must be specified in initial init");
                        }
                        break block13;
                    }
                    if (32 != ((KeyParameter)cipherParameters).getKey().length) break block14;
                }
                if (byArray != null && 12 == byArray.length) {
                    if (this.state != 0 && n3 != 0 && Arrays.areEqual(this.nonce, byArray) && (cipherParameters == null || Arrays.areEqual(this.key, ((KeyParameter)cipherParameters).getKey()))) {
                        throw new IllegalArgumentException("cannot reuse nonce for ChaCha20Poly1305 encryption");
                    }
                    if (cipherParameters != null) {
                        System.arraycopy(((KeyParameter)cipherParameters).getKey(), 0, this.key, 0, 32);
                    }
                    System.arraycopy(byArray, 0, this.nonce, 0, 12);
                    this.chacha20.init(true, parametersWithIV);
                    n3 = n3 != 0 ? 1 : 5;
                    this.state = n3;
                    this.reset(true, false);
                    return;
                }
                throw new IllegalArgumentException("Nonce must be 96 bits");
            }
            throw new IllegalArgumentException("Key must be 256 bits");
        }
        throw new IllegalArgumentException("invalid parameters passed to ChaCha20Poly1305");
    }

    @Override
    public int getOutputSize(int n3) {
        int n4 = Math.max(0, n3) + this.bufPos;
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 5: 
            case 6: 
            case 7: {
                return Math.max(0, n4 - 16);
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return n4 + 16;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        int n4 = Math.max(0, n3) + this.bufPos;
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 5: 
            case 6: 
            case 7: {
                n4 = Math.max(0, n4 - 16);
            }
            case 1: 
            case 2: 
            case 3: 
        }
        int n5 = n4;
        return n5 - n5 % 64;
    }

    @Override
    public void processAADByte(byte by) {
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.checkAAD();
        chaCha20Poly1305.aadCount = chaCha20Poly1305.incrementCount(chaCha20Poly1305.aadCount, 1, -1L);
        chaCha20Poly1305.poly1305.update(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        if (byArray != null) {
            if (n3 >= 0) {
                if (n4 >= 0) {
                    if (n3 <= byArray.length - n4) {
                        this.checkAAD();
                        if (n4 > 0) {
                            ChaCha20Poly1305 chaCha20Poly1305 = this;
                            chaCha20Poly1305.aadCount = chaCha20Poly1305.incrementCount(chaCha20Poly1305.aadCount, n4, -1L);
                            chaCha20Poly1305.poly1305.update(byArray, n3, n4);
                        }
                        return;
                    }
                    throw new DataLengthException("Input buffer too short");
                }
                throw new IllegalArgumentException("'len' cannot be negative");
            }
            throw new IllegalArgumentException("'inOff' cannot be negative");
        }
        throw new NullPointerException("'in' cannot be null");
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.checkData();
        int n4 = chaCha20Poly1305.state;
        if (n4 != 3) {
            if (n4 == 7) {
                byte[] byArray2 = this.buf;
                int n5 = this.bufPos;
                this.buf[n5] = by;
                int n6 = n5 + 1;
                by = (byte)n6;
                this.bufPos = by;
                if (n6 == byArray2.length) {
                    ChaCha20Poly1305 chaCha20Poly13052 = this;
                    chaCha20Poly13052.poly1305.update(byArray2, 0, 64);
                    chaCha20Poly13052.processData(chaCha20Poly13052.buf, 0, 64, byArray, n3);
                    System.arraycopy(chaCha20Poly13052.buf, 64, chaCha20Poly13052.buf, 0, 16);
                    chaCha20Poly13052.bufPos = 16;
                    return 64;
                }
                return 0;
            }
            throw new IllegalStateException();
        }
        byte[] byArray3 = this.buf;
        int n7 = this.bufPos;
        this.buf[n7] = by;
        this.bufPos = n7 + 1;
        if (this.bufPos == 64) {
            ChaCha20Poly1305 chaCha20Poly13053 = this;
            chaCha20Poly13053.processData(byArray3, 0, 64, byArray, n3);
            chaCha20Poly13053.poly1305.update(byArray, n3, 64);
            chaCha20Poly13053.bufPos = 0;
            return 64;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (byArray == null) throw new NullPointerException("'in' cannot be null");
        if (n3 < 0) throw new IllegalArgumentException("'inOff' cannot be negative");
        if (n4 < 0) throw new IllegalArgumentException("'len' cannot be negative");
        if (n3 > byArray.length - n4) throw new DataLengthException("Input buffer too short");
        if (n5 < 0) throw new IllegalArgumentException("'outOff' cannot be negative");
        ChaCha20Poly1305 chaCha20Poly1305 = this;
        chaCha20Poly1305.checkData();
        int n6 = 0;
        int n7 = chaCha20Poly1305.state;
        if (n7 != 3) {
            if (n7 != 7) throw new IllegalStateException();
            for (n7 = 0; n7 < n4; ++n7) {
                byte[] byArray3 = this.buf;
                int n8 = this.bufPos;
                this.buf[n8] = byArray[n3 + n7];
                this.bufPos = ++n8;
                if (n8 != byArray3.length) continue;
                ChaCha20Poly1305 chaCha20Poly13052 = this;
                ChaCha20Poly1305 chaCha20Poly13053 = this;
                chaCha20Poly13053.poly1305.update(byArray3, 0, 64);
                byArray3 = chaCha20Poly13053.buf;
                n8 = n5 + n6;
                chaCha20Poly13052.processData(byArray3, 0, 64, byArray2, n8);
                System.arraycopy(chaCha20Poly13052.buf, 64, chaCha20Poly13052.buf, 0, 16);
                chaCha20Poly13052.bufPos = 16;
                n6 += 64;
            }
            return n6;
        } else {
            if (this.bufPos != 0) {
                while (n4 > 0) {
                    --n4;
                    byte[] byArray4 = this.buf;
                    int n9 = this.bufPos;
                    int n10 = n3 + 1;
                    this.buf[n9] = byArray[n3];
                    this.bufPos = n9 + 1;
                    if (this.bufPos == 64) {
                        ChaCha20Poly1305 chaCha20Poly13054 = this;
                        chaCha20Poly13054.processData(byArray4, 0, 64, byArray2, n5);
                        chaCha20Poly13054.poly1305.update(byArray2, n5, 64);
                        chaCha20Poly13054.bufPos = 0;
                        n6 = 64;
                        n3 = n10;
                        break;
                    }
                    n3 = n10;
                }
            }
            while (n4 >= 64) {
                ChaCha20Poly1305 chaCha20Poly13055 = this;
                n7 = n5 + n6;
                chaCha20Poly13055.processData(byArray, n3, 64, byArray2, n7);
                chaCha20Poly13055.poly1305.update(byArray2, n7, 64);
                n3 += 64;
                n4 -= 64;
                n6 += 64;
            }
            if (n4 <= 0) return n6;
            System.arraycopy(byArray, n3, this.buf, 0, n4);
            this.bufPos = n4;
        }
        return n6;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block7: {
            block8: {
                block14: {
                    int n4;
                    block13: {
                        block9: {
                            block10: {
                                block11: {
                                    block12: {
                                        if (byArray == null) break block7;
                                        if (n3 < 0) break block8;
                                        ChaCha20Poly1305 chaCha20Poly1305 = this;
                                        chaCha20Poly1305.checkData();
                                        Arrays.clear(chaCha20Poly1305.mac);
                                        n4 = chaCha20Poly1305.state;
                                        if (n4 == 3) break block9;
                                        if (n4 != 7) break block10;
                                        n4 = this.bufPos;
                                        if (n4 < 16) break block11;
                                        if (n3 > byArray.length - (n4 -= 16)) break block12;
                                        if (n4 > 0) {
                                            ChaCha20Poly1305 chaCha20Poly13052 = this;
                                            chaCha20Poly13052.poly1305.update(this.buf, 0, n4);
                                            chaCha20Poly13052.processData(chaCha20Poly13052.buf, 0, n4, byArray, n3);
                                        }
                                        ChaCha20Poly1305 chaCha20Poly13053 = this;
                                        chaCha20Poly13053.finishData(8);
                                        byArray = chaCha20Poly13053.mac;
                                        byte[] byArray2 = chaCha20Poly13053.buf;
                                        if (!Arrays.constantTimeAreEqual(16, byArray, 0, byArray2, n4)) {
                                            throw new InvalidCipherTextException("mac check in ChaCha20Poly1305 failed");
                                        }
                                        break block13;
                                    }
                                    throw new OutputLengthException("Output buffer too short");
                                }
                                throw new InvalidCipherTextException("data too short");
                            }
                            throw new IllegalStateException();
                        }
                        n4 = this.bufPos;
                        int n5 = n4 + 16;
                        if (n3 > byArray.length - n5) break block14;
                        if (n4 > 0) {
                            ChaCha20Poly1305 chaCha20Poly1305 = this;
                            chaCha20Poly1305.processData(chaCha20Poly1305.buf, 0, n4, byArray, n3);
                            chaCha20Poly1305.poly1305.update(byArray, n3, this.bufPos);
                        }
                        ChaCha20Poly1305 chaCha20Poly1305 = this;
                        chaCha20Poly1305.finishData(4);
                        System.arraycopy(chaCha20Poly1305.mac, 0, byArray, n3 += this.bufPos, 16);
                        n4 = n5;
                    }
                    this.reset(false, true);
                    return n4;
                }
                throw new OutputLengthException("Output buffer too short");
            }
            throw new IllegalArgumentException("'outOff' cannot be negative");
        }
        throw new NullPointerException("'out' cannot be null");
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }

    @Override
    public void reset() {
        this.reset(true, true);
    }

    public static final class State {
        public static final int UNINITIALIZED = 0;
        public static final int ENC_INIT = 1;
        public static final int ENC_AAD = 2;
        public static final int ENC_DATA = 3;
        public static final int ENC_FINAL = 4;
        public static final int DEC_INIT = 5;
        public static final int DEC_AAD = 6;
        public static final int DEC_DATA = 7;
        public static final int DEC_FINAL = 8;

        private State() {
        }
    }
}

