/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.CMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.SICBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class EAXBlockCipher
implements AEADBlockCipher {
    private static final byte nTAG = 0;
    private static final byte hTAG = 1;
    private static final byte cTAG = 2;
    private SICBlockCipher cipher;
    private boolean forEncryption;
    private int blockSize;
    private Mac mac;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public EAXBlockCipher(BlockCipher blockCipher) {
        CMac cMac;
        EAXBlockCipher eAXBlockCipher = cMac2;
        eAXBlockCipher.blockSize = blockCipher.getBlockSize();
        CMac cMac2 = cMac;
        eAXBlockCipher.mac = new CMac(blockCipher);
        eAXBlockCipher.macBlock = new byte[eAXBlockCipher.blockSize];
        eAXBlockCipher.associatedTextMac = new byte[cMac2.getMacSize()];
        eAXBlockCipher.nonceMac = new byte[eAXBlockCipher.mac.getMacSize()];
        eAXBlockCipher.cipher = new SICBlockCipher(blockCipher);
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.cipherInitialized = true;
        eAXBlockCipher.mac.doFinal(this.associatedTextMac, 0);
        int n3 = eAXBlockCipher.blockSize;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = byArray;
        byArray[n3 - 1] = 2;
        eAXBlockCipher.mac.update(byArray2, 0, n3);
    }

    private void calculateMac() {
        EAXBlockCipher eAXBlockCipher = this;
        byte[] byArray = new byte[eAXBlockCipher.blockSize];
        eAXBlockCipher.mac.doFinal(byArray, 0);
        int n3 = 0;
        while (true) {
            byte[] byArray2 = this.macBlock;
            if (n3 >= this.macBlock.length) break;
            byArray2[n3] = (byte)(this.nonceMac[n3] ^ this.associatedTextMac[n3] ^ byArray[n3]);
            ++n3;
        }
    }

    private void reset(boolean bl) {
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.cipher.reset();
        eAXBlockCipher.mac.reset();
        eAXBlockCipher.bufOff = 0;
        Arrays.fill(eAXBlockCipher.bufBlock, (byte)0);
        if (bl) {
            Arrays.fill(this.macBlock, (byte)0);
        }
        EAXBlockCipher eAXBlockCipher2 = this;
        int byArray3 = eAXBlockCipher2.blockSize;
        byte[] byArray = new byte[byArray3];
        byte[] byArray2 = byArray;
        byArray[byArray3 - 1] = 1;
        eAXBlockCipher2.mac.update(byArray2, 0, byArray3);
        eAXBlockCipher2.cipherInitialized = false;
        byte[] byArray4 = eAXBlockCipher2.initialAssociatedText;
        if (eAXBlockCipher2.initialAssociatedText != null) {
            int n3 = byArray4.length;
            this.processAADBytes(byArray4, 0, n3);
        }
    }

    private int process(byte by, byte[] byArray, int n3) {
        int n4;
        EAXBlockCipher eAXBlockCipher = this;
        byte[] byArray2 = eAXBlockCipher.bufBlock;
        int n5 = eAXBlockCipher.bufOff;
        this.bufOff = n4 = n5 + 1;
        byArray2[n5] = by;
        if (n4 == byArray2.length) {
            int n6 = this.blockSize;
            by = (byte)n6;
            if (byArray.length >= n3 + n6) {
                if (this.forEncryption) {
                    EAXBlockCipher eAXBlockCipher2 = this;
                    by = (byte)eAXBlockCipher2.cipher.processBlock(byArray2, 0, byArray, n3);
                    eAXBlockCipher2.mac.update(byArray, n3, this.blockSize);
                } else {
                    EAXBlockCipher eAXBlockCipher3 = this;
                    eAXBlockCipher3.mac.update(byArray2, 0, by);
                    by = (byte)eAXBlockCipher3.cipher.processBlock(this.bufBlock, 0, byArray, n3);
                }
                this.bufOff = 0;
                if (!this.forEncryption) {
                    EAXBlockCipher eAXBlockCipher4 = this;
                    EAXBlockCipher eAXBlockCipher5 = this;
                    int n7 = eAXBlockCipher5.blockSize;
                    int n8 = eAXBlockCipher5.macSize;
                    System.arraycopy(eAXBlockCipher4.bufBlock, n7, eAXBlockCipher4.bufBlock, 0, n8);
                    eAXBlockCipher4.bufOff = eAXBlockCipher4.macSize;
                }
                return by;
            }
            throw new OutputLengthException("Output buffer is too short");
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n3) {
        int n4 = 0;
        for (int i3 = 0; i3 < this.macSize; ++i3) {
            n4 |= this.macBlock[i3] ^ byArray[n3 + i3];
        }
        return n4 == 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "/EAX";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher.getUnderlyingCipher();
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block4: {
            ParametersWithIV parametersWithIV;
            CipherParameters cipherParameters;
            block3: {
                block2: {
                    this.forEncryption = bl;
                    if (!(object instanceof AEADParameters)) break block2;
                    AEADParameters aEADParameters = (AEADParameters)object;
                    object = aEADParameters;
                    CipherParameters cipherParameters2 = object;
                    CipherParameters cipherParameters3 = object;
                    object = ((AEADParameters)cipherParameters3).getNonce();
                    this.initialAssociatedText = ((AEADParameters)cipherParameters3).getAssociatedText();
                    this.macSize = ((AEADParameters)cipherParameters2).getMacSize() / 8;
                    cipherParameters = aEADParameters.getKey();
                    break block3;
                }
                if (!(object instanceof ParametersWithIV)) break block4;
                ParametersWithIV parametersWithIV2 = (ParametersWithIV)object;
                object = parametersWithIV2;
                object = ((ParametersWithIV)object).getIV();
                this.initialAssociatedText = null;
                this.macSize = this.mac.getMacSize() / 2;
                cipherParameters = parametersWithIV2.getParameters();
            }
            Object object2 = new byte[bl ? this.blockSize : this.blockSize + this.macSize];
            EAXBlockCipher eAXBlockCipher = this;
            eAXBlockCipher.bufBlock = object2;
            byte[] byArray = new byte[eAXBlockCipher.blockSize];
            object2 = byArray;
            EAXBlockCipher eAXBlockCipher2 = this;
            eAXBlockCipher2.mac.init(cipherParameters);
            int n3 = eAXBlockCipher2.blockSize;
            byArray[n3 - 1] = 0;
            eAXBlockCipher.mac.update((byte[])object2, 0, n3);
            Object object3 = object;
            eAXBlockCipher.mac.update((byte[])object3, 0, ((Object)object3).length);
            eAXBlockCipher.mac.doFinal(this.nonceMac, 0);
            object2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(null, this.nonceMac);
            eAXBlockCipher.cipher.init(true, (CipherParameters)object2);
            eAXBlockCipher.reset();
            return;
        }
        throw new IllegalArgumentException("invalid parameters passed to EAX");
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void processAADByte(byte by) {
        if (!this.cipherInitialized) {
            this.mac.update(by);
            return;
        }
        throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        if (!this.cipherInitialized) {
            this.mac.update(byArray, n3, n4);
            return;
        }
        throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        this.initCipher();
        return this.process(by, byArray, n3);
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        this.initCipher();
        if (byArray.length >= n3 + n4) {
            int n6 = 0;
            for (int i3 = 0; i3 != n4; ++i3) {
                int n7 = n6;
                int n8 = n6;
                n6 = byArray[n3 + i3];
                int n9 = n5 + n8;
                n6 = n7 + this.process((byte)n6, byArray2, n9);
            }
            return n6;
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.initCipher();
        int n4 = eAXBlockCipher.bufOff;
        byte[] byArray2 = eAXBlockCipher.bufBlock;
        byte[] byArray3 = new byte[eAXBlockCipher.bufBlock.length];
        eAXBlockCipher.bufOff = 0;
        if (eAXBlockCipher.forEncryption) {
            int n5 = n3 + n4;
            if (byArray.length >= n5 + this.macSize) {
                EAXBlockCipher eAXBlockCipher2 = this;
                this.cipher.processBlock(byArray2, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n3, n4);
                eAXBlockCipher2.mac.update(byArray3, 0, n4);
                eAXBlockCipher2.calculateMac();
                int n6 = this.macSize;
                System.arraycopy(eAXBlockCipher2.macBlock, 0, byArray, n5, n6);
                eAXBlockCipher2.reset(false);
                return n4 + eAXBlockCipher2.macSize;
            }
            throw new OutputLengthException("Output buffer too short");
        }
        int n7 = this.macSize;
        if (n4 >= n7) {
            if (byArray.length >= n3 + n4 - n7) {
                if (n4 > n7) {
                    EAXBlockCipher eAXBlockCipher3 = this;
                    eAXBlockCipher3.mac.update(byArray2, 0, n4 - n7);
                    eAXBlockCipher3.cipher.processBlock(this.bufBlock, 0, byArray3, 0);
                    int n8 = n4 - eAXBlockCipher3.macSize;
                    System.arraycopy(byArray3, 0, byArray, n3, n8);
                }
                EAXBlockCipher eAXBlockCipher4 = this;
                eAXBlockCipher4.calculateMac();
                byArray = eAXBlockCipher4.bufBlock;
                if (this.verifyMac(byArray, n4 - eAXBlockCipher4.macSize)) {
                    EAXBlockCipher eAXBlockCipher5 = this;
                    eAXBlockCipher5.reset(false);
                    return n4 - eAXBlockCipher5.macSize;
                }
                throw new InvalidCipherTextException("mac check in EAX failed");
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new InvalidCipherTextException("data too short");
    }

    @Override
    public byte[] getMac() {
        int n3 = this.macSize;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.macBlock, 0, byArray, 0, n3);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        n3 += this.bufOff;
        if (!this.forEncryption) {
            int n4 = this.macSize;
            if (n3 < n4) {
                return 0;
            }
            n3 -= n4;
        }
        int n5 = n3;
        return n5 - n5 % this.blockSize;
    }

    @Override
    public int getOutputSize(int n3) {
        n3 += this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        int n4 = this.macSize;
        return n3 < n4 ? 0 : n3 - n4;
    }
}

