/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GOST3413CipherUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class G3413CTRBlockCipher
extends StreamBlockCipher {
    private final int s;
    private byte[] CTR;
    private byte[] IV;
    private byte[] buf;
    private final int blockSize;
    private final BlockCipher cipher;
    private int byteCount;
    private boolean initialized;

    public G3413CTRBlockCipher(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8);
    }

    public G3413CTRBlockCipher(BlockCipher blockCipher, int n3) {
        super(blockCipher);
        this.byteCount = 0;
        if (n3 >= 0 && n3 <= blockCipher.getBlockSize() * 8) {
            int n4;
            G3413CTRBlockCipher g3413CTRBlockCipher = this;
            this.cipher = blockCipher;
            this.blockSize = n4 = blockCipher.getBlockSize();
            g3413CTRBlockCipher.s = n3 / 8;
            g3413CTRBlockCipher.CTR = new byte[n4];
            return;
        }
        throw new IllegalArgumentException(b.a("Parameter bitBlockSize must be in range 0 < bitBlockSize <= ").append(blockCipher.getBlockSize() * 8).toString());
    }

    private void initArrays() {
        G3413CTRBlockCipher g3413CTRBlockCipher = this;
        int n3 = g3413CTRBlockCipher.blockSize;
        g3413CTRBlockCipher.IV = new byte[n3 / 2];
        g3413CTRBlockCipher.CTR = new byte[n3];
        g3413CTRBlockCipher.buf = new byte[g3413CTRBlockCipher.s];
    }

    private void generateCRT() {
        int n3 = this.CTR.length - 1;
        this.CTR[n3] = (byte)(this.CTR[n3] + 1);
    }

    private byte[] generateBuf() {
        byte[] byArray = this.CTR;
        byte[] byArray2 = new byte[this.CTR.length];
        G3413CTRBlockCipher g3413CTRBlockCipher = this;
        g3413CTRBlockCipher.cipher.processBlock(byArray, 0, byArray2, 0);
        return GOST3413CipherUtil.MSB(byArray2, g3413CTRBlockCipher.s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            this.initArrays();
            byte[] byArray = Arrays.clone(parametersWithIV.getIV());
            object = byArray;
            this.IV = byArray;
            if (((Object)object).length != this.blockSize / 2) throw new IllegalArgumentException("Parameter IV length must be == blockSize/2");
            Object object2 = object;
            object = this.CTR;
            int n3 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, 0, n3);
            for (int i3 = this.IV.length; i3 < this.blockSize; ++i3) {
                this.CTR[i3] = 0;
            }
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.initArrays();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
        this.initialized = true;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.s;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        G3413CTRBlockCipher g3413CTRBlockCipher = this;
        g3413CTRBlockCipher.processBytes(byArray, n3, this.s, byArray2, n4);
        return g3413CTRBlockCipher.s;
    }

    @Override
    public byte calculateByte(byte by) {
        if (this.byteCount == 0) {
            this.buf = this.generateBuf();
        }
        int n3 = this.byteCount;
        by = (byte)(this.buf[n3] ^ by);
        this.byteCount = ++n3;
        if (n3 == this.s) {
            this.byteCount = 0;
            this.generateCRT();
        }
        return by;
    }

    @Override
    public void reset() {
        if (this.initialized) {
            G3413CTRBlockCipher g3413CTRBlockCipher = this;
            byte[] byArray = this.CTR;
            int n3 = g3413CTRBlockCipher.IV.length;
            System.arraycopy(g3413CTRBlockCipher.IV, 0, byArray, 0, n3);
            for (int i3 = (v838017).IV.length; i3 < this.blockSize; ++i3) {
                this.CTR[i3] = 0;
            }
            this.byteCount = 0;
            this.cipher.reset();
        }
    }
}

