/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GOST3413CipherUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class G3413OFBBlockCipher
extends StreamBlockCipher {
    private int m;
    private int blockSize;
    private byte[] R;
    private byte[] R_init;
    private byte[] Y;
    private BlockCipher cipher;
    private int byteCount;
    private boolean initialized;

    public G3413OFBBlockCipher(BlockCipher blockCipher) {
        int n3;
        G3413OFBBlockCipher g3413OFBBlockCipher = this;
        super(blockCipher);
        this.initialized = false;
        this.blockSize = n3 = blockCipher.getBlockSize();
        g3413OFBBlockCipher.cipher = blockCipher;
        g3413OFBBlockCipher.Y = new byte[n3];
    }

    private void initArrays() {
        int n3 = this.m;
        this.R = new byte[n3];
        this.R_init = new byte[n3];
    }

    private void setupDefaultParams() {
        this.m = this.blockSize * 2;
    }

    private void generateY() {
        G3413OFBBlockCipher g3413OFBBlockCipher = this;
        byte[] byArray = GOST3413CipherUtil.MSB(g3413OFBBlockCipher.R, this.blockSize);
        g3413OFBBlockCipher.cipher.processBlock(byArray, 0, this.Y, 0);
    }

    private void generateR() {
        G3413OFBBlockCipher g3413OFBBlockCipher = object;
        byte[] byArray = GOST3413CipherUtil.LSB(g3413OFBBlockCipher.R, ((G3413OFBBlockCipher)object).m - ((G3413OFBBlockCipher)object).blockSize);
        byte[] byArray2 = ((G3413OFBBlockCipher)object).R;
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        G3413OFBBlockCipher g3413OFBBlockCipher2 = object;
        Object object = ((G3413OFBBlockCipher)object).R;
        int n4 = byArray.length;
        int n5 = g3413OFBBlockCipher2.m - byArray.length;
        System.arraycopy(g3413OFBBlockCipher.Y, 0, object, n4, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            if (byArray.length < this.blockSize) throw new IllegalArgumentException("Parameter m must blockSize <= m");
            this.m = ((Object)object).length;
            this.initArrays();
            byte[] byArray2 = Arrays.clone((byte[])object);
            object = byArray2;
            this.R_init = (byte[])object;
            object = this.R;
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, object, 0, n3);
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            G3413OFBBlockCipher g3413OFBBlockCipher = this;
            g3413OFBBlockCipher.setupDefaultParams();
            g3413OFBBlockCipher.initArrays();
            byte[] byArray = this.R;
            int n4 = g3413OFBBlockCipher.R_init.length;
            System.arraycopy(g3413OFBBlockCipher.R_init, 0, byArray, 0, n4);
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
        this.initialized = true;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OFB";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        G3413OFBBlockCipher g3413OFBBlockCipher = this;
        g3413OFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return g3413OFBBlockCipher.blockSize;
    }

    @Override
    public byte calculateByte(byte by) {
        if (this.byteCount == 0) {
            this.generateY();
        }
        int n3 = this.byteCount;
        by = (byte)(this.Y[n3] ^ by);
        this.byteCount = ++n3;
        if (n3 == this.getBlockSize()) {
            this.byteCount = 0;
            this.generateR();
        }
        return by;
    }

    @Override
    public void reset() {
        if (((G3413OFBBlockCipher)object).initialized) {
            G3413OFBBlockCipher g3413OFBBlockCipher = object;
            Object object = ((G3413OFBBlockCipher)object).R;
            int n3 = g3413OFBBlockCipher.R_init.length;
            System.arraycopy(g3413OFBBlockCipher.R_init, 0, object, 0, n3);
            Arrays.clear(g3413OFBBlockCipher.Y);
            g3413OFBBlockCipher.byteCount = 0;
            g3413OFBBlockCipher.cipher.reset();
        }
    }
}

