/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.BasicGCMExponentiator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private BlockCipher cipher;
    private GCMMultiplier multiplier;
    private GCMExponentiator exp;
    private boolean forEncryption;
    private boolean initialised;
    private int macSize;
    private byte[] lastKey;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private byte[] H;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] S_at;
    private byte[] S_atPre;
    private byte[] counter;
    private int blocksRemaining;
    private int bufOff;
    private long totalLength;
    private byte[] atBlock;
    private int atBlockPos;
    private long atLength;
    private long atLengthPre;

    public GCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, null);
    }

    public GCMBlockCipher(BlockCipher blockCipher, GCMMultiplier gCMMultiplier) {
        if (blockCipher.getBlockSize() == 16) {
            if (gCMMultiplier == null) {
                Tables4kGCMMultiplier tables4kGCMMultiplier;
                gCMMultiplier = tables4kGCMMultiplier;
                tables4kGCMMultiplier = new Tables4kGCMMultiplier();
            }
            GCMBlockCipher gCMBlockCipher = this;
            gCMBlockCipher.cipher = blockCipher;
            gCMBlockCipher.multiplier = gCMMultiplier;
            return;
        }
        throw new IllegalArgumentException("cipher required with a block size of 16.");
    }

    private void initCipher() {
        int n3;
        if (this.atLength > 0L) {
            GCMBlockCipher gCMBlockCipher = this;
            System.arraycopy(gCMBlockCipher.S_at, 0, this.S_atPre, 0, 16);
            gCMBlockCipher.atLengthPre = gCMBlockCipher.atLength;
        }
        if ((n3 = this.atBlockPos) > 0) {
            GCMBlockCipher gCMBlockCipher = this;
            byte[] byArray = gCMBlockCipher.S_atPre;
            gCMBlockCipher.gHASHPartial(byArray, gCMBlockCipher.atBlock, 0, n3);
            gCMBlockCipher.atLengthPre += (long)this.atBlockPos;
        }
        if (this.atLengthPre > 0L) {
            System.arraycopy(this.S_atPre, 0, this.S, 0, 16);
        }
    }

    private void reset(boolean bl) {
        GCMBlockCipher gCMBlockCipher = this;
        gCMBlockCipher.cipher.reset();
        gCMBlockCipher.S = new byte[16];
        gCMBlockCipher.S_at = new byte[16];
        gCMBlockCipher.S_atPre = new byte[16];
        gCMBlockCipher.atBlock = new byte[16];
        gCMBlockCipher.atBlockPos = 0;
        gCMBlockCipher.atLength = 0L;
        gCMBlockCipher.atLengthPre = 0L;
        gCMBlockCipher.counter = Arrays.clone(gCMBlockCipher.J0);
        gCMBlockCipher.blocksRemaining = -2;
        gCMBlockCipher.bufOff = 0;
        gCMBlockCipher.totalLength = 0L;
        byte[] byArray = gCMBlockCipher.bufBlock;
        if (gCMBlockCipher.bufBlock != null) {
            Arrays.fill(byArray, (byte)0);
        }
        if (bl) {
            this.macBlock = null;
        }
        if (this.forEncryption) {
            this.initialised = false;
        } else {
            byte[] byArray2 = this.initialAssociatedText;
            if (this.initialAssociatedText != null) {
                int n3 = byArray2.length;
                this.processAADBytes(byArray2, 0, n3);
            }
        }
    }

    private void processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (byArray2.length - n4 >= 16) {
            if (this.totalLength == 0L) {
                this.initCipher();
            }
            GCMBlockCipher gCMBlockCipher = this;
            byte[] byArray3 = new byte[16];
            gCMBlockCipher.getNextCTRBlock(byArray3);
            if (gCMBlockCipher.forEncryption) {
                GCMBlockCipher gCMBlockCipher2 = this;
                GCMUtil.xor(byArray3, byArray, n3);
                gCMBlockCipher2.gHASHBlock(gCMBlockCipher2.S, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n4, 16);
            } else {
                GCMBlockCipher gCMBlockCipher3 = this;
                gCMBlockCipher3.gHASHBlock(gCMBlockCipher3.S, byArray, n3);
                GCMUtil.xor(byArray3, 0, byArray, n3, byArray2, n4);
            }
            this.totalLength += 16L;
            return;
        }
        throw new OutputLengthException("Output buffer too short");
    }

    private void processPartial(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        GCMBlockCipher gCMBlockCipher = this;
        byte[] byArray3 = new byte[16];
        gCMBlockCipher.getNextCTRBlock(byArray3);
        if (gCMBlockCipher.forEncryption) {
            GCMBlockCipher gCMBlockCipher2 = this;
            GCMUtil.xor(byArray, n3, byArray3, 0, n4);
            gCMBlockCipher2.gHASHPartial(gCMBlockCipher2.S, byArray, n3, n4);
        } else {
            GCMBlockCipher gCMBlockCipher3 = this;
            gCMBlockCipher3.gHASHPartial(gCMBlockCipher3.S, byArray, n3, n4);
            GCMUtil.xor(byArray, n3, byArray3, 0, n4);
        }
        System.arraycopy(byArray, n3, byArray2, n5, n4);
        this.totalLength += (long)n4;
    }

    private void gHASH(byte[] byArray, byte[] byArray2, int n3) {
        for (int i3 = 0; i3 < n3; i3 += 16) {
            int n4 = Math.min(n3 - i3, 16);
            this.gHASHPartial(byArray, byArray2, i3, n4);
        }
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2) {
        GCMUtil.xor(byArray, byArray2);
        this.multiplier.multiplyH(byArray);
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2, int n3) {
        GCMUtil.xor(byArray, byArray2, n3);
        this.multiplier.multiplyH(byArray);
    }

    private void gHASHPartial(byte[] byArray, byte[] byArray2, int n3, int n4) {
        GCMUtil.xor(byArray, byArray2, n3, n4);
        this.multiplier.multiplyH(byArray);
    }

    private void getNextCTRBlock(byte[] byArray) {
        int n3 = ((GCMBlockCipher)object).blocksRemaining;
        if (n3 != 0) {
            GCMBlockCipher gCMBlockCipher = object;
            gCMBlockCipher.blocksRemaining = n3 - 1;
            Object object = gCMBlockCipher.counter;
            int n4 = (gCMBlockCipher.counter[15] & 0xFF) + 1;
            object[15] = (byte)n4;
            int n5 = (n4 >>> 8) + (object[14] & 0xFF);
            object[14] = (byte)n5;
            int n6 = (n5 >>> 8) + (object[13] & 0xFF);
            object[13] = (byte)n6;
            gCMBlockCipher.counter[12] = (byte)((n6 >>> 8) + (object[12] & 0xFF));
            gCMBlockCipher.cipher.processBlock((byte[])object, 0, byArray, 0);
            return;
        }
        throw new IllegalStateException("Attempt to process too many blocks");
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block16: {
            block17: {
                block20: {
                    block19: {
                        block18: {
                            byte[] byArray;
                            block15: {
                                block13: {
                                    int n3;
                                    block14: {
                                        GCMBlockCipher gCMBlockCipher = this;
                                        gCMBlockCipher.forEncryption = bl;
                                        gCMBlockCipher.macBlock = null;
                                        gCMBlockCipher.initialised = true;
                                        if (!(object instanceof AEADParameters)) break block13;
                                        object = (AEADParameters)object;
                                        CipherParameters cipherParameters = object;
                                        byArray = ((AEADParameters)cipherParameters).getNonce();
                                        this.initialAssociatedText = ((AEADParameters)cipherParameters).getAssociatedText();
                                        n3 = ((AEADParameters)object).getMacSize();
                                        if (n3 < 32 || n3 > 128 || n3 % 8 != 0) break block14;
                                        this.macSize = n3 / 8;
                                        object = ((AEADParameters)object).getKey();
                                        break block15;
                                    }
                                    throw new IllegalArgumentException(a.a("Invalid value for MAC size: ", n3));
                                }
                                if (!(object instanceof ParametersWithIV)) break block16;
                                GCMBlockCipher gCMBlockCipher = this;
                                object = (ParametersWithIV)object;
                                byArray = ((ParametersWithIV)object).getIV();
                                gCMBlockCipher.initialAssociatedText = null;
                                gCMBlockCipher.macSize = 16;
                                object = (KeyParameter)((ParametersWithIV)object).getParameters();
                            }
                            byte[] byArray2 = new byte[bl ? 16 : this.macSize + 16];
                            this.bufBlock = byArray2;
                            if (byArray == null || byArray.length < 1) break block17;
                            if (bl) {
                                byte[] byArray3 = this.nonce;
                                if (this.nonce != null && Arrays.areEqual(byArray3, byArray)) {
                                    if (object != null) {
                                        byArray3 = this.lastKey;
                                        if (this.lastKey != null && Arrays.areEqual(byArray3, ((KeyParameter)object).getKey())) {
                                            throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                                        }
                                    } else {
                                        throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                                    }
                                }
                            }
                            this.nonce = byArray;
                            if (object != null) {
                                this.lastKey = ((KeyParameter)object).getKey();
                            }
                            if (object == null) break block18;
                            GCMBlockCipher gCMBlockCipher = this;
                            gCMBlockCipher.cipher.init(true, (CipherParameters)object);
                            byte[] byArray4 = new byte[16];
                            gCMBlockCipher.H = byArray4;
                            gCMBlockCipher.cipher.processBlock(byArray4, 0, byArray4, 0);
                            gCMBlockCipher.multiplier.init(this.H);
                            gCMBlockCipher.exp = null;
                            break block19;
                        }
                        if (this.H == null) break block20;
                    }
                    GCMBlockCipher gCMBlockCipher = this;
                    byte[] byArray = new byte[16];
                    gCMBlockCipher.J0 = byArray;
                    object = gCMBlockCipher.nonce;
                    if (gCMBlockCipher.nonce.length == 12) {
                        Object object2 = object;
                        int n4 = ((Object)object2).length;
                        System.arraycopy(object2, 0, byArray, 0, n4);
                        this.J0[15] = 1;
                    } else {
                        GCMBlockCipher gCMBlockCipher2 = this;
                        gCMBlockCipher2.gHASH(byArray, (byte[])object, ((Object)object).length);
                        byArray = new byte[16];
                        Pack.longToBigEndian((long)gCMBlockCipher2.nonce.length * 8L, byArray, 8);
                        gCMBlockCipher2.gHASHBlock(gCMBlockCipher2.J0, byArray);
                    }
                    GCMBlockCipher gCMBlockCipher3 = this;
                    gCMBlockCipher3.S = new byte[16];
                    gCMBlockCipher3.S_at = new byte[16];
                    gCMBlockCipher3.S_atPre = new byte[16];
                    gCMBlockCipher3.atBlock = new byte[16];
                    gCMBlockCipher3.atBlockPos = 0;
                    gCMBlockCipher3.atLength = 0L;
                    gCMBlockCipher3.atLengthPre = 0L;
                    gCMBlockCipher3.counter = Arrays.clone(gCMBlockCipher3.J0);
                    gCMBlockCipher3.blocksRemaining = -2;
                    gCMBlockCipher3.bufOff = 0;
                    gCMBlockCipher3.totalLength = 0L;
                    byArray = gCMBlockCipher3.initialAssociatedText;
                    if (gCMBlockCipher3.initialAssociatedText != null) {
                        int n5 = byArray.length;
                        this.processAADBytes(byArray, 0, n5);
                    }
                    return;
                }
                throw new IllegalArgumentException("Key must be specified in initial init");
            }
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        throw new IllegalArgumentException("invalid parameters passed to GCM");
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = this.macBlock;
        if (this.macBlock == null) {
            return new byte[this.macSize];
        }
        return Arrays.clone(byArray);
    }

    @Override
    public int getOutputSize(int n3) {
        n3 += this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        int n4 = this.macSize;
        return n3 < n4 ? 0 : n3 - n4;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        n3 += this.bufOff;
        if (!this.forEncryption) {
            int n4 = this.macSize;
            if (n3 < n4) {
                return 0;
            }
            n3 -= n4;
        }
        int n5 = n3;
        return n5 - n5 % 16;
    }

    @Override
    public void processAADByte(byte by) {
        GCMBlockCipher gCMBlockCipher = this;
        gCMBlockCipher.checkStatus();
        byte[] byArray = gCMBlockCipher.atBlock;
        int n3 = this.atBlockPos;
        gCMBlockCipher.atBlock[n3] = by;
        this.atBlockPos = n3 + 1;
        if (this.atBlockPos == 16) {
            GCMBlockCipher gCMBlockCipher2 = this;
            gCMBlockCipher2.gHASHBlock(gCMBlockCipher2.S_at, byArray);
            gCMBlockCipher2.atBlockPos = 0;
            gCMBlockCipher2.atLength += 16L;
        }
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        this.checkStatus();
        for (int i3 = 0; i3 < n4; ++i3) {
            byte[] byArray2 = this.atBlock;
            int n5 = this.atBlockPos;
            this.atBlock[n5] = byArray[n3 + i3];
            this.atBlockPos = n5 + 1;
            if (this.atBlockPos != 16) continue;
            GCMBlockCipher gCMBlockCipher = this;
            gCMBlockCipher.gHASHBlock(gCMBlockCipher.S_at, byArray2);
            gCMBlockCipher.atBlockPos = 0;
            gCMBlockCipher.atLength += 16L;
        }
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        GCMBlockCipher gCMBlockCipher = this;
        gCMBlockCipher.checkStatus();
        byte[] byArray2 = gCMBlockCipher.bufBlock;
        int n4 = this.bufOff;
        gCMBlockCipher.bufBlock[n4] = by;
        int n5 = n4 + 1;
        by = (byte)n5;
        this.bufOff = by;
        if (n5 == byArray2.length) {
            GCMBlockCipher gCMBlockCipher2 = this;
            gCMBlockCipher2.processBlock(byArray2, 0, byArray, n3);
            if (gCMBlockCipher2.forEncryption) {
                this.bufOff = 0;
            } else {
                GCMBlockCipher gCMBlockCipher3 = this;
                int n6 = this.macSize;
                System.arraycopy(gCMBlockCipher3.bufBlock, 16, gCMBlockCipher3.bufBlock, 0, n6);
                gCMBlockCipher3.bufOff = gCMBlockCipher3.macSize;
            }
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        this.checkStatus();
        if (byArray.length - n3 >= n4) {
            int n6 = 0;
            if (this.forEncryption) {
                if (this.bufOff != 0) {
                    while (n4 > 0) {
                        --n4;
                        byte[] byArray3 = this.bufBlock;
                        int n7 = this.bufOff;
                        int n8 = n3 + 1;
                        this.bufBlock[n7] = byArray[n3];
                        this.bufOff = n7 + 1;
                        if (this.bufOff == 16) {
                            this.processBlock(byArray3, 0, byArray2, n5);
                            this.bufOff = 0;
                            n6 = 16;
                            n3 = n8;
                            break;
                        }
                        n3 = n8;
                    }
                }
                while (n4 >= 16) {
                    int n9 = n5 + n6;
                    this.processBlock(byArray, n3, byArray2, n9);
                    n3 += 16;
                    n4 -= 16;
                    n6 += 16;
                }
                if (n4 > 0) {
                    System.arraycopy(byArray, n3, this.bufBlock, 0, n4);
                    this.bufOff = n4;
                }
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    byte[] byArray4 = this.bufBlock;
                    int n10 = this.bufOff;
                    this.bufBlock[n10] = byArray[n3 + i3];
                    this.bufOff = ++n10;
                    if (n10 != byArray4.length) continue;
                    GCMBlockCipher gCMBlockCipher = this;
                    int n11 = n5 + n6;
                    gCMBlockCipher.processBlock(byArray4, 0, byArray2, n11);
                    n11 = this.macSize;
                    System.arraycopy(gCMBlockCipher.bufBlock, 16, gCMBlockCipher.bufBlock, 0, n11);
                    gCMBlockCipher.bufOff = gCMBlockCipher.macSize;
                    n6 += 16;
                }
            }
            return n6;
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block13: {
            block14: {
                block17: {
                    int n4;
                    block16: {
                        block15: {
                            long l3;
                            int n5;
                            block12: {
                                block11: {
                                    GCMBlockCipher gCMBlockCipher = this;
                                    gCMBlockCipher.checkStatus();
                                    if (gCMBlockCipher.totalLength == 0L) {
                                        this.initCipher();
                                    }
                                    GCMBlockCipher gCMBlockCipher2 = this;
                                    n4 = gCMBlockCipher2.bufOff;
                                    if (!gCMBlockCipher2.forEncryption) break block11;
                                    if (byArray.length - n3 < n4 + this.macSize) {
                                        throw new OutputLengthException("Output buffer too short");
                                    }
                                    break block12;
                                }
                                n5 = this.macSize;
                                if (n4 < n5) break block13;
                                if (byArray.length - n3 < (n4 -= n5)) break block14;
                            }
                            if (n4 > 0) {
                                GCMBlockCipher gCMBlockCipher = this;
                                gCMBlockCipher.processPartial(gCMBlockCipher.bufBlock, 0, n4, byArray, n3);
                            }
                            n5 = this.atBlockPos;
                            this.atLength = l3 = this.atLength + (long)n5;
                            if (l3 > this.atLengthPre) {
                                if (n5 > 0) {
                                    GCMBlockCipher gCMBlockCipher = this;
                                    byte[] byArray2 = gCMBlockCipher.S_at;
                                    gCMBlockCipher.gHASHPartial(byArray2, gCMBlockCipher.atBlock, 0, n5);
                                }
                                if (this.atLengthPre > 0L) {
                                    GCMUtil.xor(this.S_at, this.S_atPre);
                                }
                                GCMBlockCipher gCMBlockCipher = this;
                                long l4 = gCMBlockCipher.totalLength * 8L + 127L >>> 7;
                                byte[] byArray3 = new byte[16];
                                if (gCMBlockCipher.exp == null) {
                                    BasicGCMExponentiator basicGCMExponentiator;
                                    BasicGCMExponentiator basicGCMExponentiator2;
                                    BasicGCMExponentiator basicGCMExponentiator3 = basicGCMExponentiator2 = basicGCMExponentiator;
                                    basicGCMExponentiator3();
                                    this.exp = basicGCMExponentiator3;
                                    basicGCMExponentiator.init(this.H);
                                }
                                GCMBlockCipher gCMBlockCipher3 = this;
                                gCMBlockCipher3.exp.exponentiateX(l4, byArray3);
                                GCMUtil.multiply(gCMBlockCipher3.S_at, byArray3);
                                GCMUtil.xor(gCMBlockCipher3.S, this.S_at);
                            }
                            GCMBlockCipher gCMBlockCipher = this;
                            byte[] byArray4 = new byte[16];
                            Pack.longToBigEndian(gCMBlockCipher.atLength * 8L, byArray4, 0);
                            Pack.longToBigEndian(gCMBlockCipher.totalLength * 8L, byArray4, 8);
                            gCMBlockCipher.gHASHBlock(gCMBlockCipher.S, byArray4);
                            byArray4 = new byte[16];
                            GCMBlockCipher gCMBlockCipher4 = this;
                            gCMBlockCipher4.cipher.processBlock(this.J0, 0, byArray4, 0);
                            GCMUtil.xor(byArray4, gCMBlockCipher4.S);
                            int n6 = this.macSize;
                            byte[] byArray5 = new byte[n6];
                            this.macBlock = byArray5;
                            System.arraycopy(byArray4, 0, byArray5, 0, n6);
                            if (!gCMBlockCipher.forEncryption) break block15;
                            int n7 = n4;
                            GCMBlockCipher gCMBlockCipher5 = this;
                            n4 = this.macSize;
                            System.arraycopy(gCMBlockCipher5.macBlock, 0, byArray, n3 += this.bufOff, n4);
                            n4 = n7 + gCMBlockCipher5.macSize;
                            break block16;
                        }
                        GCMBlockCipher gCMBlockCipher = this;
                        int n8 = gCMBlockCipher.macSize;
                        byte[] byArray6 = new byte[n8];
                        System.arraycopy(gCMBlockCipher.bufBlock, n4, byArray6, 0, n8);
                        if (!Arrays.constantTimeAreEqual(gCMBlockCipher.macBlock, byArray6)) break block17;
                    }
                    this.reset(false);
                    return n4;
                }
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new InvalidCipherTextException("data too short");
    }

    @Override
    public void reset() {
        this.reset(true);
    }
}

