/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class GCMSIVBlockCipher
implements AEADBlockCipher {
    private static final int BUFLEN = 16;
    private static final int HALFBUFLEN = 8;
    private static final int NONCELEN = 12;
    private static final int MAX_DATALEN = 0x7FFFFFE7;
    private static final byte MASK = -128;
    private static final byte ADD = -31;
    private static final int INIT = 1;
    private static final int AEAD_COMPLETE = 2;
    private final BlockCipher theCipher;
    private final GCMMultiplier theMultiplier;
    private final byte[] theGHash;
    private final byte[] theReverse;
    private final GCMSIVHasher theAEADHasher;
    private final GCMSIVHasher theDataHasher;
    private GCMSIVCache thePlain;
    private GCMSIVCache theEncData;
    private boolean forEncryption;
    private byte[] theInitialAEAD;
    private byte[] theNonce;
    private int theFlags;
    private byte[] macBlock;

    public GCMSIVBlockCipher() {
        AESEngine aESEngine;
        GCMSIVBlockCipher gCMSIVBlockCipher = aESEngine2;
        AESEngine aESEngine2 = aESEngine;
        aESEngine = new AESEngine();
        gCMSIVBlockCipher(aESEngine2);
    }

    public GCMSIVBlockCipher(BlockCipher blockCipher) {
        Tables4kGCMMultiplier tables4kGCMMultiplier;
        GCMSIVBlockCipher gCMSIVBlockCipher = tables4kGCMMultiplier2;
        Tables4kGCMMultiplier tables4kGCMMultiplier2 = tables4kGCMMultiplier;
        tables4kGCMMultiplier = new Tables4kGCMMultiplier();
        gCMSIVBlockCipher(blockCipher, tables4kGCMMultiplier2);
    }

    public GCMSIVBlockCipher(BlockCipher object, GCMMultiplier gCMMultiplier) {
        this.theGHash = new byte[16];
        this.theReverse = new byte[16];
        this.macBlock = new byte[16];
        if (object.getBlockSize() == 16) {
            GCMSIVHasher gCMSIVHasher;
            GCMSIVHasher gCMSIVHasher2;
            GCMSIVBlockCipher gCMSIVBlockCipher = this;
            gCMSIVBlockCipher.theCipher = object;
            gCMSIVBlockCipher.theMultiplier = gCMMultiplier;
            object = gCMSIVHasher2;
            gCMSIVHasher2 = new GCMSIVHasher(null);
            gCMSIVBlockCipher.theAEADHasher = object;
            object = gCMSIVHasher;
            gCMSIVHasher = new GCMSIVHasher(null);
            gCMSIVBlockCipher.theDataHasher = object;
            return;
        }
        throw new IllegalArgumentException("Cipher required with a block size of 16.");
    }

    private void checkAEADStatus(int n3) {
        int n4 = this.theFlags;
        if ((n4 & 1) != 0) {
            if ((n4 & 2) == 0) {
                if (this.theAEADHasher.getBytesProcessed() + Long.MIN_VALUE <= (long)(0x7FFFFFE7 - n3) + Long.MIN_VALUE) {
                    return;
                }
                throw new IllegalStateException("AEAD byte count exceeded");
            }
            throw new IllegalStateException("AEAD data cannot be processed after ordinary data");
        }
        throw new IllegalStateException("Cipher is not initialised");
    }

    private void checkStatus(int n3) {
        int n4 = this.theFlags;
        if ((n4 & 1) != 0) {
            if ((n4 & 2) == 0) {
                GCMSIVBlockCipher gCMSIVBlockCipher = this;
                gCMSIVBlockCipher.theAEADHasher.completeHash();
                gCMSIVBlockCipher.theFlags |= 2;
            }
            GCMSIVBlockCipher gCMSIVBlockCipher = this;
            long l3 = 0x7FFFFFE7L;
            long l4 = gCMSIVBlockCipher.thePlain.size();
            if (!gCMSIVBlockCipher.forEncryption) {
                l3 = 0x7FFFFFF7L;
                l4 = this.theEncData.size();
            }
            if (l4 + Long.MIN_VALUE <= l3 - (long)n3 + Long.MIN_VALUE) {
                return;
            }
            throw new IllegalStateException("byte count exceeded");
        }
        throw new IllegalStateException("Cipher is not initialised");
    }

    private void resetStreams() {
        Object object = this.thePlain;
        if (object != null) {
            ((GCMSIVCache)object).clearBuffer();
        }
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.theAEADHasher.reset();
        gCMSIVBlockCipher.theDataHasher.reset();
        gCMSIVBlockCipher.thePlain = new GCMSIVCache();
        if (gCMSIVBlockCipher.forEncryption) {
            object = null;
        } else {
            GCMSIVCache gCMSIVCache;
            object = gCMSIVCache;
            gCMSIVCache = new GCMSIVCache();
        }
        GCMSIVBlockCipher gCMSIVBlockCipher2 = this;
        gCMSIVBlockCipher2.theEncData = object;
        gCMSIVBlockCipher2.theFlags &= 0xFFFFFFFD;
        Arrays.fill(gCMSIVBlockCipher2.theGHash, (byte)0);
        object = gCMSIVBlockCipher2.theInitialAEAD;
        if (gCMSIVBlockCipher2.theInitialAEAD != null) {
            Object object2 = object;
            this.theAEADHasher.updateHash((byte[])object2, 0, ((Object)object2).length);
        }
    }

    private static int bufLength(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    private static void checkBuffer(byte[] byArray, int n3, int n4, boolean bl) {
        DataLengthException dataLengthException;
        int n5 = n4;
        int n6 = GCMSIVBlockCipher.bufLength(byArray);
        n4 = n3 + n4;
        if (!(n5 < 0 || n3 < 0 || n4 < 0) && n4 <= n6) {
            return;
        }
        if (bl) {
            OutputLengthException outputLengthException;
            dataLengthException = outputLengthException;
            outputLengthException = new OutputLengthException("Output buffer too short.");
        } else {
            DataLengthException dataLengthException2;
            dataLengthException = dataLengthException2;
            dataLengthException2 = new DataLengthException("Input buffer too short.");
        }
        throw dataLengthException;
    }

    private int encryptPlain(byte[] byArray, byte[] byArray2, int n3) {
        byte[] byArray3 = byArray;
        byArray = this.thePlain.getBuffer();
        byte[] byArray4 = Arrays.clone(byArray3);
        byte[] byArray5 = byArray4;
        byArray4[15] = (byte)(byArray4[15] | 0xFFFFFF80);
        byte[] byArray6 = new byte[16];
        int n4 = this.thePlain.size();
        int n5 = 0;
        while (n4 > 0) {
            int n6 = n5;
            int n7 = n4;
            this.theCipher.processBlock(byArray5, 0, byArray6, 0);
            n4 = Math.min(16, n4);
            GCMSIVBlockCipher.xorBlock(byArray6, byArray, n5, n4);
            n5 = n3 + n5;
            System.arraycopy(byArray6, 0, byArray2, n5, n4);
            n5 = n7 - n4;
            n4 = n6 + n4;
            GCMSIVBlockCipher.incrementCounter(byArray5);
            int n8 = n5;
            n5 = n4;
            n4 = n8;
        }
        return this.thePlain.size();
    }

    private void decryptPlain() {
        GCMSIVBlockCipher gCMSIVBlockCipher = object;
        byte[] byArray = gCMSIVBlockCipher.theEncData.getBuffer();
        int n3 = gCMSIVBlockCipher.theEncData.size() - 16;
        if (n3 >= 0) {
            int n4 = n3;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n4, n4 + 16);
            byte[] byArray3 = Arrays.clone(byArray2);
            byte[] byArray4 = byArray3;
            byArray3[15] = (byte)(byArray3[15] | 0xFFFFFF80);
            byte[] byArray5 = new byte[16];
            int n5 = 0;
            while (n3 > 0) {
                int n6 = n5;
                int n7 = n3;
                ((GCMSIVBlockCipher)object).theCipher.processBlock(byArray4, 0, byArray5, 0);
                n3 = Math.min(16, n3);
                GCMSIVBlockCipher.xorBlock(byArray5, byArray, n5, n3);
                Object object = object;
                ((OutputStream)((GCMSIVBlockCipher)object).thePlain).write(byArray5, 0, n3);
                ((GCMSIVBlockCipher)object).theDataHasher.updateHash(byArray5, 0, n3);
                n5 = n7 - n3;
                n3 = n6 + n3;
                GCMSIVBlockCipher.incrementCounter(byArray4);
                int n8 = n5;
                n5 = n3;
                n3 = n8;
            }
            byArray = ((GCMSIVBlockCipher)object).calculateTag();
            if (Arrays.constantTimeAreEqual(byArray, byArray2)) {
                Object object = ((GCMSIVBlockCipher)object).macBlock;
                int n9 = ((GCMSIVBlockCipher)object).macBlock.length;
                System.arraycopy(byArray, 0, object, 0, n9);
                return;
            }
            ((GCMSIVBlockCipher)object).reset();
            throw new InvalidCipherTextException("mac check failed");
        }
        throw new InvalidCipherTextException("Data too short");
    }

    private byte[] calculateTag() {
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.theDataHasher.completeHash();
        byte[] byArray = gCMSIVBlockCipher.completePolyVal();
        byte[] byArray2 = new byte[16];
        for (int i3 = 0; i3 < 12; ++i3) {
            byArray[i3] = (byte)(byArray[i3] ^ this.theNonce[i3]);
        }
        byArray[15] = (byte)(byArray[15] & 0xFFFFFF7F);
        this.theCipher.processBlock(byArray, 0, byArray2, 0);
        return byArray2;
    }

    private byte[] completePolyVal() {
        byte[] byArray = new byte[16];
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.gHashLengths();
        GCMSIVBlockCipher.fillReverse(gCMSIVBlockCipher.theGHash, 0, 16, byArray);
        return byArray;
    }

    private void gHashLengths() {
    }

    private void gHASH(byte[] byArray) {
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        GCMSIVBlockCipher.xorBlock(gCMSIVBlockCipher.theGHash, byArray);
        gCMSIVBlockCipher.theMultiplier.multiplyH(this.theGHash);
    }

    private static void fillReverse(byte[] byArray, int n3, int n4, byte[] byArray2) {
        int n5 = 0;
        int n6 = 15;
        while (n5 < n4) {
            byArray2[n6] = byArray[n3 + n5];
            ++n5;
            --n6;
        }
    }

    private static void xorBlock(byte[] byArray, byte[] byArray2) {
        for (int i3 = 0; i3 < 16; ++i3) {
            byArray[i3] = (byte)(byArray[i3] ^ byArray2[i3]);
        }
    }

    private static void xorBlock(byte[] byArray, byte[] byArray2, int n3, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            byArray[i3] = (byte)(byArray[i3] ^ byArray2[i3 + n3]);
        }
    }

    private static void incrementCounter(byte[] byArray) {
    }

    private static void mulX(byte[] byArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 16; ++i3) {
            byte by = byArray[i3];
            byArray[i3] = (byte)(by >> 1 & 0x7F | n3);
            n3 = (by & 1) == 0 ? 0 : -128;
        }
        if (n3 != 0) {
            byArray[0] = (byte)(byArray[0] ^ 0xFFFFFFE1);
        }
    }

    private void deriveKeys(KeyParameter keyParameter) {
        KeyParameter keyParameter2;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        int n3 = keyParameter.getKey().length;
        GCMSIVBlockCipher gCMSIVBlockCipher = keyParameter3;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(gCMSIVBlockCipher.theNonce, 0, byArray, 4, 12);
        gCMSIVBlockCipher.theCipher.init(true, keyParameter);
        gCMSIVBlockCipher.theCipher.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray3, 8, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray4, 0, 8);
        byArray[0] = (byte)(byArray[0] + 1);
        ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.processBlock(byArray, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray4, 8, 8);
        if (n3 == 32) {
            byArray[0] = (byte)(byArray[0] + 1);
            ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.processBlock(byArray, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray4, 16, 8);
            byArray[0] = (byte)(byArray[0] + 1);
            ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.processBlock(byArray, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray4, 24, 8);
        }
        GCMSIVBlockCipher gCMSIVBlockCipher2 = keyParameter3;
        KeyParameter keyParameter3 = keyParameter2;
        keyParameter2 = new KeyParameter(byArray4);
        ((GCMSIVBlockCipher)((Object)keyParameter3)).theCipher.init(true, keyParameter3);
        GCMSIVBlockCipher.fillReverse(byArray3, 0, 16, byArray2);
        GCMSIVBlockCipher.mulX(byArray2);
        gCMSIVBlockCipher2.theMultiplier.init(byArray2);
        gCMSIVBlockCipher2.theFlags |= 1;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.theCipher;
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block7: {
            KeyParameter keyParameter;
            byte[] byArray;
            block6: {
                block5: {
                    byArray = null;
                    if (!(object instanceof AEADParameters)) break block5;
                    AEADParameters aEADParameters = (AEADParameters)object;
                    byArray = aEADParameters.getAssociatedText();
                    object = aEADParameters.getNonce();
                    keyParameter = aEADParameters.getKey();
                    break block6;
                }
                if (!(object instanceof ParametersWithIV)) break block7;
                ParametersWithIV parametersWithIV = (ParametersWithIV)object;
                object = parametersWithIV.getIV();
                keyParameter = (KeyParameter)parametersWithIV.getParameters();
            }
            if (object != null && ((Object)object).length == 12) {
                if (keyParameter != null && (keyParameter.getKey().length == 16 || keyParameter.getKey().length == 32)) {
                    GCMSIVBlockCipher gCMSIVBlockCipher = this;
                    gCMSIVBlockCipher.forEncryption = bl;
                    gCMSIVBlockCipher.theInitialAEAD = byArray;
                    gCMSIVBlockCipher.theNonce = (byte[])object;
                    gCMSIVBlockCipher.deriveKeys(keyParameter);
                    gCMSIVBlockCipher.resetStreams();
                    return;
                }
                throw new IllegalArgumentException("Invalid key");
            }
            throw new IllegalArgumentException("Invalid nonce");
        }
        throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
    }

    @Override
    public String getAlgorithmName() {
        return this.theCipher.getAlgorithmName() + "-GCM-SIV";
    }

    @Override
    public void processAADByte(byte by) {
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.checkAEADStatus(1);
        gCMSIVBlockCipher.theAEADHasher.updateHash(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        this.checkAEADStatus(n4);
        GCMSIVBlockCipher.checkBuffer(byArray, n3, n4, false);
        this.theAEADHasher.updateHash(byArray, n3, n4);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.checkStatus(1);
        if (gCMSIVBlockCipher.forEncryption) {
            GCMSIVBlockCipher gCMSIVBlockCipher2 = this;
            ((OutputStream)gCMSIVBlockCipher2.thePlain).write(by);
            gCMSIVBlockCipher2.theDataHasher.updateHash(by);
        } else {
            ((OutputStream)this.theEncData).write(by);
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        this.checkStatus(n4);
        GCMSIVBlockCipher.checkBuffer(byArray, n3, n4, false);
        if (this.forEncryption) {
            GCMSIVBlockCipher gCMSIVBlockCipher = this;
            ((OutputStream)gCMSIVBlockCipher.thePlain).write(byArray, n3, n4);
            gCMSIVBlockCipher.theDataHasher.updateHash(byArray, n3, n4);
        } else {
            ((OutputStream)this.theEncData).write(byArray, n3, n4);
        }
        return 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        GCMSIVBlockCipher gCMSIVBlockCipher = this;
        gCMSIVBlockCipher.checkStatus(0);
        GCMSIVBlockCipher.checkBuffer(byArray, n3, gCMSIVBlockCipher.getOutputSize(0), true);
        if (this.forEncryption) {
            GCMSIVBlockCipher gCMSIVBlockCipher2 = this;
            byte[] byArray2 = gCMSIVBlockCipher2.calculateTag();
            int n4 = gCMSIVBlockCipher2.encryptPlain(byArray2, byArray, n3) + 16;
            int n5 = this.thePlain.size() + n3;
            System.arraycopy(byArray2, 0, byArray, n5, 16);
            byte[] byArray3 = this.macBlock;
            int n6 = this.macBlock.length;
            System.arraycopy(byArray2, 0, byArray3, 0, n6);
            this.resetStreams();
            return n4;
        }
        GCMSIVBlockCipher gCMSIVBlockCipher3 = this;
        gCMSIVBlockCipher3.decryptPlain();
        int n7 = gCMSIVBlockCipher3.thePlain.size();
        GCMSIVBlockCipher gCMSIVBlockCipher4 = this;
        System.arraycopy(gCMSIVBlockCipher4.thePlain.getBuffer(), 0, byArray, n3, n7);
        gCMSIVBlockCipher4.resetStreams();
        return n7;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.macBlock);
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        return 0;
    }

    @Override
    public int getOutputSize(int n3) {
        if (this.forEncryption) {
            return this.thePlain.size() + n3 + 16;
        }
        int n4 = this.theEncData.size() + n3;
        return n4 > 16 ? n4 - 16 : 0;
    }

    @Override
    public void reset() {
        this.resetStreams();
    }

    public class GCMSIVHasher {
        private final byte[] theBuffer = new byte[16];
        private final byte[] theByte = new byte[1];
        private int numActive;
        private long numHashed;

        private GCMSIVHasher() {
        }

        public /* synthetic */ GCMSIVHasher(1 var2_2) {
            this();
        }

        public long getBytesProcessed() {
            return this.numHashed;
        }

        public void reset() {
            GCMSIVHasher gCMSIVHasher = this;
            gCMSIVHasher.numActive = 0;
            gCMSIVHasher.numHashed = 0L;
        }

        public void updateHash(byte by) {
            GCMSIVHasher gCMSIVHasher = object;
            Object object = gCMSIVHasher.theByte;
            gCMSIVHasher.theByte[0] = by;
            gCMSIVHasher.updateHash((byte[])object, 0, 1);
        }

        public void updateHash(byte[] byArray, int n3, int n4) {
            int n5 = this.numActive;
            int n6 = 16 - n5;
            int n7 = 0;
            if (n5 > 0 && n4 >= n6) {
                int n8 = n6;
                GCMSIVHasher gCMSIVHasher = this;
                System.arraycopy(byArray, n3, this.theBuffer, n5, n6);
                byte[] byArray2 = GCMSIVBlockCipher.this.theReverse;
                GCMSIVBlockCipher.fillReverse(gCMSIVHasher.theBuffer, 0, 16, byArray2);
                GCMSIVBlockCipher gCMSIVBlockCipher = gCMSIVHasher.GCMSIVBlockCipher.this;
                gCMSIVBlockCipher.gHASH(gCMSIVBlockCipher.theReverse);
                n7 = n8 + n7;
                n5 = n4 - n8;
                this.numActive = 0;
            } else {
                n5 = n4;
            }
            while (n5 >= 16) {
                GCMSIVBlockCipher.fillReverse(byArray, n3 + n7, 16, GCMSIVBlockCipher.this.theReverse);
                GCMSIVBlockCipher gCMSIVBlockCipher = GCMSIVBlockCipher.this;
                gCMSIVBlockCipher.gHASH(gCMSIVBlockCipher.theReverse);
                n7 += n6;
                n5 -= n6;
            }
            if (n5 > 0) {
                GCMSIVHasher gCMSIVHasher = this;
                int n9 = n3 + n7;
                byte[] byArray3 = gCMSIVHasher.theBuffer;
                n6 = gCMSIVHasher.numActive;
                System.arraycopy(byArray, n9, byArray3, n6, n5);
                this.numActive += n5;
            }
            this.numHashed += (long)n4;
        }

        public void completeHash() {
            if (this.numActive > 0) {
                GCMSIVHasher gCMSIVHasher = this;
                Arrays.fill(gCMSIVHasher.GCMSIVBlockCipher.this.theReverse, (byte)0);
                GCMSIVHasher gCMSIVHasher2 = this;
                int n3 = gCMSIVHasher2.numActive;
                byte[] byArray = gCMSIVHasher2.GCMSIVBlockCipher.this.theReverse;
                GCMSIVBlockCipher.fillReverse(gCMSIVHasher.theBuffer, 0, n3, byArray);
                GCMSIVBlockCipher gCMSIVBlockCipher = gCMSIVHasher.GCMSIVBlockCipher.this;
                gCMSIVBlockCipher.gHASH(gCMSIVBlockCipher.theReverse);
            }
        }
    }

    public static class GCMSIVCache
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }

        public void clearBuffer() {
            Arrays.fill(this.getBuffer(), (byte)0);
        }
    }
}

