/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    public static final int C1 = 0x1010104;
    public static final int C2 = 0x1010101;
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private final int blockSize;
    private final BlockCipher cipher;
    public boolean firstStep = true;
    public int N3;
    public int N4;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        if (this.blockSize == 8) {
            this.IV = new byte[blockCipher.getBlockSize()];
            this.ofbV = new byte[blockCipher.getBlockSize()];
            this.ofbOutV = new byte[blockCipher.getBlockSize()];
            return;
        }
        throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
    }

    private int bytesToint(byte[] byArray, int n3) {
        return (byArray[n3 + 3] << 24 & 0xFF000000) + (byArray[n3 + 2] << 16 & 0xFF0000) + (byArray[n3 + 1] << 8 & 0xFF00) + (byArray[n3] & 0xFF);
    }

    private void intTobytes(int n3, byte[] byArray, int n4) {
        int n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >>> 24);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >>> 16);
        n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >>> 8);
        byArray[n4] = (byte)n3;
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        GOFBBlockCipher gOFBBlockCipher = this;
        gOFBBlockCipher.firstStep = true;
        gOFBBlockCipher.N3 = 0;
        gOFBBlockCipher.N4 = 0;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n3 = byArray2.length - ((Object)object).length;
                int n4 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n3, n4);
                int n5 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n5 < this.IV.length - ((Object)object).length) {
                        byArray3[n5] = 0;
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else {
                int n6 = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n6);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        GOFBBlockCipher gOFBBlockCipher = this;
        gOFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return gOFBBlockCipher.blockSize;
    }

    @Override
    public void reset() {
        GOFBBlockCipher gOFBBlockCipher = object;
        gOFBBlockCipher.firstStep = true;
        gOFBBlockCipher.N3 = 0;
        gOFBBlockCipher.N4 = 0;
        Object object = ((GOFBBlockCipher)object).ofbV;
        int n3 = gOFBBlockCipher.IV.length;
        System.arraycopy(gOFBBlockCipher.IV, 0, object, 0, n3);
        gOFBBlockCipher.byteCount = 0;
        gOFBBlockCipher.cipher.reset();
    }

    @Override
    public byte calculateByte(byte by) {
        int n3;
        byte[] byArray;
        if (this.byteCount == 0) {
            int n4;
            int n5;
            if (this.firstStep) {
                GOFBBlockCipher gOFBBlockCipher = this;
                gOFBBlockCipher.firstStep = false;
                GOFBBlockCipher gOFBBlockCipher2 = this;
                byte[] byArray2 = gOFBBlockCipher2.ofbV;
                byte[] byArray3 = gOFBBlockCipher2.ofbOutV;
                gOFBBlockCipher.cipher.processBlock(byArray2, 0, byArray3, 0);
                gOFBBlockCipher.N3 = gOFBBlockCipher.bytesToint(gOFBBlockCipher.ofbOutV, 0);
                gOFBBlockCipher.N4 = gOFBBlockCipher.bytesToint(gOFBBlockCipher.ofbOutV, 4);
            }
            GOFBBlockCipher gOFBBlockCipher = this;
            gOFBBlockCipher.N3 = n5 = gOFBBlockCipher.N3 + 0x1010101;
            this.N4 = n4 = gOFBBlockCipher.N4 + 0x1010104;
            if (n4 < 0x1010104 && n4 > 0) {
                this.N4 = n4 + 1;
            }
            GOFBBlockCipher gOFBBlockCipher3 = this;
            gOFBBlockCipher3.intTobytes(n5, this.ofbV, 0);
            n5 = gOFBBlockCipher3.N4;
            gOFBBlockCipher3.intTobytes(n5, gOFBBlockCipher3.ofbV, 4);
            GOFBBlockCipher gOFBBlockCipher4 = this;
            byArray = gOFBBlockCipher4.ofbV;
            byte[] byArray4 = gOFBBlockCipher4.ofbOutV;
            gOFBBlockCipher3.cipher.processBlock(byArray, 0, byArray4, 0);
        }
        GOFBBlockCipher gOFBBlockCipher = this;
        byArray = gOFBBlockCipher.ofbOutV;
        int n6 = gOFBBlockCipher.byteCount;
        this.byteCount = n3 = n6 + 1;
        by = (byte)(byArray[n6] ^ by);
        int n7 = this.blockSize;
        if (n3 == n7) {
            GOFBBlockCipher gOFBBlockCipher5 = this;
            gOFBBlockCipher5.byteCount = 0;
            byte[] byArray5 = gOFBBlockCipher5.ofbV;
            int n8 = n7;
            n7 = byArray5.length - n7;
            System.arraycopy(gOFBBlockCipher5.ofbV, n8, byArray5, 0, n7);
            byte[] byArray6 = this.ofbV;
            int n9 = this.blockSize;
            int n10 = this.ofbV.length - n9;
            System.arraycopy(gOFBBlockCipher5.ofbOutV, 0, byArray6, n10, n9);
        }
        return by;
    }
}

