/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] iv;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private boolean initialised;
    private BlockCipher engine;

    public KCTRBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.engine = blockCipher;
        this.iv = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    private void incrementCounterAt(int n3) {
        while (true) {
            byte by;
            byte[] byArray = this.ofbV;
            if (n3 >= this.ofbV.length) break;
            int n4 = n3;
            int n5 = n4 + 1;
            byArray[n3] = by = (byte)(byArray[n4] + 1);
            if (by != 0) break;
            n3 = n5;
        }
    }

    private void checkCounter() {
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.initialised = true;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            KCTRBlockCipher kCTRBlockCipher = this;
            int n3 = kCTRBlockCipher.iv.length - byArray.length;
            Arrays.fill(kCTRBlockCipher.iv, (byte)0);
            object = kCTRBlockCipher.iv;
            int n4 = byArray.length;
            System.arraycopy(byArray, 0, object, n3, n4);
            CipherParameters cipherParameters = parametersWithIV.getParameters();
            if (cipherParameters != null) {
                this.engine.init(true, cipherParameters);
            }
            this.reset();
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KCTR";
    }

    @Override
    public int getBlockSize() {
        return this.engine.getBlockSize();
    }

    @Override
    public byte calculateByte(byte by) {
        int n3;
        int n4 = this.byteCount;
        if (n4 == 0) {
            KCTRBlockCipher kCTRBlockCipher = this;
            kCTRBlockCipher.incrementCounterAt(0);
            kCTRBlockCipher.checkCounter();
            KCTRBlockCipher kCTRBlockCipher2 = this;
            byte[] byArray = kCTRBlockCipher2.ofbV;
            byte[] byArray2 = kCTRBlockCipher2.ofbOutV;
            kCTRBlockCipher.engine.processBlock(byArray, 0, byArray2, 0);
            int n5 = this.byteCount;
            this.byteCount = n5 + 1;
            return (byte)(kCTRBlockCipher.ofbOutV[n5] ^ by);
        }
        byte[] byArray = this.ofbOutV;
        this.byteCount = n3 = n4 + 1;
        by = (byte)(byArray[n4] ^ by);
        if (n3 == this.ofbV.length) {
            this.byteCount = 0;
        }
        return by;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (byArray.length - n3 >= this.getBlockSize()) {
            if (byArray2.length - n4 >= this.getBlockSize()) {
                KCTRBlockCipher kCTRBlockCipher = this;
                kCTRBlockCipher.processBytes(byArray, n3, this.getBlockSize(), byArray2, n4);
                return kCTRBlockCipher.getBlockSize();
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        if (this.initialised) {
            KCTRBlockCipher kCTRBlockCipher = this;
            byte[] byArray = kCTRBlockCipher.iv;
            byte[] byArray2 = kCTRBlockCipher.ofbV;
            this.engine.processBlock(byArray, 0, byArray2, 0);
        }
        this.engine.reset();
        this.byteCount = 0;
    }
}

