/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.KGCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables16kKGCMMultiplier_512;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables4kKGCMMultiplier_128;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables8kKGCMMultiplier_256;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class KGCMBlockCipher
implements AEADBlockCipher {
    private static final int MIN_MAC_BITS = 64;
    private BlockCipher engine;
    private BufferedBlockCipher ctrEngine;
    private int macSize;
    private boolean forEncryption;
    private byte[] initialAssociatedText;
    private byte[] macBlock;
    private byte[] iv;
    private KGCMMultiplier multiplier;
    private long[] b;
    private final int blockSize;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    private static KGCMMultiplier createDefaultMultiplier(int n3) {
        if (n3 != 16) {
            if (n3 != 32) {
                if (n3 == 64) {
                    return new Tables16kKGCMMultiplier_512();
                }
                throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
            }
            return new Tables8kKGCMMultiplier_256();
        }
        return new Tables4kKGCMMultiplier_128();
    }

    public KGCMBlockCipher(BlockCipher blockCipher) {
        int n3;
        this.engine = blockCipher;
        this.ctrEngine = new BufferedBlockCipher(new KCTRBlockCipher(blockCipher));
        this.macSize = -1;
        this.blockSize = n3 = this.engine.getBlockSize();
        this.initialAssociatedText = new byte[n3];
        this.iv = new byte[n3];
        this.multiplier = KGCMBlockCipher.createDefaultMultiplier(n3);
        this.b = new long[n3 >>> 3];
        this.macBlock = null;
    }

    private void processAAD(byte[] byArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            KGCMBlockCipher kGCMBlockCipher = this;
            KGCMBlockCipher.xorWithInput(kGCMBlockCipher.b, byArray, n3);
            kGCMBlockCipher.multiplier.multiplyH(this.b);
            n3 += kGCMBlockCipher.blockSize;
        }
    }

    private void calculateMac(byte[] byArray, int n3, int n4, int n5) {
        long l3;
        int n6 = n3 + n4;
        while (n3 < n6) {
            KGCMBlockCipher kGCMBlockCipher = this;
            KGCMBlockCipher.xorWithInput(kGCMBlockCipher.b, byArray, n3);
            kGCMBlockCipher.multiplier.multiplyH(this.b);
            n3 += kGCMBlockCipher.blockSize;
        }
        KGCMBlockCipher kGCMBlockCipher = this;
        long l4 = ((long)n5 & 0xFFFFFFFFL) << 3;
        long l5 = ((long)n4 & 0xFFFFFFFFL) << 3;
        long[] lArray = kGCMBlockCipher.b;
        lArray[0] = l3 = lArray[0] ^ l4;
        int n7 = this.blockSize >>> 4;
        lArray[n7] = l4 = kGCMBlockCipher.b[n7] ^ l5;
        byte[] byArray2 = Pack.longToLittleEndian(kGCMBlockCipher.b);
        kGCMBlockCipher.macBlock = byArray2;
        kGCMBlockCipher.engine.processBlock(byArray2, 0, byArray2, 0);
    }

    private static void xorWithInput(long[] lArray, byte[] byArray, int n3) {
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            lArray[i3] = lArray[i3] ^ Pack.littleEndianToLong(byArray, n3);
            n3 += 8;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block8: {
            ParametersWithIV parametersWithIV;
            CipherParameters cipherParameters;
            block7: {
                block5: {
                    int n3;
                    block6: {
                        this.forEncryption = bl;
                        if (!(object instanceof AEADParameters)) break block5;
                        cipherParameters = (AEADParameters)object;
                        AEADParameters aEADParameters = cipherParameters;
                        byte[] byArray = aEADParameters.getNonce();
                        object = byArray;
                        KGCMBlockCipher kGCMBlockCipher = this;
                        n3 = kGCMBlockCipher.iv.length - ((Object)object).length;
                        Arrays.fill(kGCMBlockCipher.iv, (byte)0);
                        byte[] byArray2 = kGCMBlockCipher.iv;
                        int n4 = byArray.length;
                        System.arraycopy(byArray, 0, byArray2, n3, n4);
                        this.initialAssociatedText = aEADParameters.getAssociatedText();
                        n3 = ((AEADParameters)cipherParameters).getMacSize();
                        if (n3 < 64 || n3 > this.blockSize << 3 || (n3 & 7) != 0) break block6;
                        this.macSize = n3 >>> 3;
                        cipherParameters = ((AEADParameters)cipherParameters).getKey();
                        byte[] byArray3 = this.initialAssociatedText;
                        if (this.initialAssociatedText != null) {
                            int n5 = byArray3.length;
                            this.processAADBytes(byArray3, 0, n5);
                        }
                        break block7;
                    }
                    throw new IllegalArgumentException(a.a("Invalid value for MAC size: ", n3));
                }
                if (!(object instanceof ParametersWithIV)) break block8;
                cipherParameters = (ParametersWithIV)object;
                byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
                object = byArray;
                KGCMBlockCipher kGCMBlockCipher = this;
                int n6 = kGCMBlockCipher.iv.length - ((Object)object).length;
                Arrays.fill(kGCMBlockCipher.iv, (byte)0);
                byte[] byArray4 = kGCMBlockCipher.iv;
                int n7 = byArray.length;
                System.arraycopy(byArray, 0, byArray4, n6, n7);
                this.initialAssociatedText = null;
                this.macSize = this.blockSize;
                cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            }
            KGCMBlockCipher kGCMBlockCipher = this;
            kGCMBlockCipher.macBlock = new byte[kGCMBlockCipher.blockSize];
            ParametersWithIV parametersWithIV2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(cipherParameters, this.iv);
            kGCMBlockCipher.ctrEngine.init(true, parametersWithIV2);
            kGCMBlockCipher.engine.init(true, cipherParameters);
            return;
        }
        throw new IllegalArgumentException("Invalid parameter passed");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KGCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void processAADByte(byte by) {
        ((OutputStream)this.associatedText).write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        ((OutputStream)this.associatedText).write(byArray, n3, n4);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        ((OutputStream)this.data).write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (byArray.length >= n3 + n4) {
            ((OutputStream)this.data).write(byArray, n3, n4);
            return 0;
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block11: {
            int n4;
            int n5;
            block10: {
                int n6;
                block8: {
                    block9: {
                        KGCMBlockCipher kGCMBlockCipher = this;
                        n5 = kGCMBlockCipher.data.size();
                        if (!kGCMBlockCipher.forEncryption && n5 < this.macSize) {
                            throw new InvalidCipherTextException("data too short");
                        }
                        KGCMBlockCipher kGCMBlockCipher2 = this;
                        byte[] byArray2 = new byte[kGCMBlockCipher2.blockSize];
                        kGCMBlockCipher2.engine.processBlock(byArray2, 0, byArray2, 0);
                        long[] lArray = new long[kGCMBlockCipher2.blockSize >>> 3];
                        Pack.littleEndianToLong(byArray2, 0, lArray);
                        this.multiplier.init(lArray);
                        Arrays.fill(byArray2, (byte)0);
                        Arrays.fill(lArray, 0L);
                        n6 = kGCMBlockCipher2.associatedText.size();
                        if (n6 > 0) {
                            KGCMBlockCipher kGCMBlockCipher3 = this;
                            kGCMBlockCipher3.processAAD(kGCMBlockCipher3.associatedText.getBuffer(), 0, n6);
                        }
                        if (!this.forEncryption) break block8;
                        if (byArray.length - n3 - this.macSize < n5) break block9;
                        KGCMBlockCipher kGCMBlockCipher4 = this;
                        n4 = kGCMBlockCipher4.ctrEngine.processBytes(this.data.getBuffer(), 0, n5, byArray, n3);
                        n4 = kGCMBlockCipher4.ctrEngine.doFinal(byArray, n3 + n4) + n4;
                        this.calculateMac(byArray, n3, n5, n6);
                        break block10;
                    }
                    throw new OutputLengthException("Output buffer too short");
                }
                n4 = n5 - this.macSize;
                if (byArray.length - n3 < n4) break block11;
                KGCMBlockCipher kGCMBlockCipher = this;
                kGCMBlockCipher.calculateMac(kGCMBlockCipher.data.getBuffer(), 0, n4, n6);
                n6 = kGCMBlockCipher.ctrEngine.processBytes(this.data.getBuffer(), 0, n4, byArray, n3);
                n4 = kGCMBlockCipher.ctrEngine.doFinal(byArray, n3 + n6) + n6;
            }
            byte[] byArray3 = this.macBlock;
            if (this.macBlock != null) {
                if (this.forEncryption) {
                    KGCMBlockCipher kGCMBlockCipher = this;
                    int n7 = n3 + n4;
                    n3 = this.macSize;
                    System.arraycopy(byArray3, 0, byArray, n7, n3);
                    kGCMBlockCipher.reset();
                    return n4 + kGCMBlockCipher.macSize;
                }
                byArray = new byte[this.macSize];
                KGCMBlockCipher kGCMBlockCipher = this;
                n3 = this.macSize;
                System.arraycopy(kGCMBlockCipher.data.getBuffer(), n5 - n3, byArray, 0, n3);
                int n8 = kGCMBlockCipher.macSize;
                byte[] byArray4 = new byte[n8];
                System.arraycopy(this.macBlock, 0, byArray4, 0, n8);
                if (Arrays.constantTimeAreEqual(byArray, byArray4)) {
                    this.reset();
                    return n4;
                }
                throw new InvalidCipherTextException("mac verification failed");
            }
            throw new IllegalStateException("mac is not calculated");
        }
        throw new OutputLengthException("Output buffer too short");
    }

    @Override
    public byte[] getMac() {
        int n3 = this.macSize;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.macBlock, 0, byArray, 0, n3);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        return 0;
    }

    @Override
    public int getOutputSize(int n3) {
        KGCMBlockCipher kGCMBlockCipher = this;
        n3 = kGCMBlockCipher.data.size() + n3;
        if (kGCMBlockCipher.forEncryption) {
            return n3 + this.macSize;
        }
        int n4 = this.macSize;
        return n3 < n4 ? 0 : n3 - n4;
    }

    @Override
    public void reset() {
        KGCMBlockCipher kGCMBlockCipher = this;
        Arrays.fill(kGCMBlockCipher.b, 0L);
        kGCMBlockCipher.engine.reset();
        kGCMBlockCipher.data.reset();
        kGCMBlockCipher.associatedText.reset();
        byte[] byArray = kGCMBlockCipher.initialAssociatedText;
        if (kGCMBlockCipher.initialAssociatedText != null) {
            int n3 = byArray.length;
            this.processAADBytes(byArray, 0, n3);
        }
    }

    public class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

