/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class KXTSBlockCipher
extends BufferedBlockCipher {
    private static final long RED_POLY_128 = 135L;
    private static final long RED_POLY_256 = 1061L;
    private static final long RED_POLY_512 = 293L;
    private final int blockSize;
    private final long reductionPolynomial;
    private final long[] tw_init;
    private final long[] tw_current;
    private int counter;

    public static long getReductionPolynomial(int n3) {
        if (n3 != 16) {
            if (n3 != 32) {
                if (n3 == 64) {
                    return 293L;
                }
                throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
            }
            return 1061L;
        }
        return 135L;
    }

    public KXTSBlockCipher(BlockCipher blockCipher) {
        int n3;
        KXTSBlockCipher kXTSBlockCipher = this;
        this.cipher = blockCipher;
        this.blockSize = n3 = blockCipher.getBlockSize();
        this.reductionPolynomial = KXTSBlockCipher.getReductionPolynomial(n3);
        this.tw_init = new long[n3 >>> 3];
        kXTSBlockCipher.tw_current = new long[n3 >>> 3];
        kXTSBlockCipher.counter = -1;
    }

    private void processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.counter;
        if (n5 != -1) {
            KXTSBlockCipher kXTSBlockCipher = this;
            kXTSBlockCipher.counter = n5 + 1;
            KXTSBlockCipher.GF_double(kXTSBlockCipher.reductionPolynomial, this.tw_current);
            byte[] byArray3 = new byte[kXTSBlockCipher.blockSize];
            KXTSBlockCipher kXTSBlockCipher2 = this;
            Pack.longToLittleEndian(kXTSBlockCipher2.tw_current, byArray3, 0);
            int n6 = kXTSBlockCipher2.blockSize;
            byte[] byArray4 = new byte[n6];
            System.arraycopy(byArray3, 0, byArray4, 0, n6);
            for (n6 = 0; n6 < this.blockSize; ++n6) {
                byArray4[n6] = (byte)(byArray4[n6] ^ byArray[n3 + n6]);
            }
            this.cipher.processBlock(byArray4, 0, byArray4, 0);
            for (int i3 = 0; i3 < this.blockSize; ++i3) {
                n3 = n4 + i3;
                byArray2[n3] = (byte)(byArray4[i3] ^ byArray3[i3]);
            }
            return;
        }
        throw new IllegalStateException("Attempt to process too many blocks");
    }

    private static void GF_double(long l3, long[] lArray) {
        long l4 = 0L;
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            long l5 = lArray[i3];
            long l6 = l5 >>> 63;
            lArray[i3] = l5 << 1 ^ l4;
            l4 = l6;
        }
        lArray[0] = l3 = lArray[0] ^ l3 & -l4;
    }

    @Override
    public int getOutputSize(int n3) {
        return n3;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        return n3;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters2 instanceof ParametersWithIV) {
            Object object;
            int n3;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters2;
            cipherParameters2 = parametersWithIV.getParameters();
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length == (n3 = ((KXTSBlockCipher)object).blockSize)) {
                KXTSBlockCipher kXTSBlockCipher = object;
                byte[] byArray2 = new byte[n3];
                KXTSBlockCipher kXTSBlockCipher2 = object;
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                kXTSBlockCipher2.cipher.init(true, cipherParameters2);
                kXTSBlockCipher2.cipher.processBlock(byArray2, 0, byArray2, 0);
                kXTSBlockCipher2.cipher.init(bl, cipherParameters2);
                Pack.littleEndianToLong(byArray2, 0, kXTSBlockCipher2.tw_init);
                object = ((KXTSBlockCipher)object).tw_current;
                int n4 = kXTSBlockCipher.tw_init.length;
                System.arraycopy(kXTSBlockCipher.tw_init, 0, object, 0, n4);
                kXTSBlockCipher.counter = 0;
                return;
            }
            throw new IllegalArgumentException("Currently only support IVs of exactly one block");
        }
        throw new IllegalArgumentException("Invalid parameters passed");
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (byArray.length - n3 >= n4) {
            if (byArray2.length - n3 >= n4) {
                if (n4 % this.blockSize == 0) {
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = n6;
                        KXTSBlockCipher kXTSBlockCipher = this;
                        int n8 = n6;
                        n6 = n3 + n6;
                        int n9 = n5 + n8;
                        kXTSBlockCipher.processBlock(byArray, n6, byArray2, n9);
                        n6 = n7 + kXTSBlockCipher.blockSize;
                    }
                    return n4;
                }
                throw new IllegalArgumentException("Partial blocks not supported");
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        this.reset();
        return 0;
    }

    @Override
    public void reset() {
        KXTSBlockCipher kXTSBlockCipher = object;
        kXTSBlockCipher.cipher.reset();
        Object object = ((KXTSBlockCipher)object).tw_current;
        int n3 = kXTSBlockCipher.tw_init.length;
        System.arraycopy(kXTSBlockCipher.tw_init, 0, object, 0, n3);
        kXTSBlockCipher.counter = 0;
    }
}

