/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.Vector;

public class OCBBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private BlockCipher hashCipher;
    private BlockCipher mainCipher;
    private boolean forEncryption;
    private int macSize;
    private byte[] initialAssociatedText;
    private Vector L;
    private byte[] L_Asterisk;
    private byte[] L_Dollar;
    private byte[] KtopInput = null;
    private byte[] Stretch = new byte[24];
    private byte[] OffsetMAIN_0 = new byte[16];
    private byte[] hashBlock;
    private byte[] mainBlock;
    private int hashBlockPos;
    private int mainBlockPos;
    private long hashBlockCount;
    private long mainBlockCount;
    private byte[] OffsetHASH;
    private byte[] Sum;
    private byte[] OffsetMAIN = new byte[16];
    private byte[] Checksum;
    private byte[] macBlock;

    public OCBBlockCipher(BlockCipher blockCipher, BlockCipher blockCipher2) {
        if (blockCipher != null) {
            if (blockCipher.getBlockSize() == 16) {
                if (blockCipher2 != null) {
                    if (blockCipher2.getBlockSize() == 16) {
                        if (blockCipher.getAlgorithmName().equals(blockCipher2.getAlgorithmName())) {
                            OCBBlockCipher oCBBlockCipher = this;
                            oCBBlockCipher.hashCipher = blockCipher;
                            oCBBlockCipher.mainCipher = blockCipher2;
                            return;
                        }
                        throw new IllegalArgumentException("'hashCipher' and 'mainCipher' must be the same algorithm");
                    }
                    throw new IllegalArgumentException("'mainCipher' must have a block size of 16");
                }
                throw new IllegalArgumentException("'mainCipher' cannot be null");
            }
            throw new IllegalArgumentException("'hashCipher' must have a block size of 16");
        }
        throw new IllegalArgumentException("'hashCipher' cannot be null");
    }

    public static byte[] OCB_double(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n3 = OCBBlockCipher.shiftLeft(byArray, byArray2);
        byArray2[15] = (byte)(byArray2[15] ^ 135 >>> (1 - n3 << 3));
        return byArray2;
    }

    public static void OCB_extend(byte[] byArray, int n3) {
        byArray[n3] = -128;
        while (++n3 < 16) {
            byArray[n3] = 0;
        }
    }

    public static int OCB_ntz(long l3) {
        if (l3 == 0L) {
            return 64;
        }
        int n3 = 0;
        while ((l3 & 1L) == 0L) {
            ++n3;
            l3 >>>= 1;
        }
        return n3;
    }

    public static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n3 = 16;
        int n4 = 0;
        while ((n3 += -1) >= 0) {
            int n5 = byArray[n3] & 0xFF;
            byArray2[n3] = (byte)(n5 << 1 | n4);
            n4 = n5 >>> 7 & 1;
        }
        return n4;
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        for (int i3 = 15; i3 >= 0; --i3) {
            byArray[i3] = (byte)(byArray[i3] ^ byArray2[i3]);
        }
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.mainCipher;
    }

    @Override
    public String getAlgorithmName() {
        return this.mainCipher.getAlgorithmName() + "/OCB";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block11: {
            block12: {
                block15: {
                    Vector vector;
                    byte[] byArray;
                    int n3;
                    block14: {
                        block13: {
                            block10: {
                                block8: {
                                    int n4;
                                    block9: {
                                        OCBBlockCipher oCBBlockCipher = this;
                                        n3 = this.forEncryption;
                                        oCBBlockCipher.forEncryption = bl;
                                        oCBBlockCipher.macBlock = null;
                                        if (!(cipherParameters instanceof AEADParameters)) break block8;
                                        CipherParameters cipherParameters2 = cipherParameters = (AEADParameters)cipherParameters;
                                        byArray = ((AEADParameters)cipherParameters2).getNonce();
                                        this.initialAssociatedText = ((AEADParameters)cipherParameters2).getAssociatedText();
                                        n4 = ((AEADParameters)cipherParameters).getMacSize();
                                        if (n4 < 64 || n4 > 128 || n4 % 8 != 0) break block9;
                                        this.macSize = n4 / 8;
                                        cipherParameters = ((AEADParameters)cipherParameters).getKey();
                                        break block10;
                                    }
                                    throw new IllegalArgumentException(a.a("Invalid value for MAC size: ", n4));
                                }
                                if (!(cipherParameters instanceof ParametersWithIV)) break block11;
                                OCBBlockCipher oCBBlockCipher = this;
                                cipherParameters = (ParametersWithIV)cipherParameters;
                                byArray = ((ParametersWithIV)cipherParameters).getIV();
                                oCBBlockCipher.initialAssociatedText = null;
                                oCBBlockCipher.macSize = 16;
                                cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                            }
                            this.hashBlock = new byte[16];
                            byte[] byArray2 = new byte[bl ? 16 : this.macSize + 16];
                            this.mainBlock = byArray2;
                            if (byArray == null) {
                                byArray = new byte[]{};
                            }
                            if (byArray.length > 15) break block12;
                            if (cipherParameters == null) break block13;
                            OCBBlockCipher oCBBlockCipher = this;
                            oCBBlockCipher.hashCipher.init(true, cipherParameters);
                            oCBBlockCipher.mainCipher.init(bl, cipherParameters);
                            oCBBlockCipher.KtopInput = null;
                            break block14;
                        }
                        if (n3 != bl) break block15;
                    }
                    OCBBlockCipher oCBBlockCipher = this;
                    Object object = new byte[16];
                    oCBBlockCipher.L_Asterisk = object;
                    oCBBlockCipher.hashCipher.processBlock((byte[])object, 0, (byte[])object, 0);
                    oCBBlockCipher.L_Dollar = OCBBlockCipher.OCB_double(oCBBlockCipher.L_Asterisk);
                    object = vector;
                    object();
                    this.L = object;
                    vector.addElement(OCBBlockCipher.OCB_double(this.L_Dollar));
                    int n5 = this.processNonce(byArray);
                    int n6 = n5 % 8;
                    n5 /= 8;
                    if (n6 == 0) {
                        System.arraycopy(this.Stretch, n5, this.OffsetMAIN_0, 0, 16);
                    } else {
                        for (n3 = 0; n3 < 16; ++n3) {
                            OCBBlockCipher oCBBlockCipher2 = this;
                            int n7 = oCBBlockCipher2.Stretch[n5] & 0xFF;
                            int n8 = oCBBlockCipher2.Stretch[++n5] & 0xFF;
                            oCBBlockCipher2.OffsetMAIN_0[n3] = (byte)(n7 << n6 | n8 >>> 8 - n6);
                        }
                    }
                    OCBBlockCipher oCBBlockCipher3 = this;
                    oCBBlockCipher3.hashBlockPos = 0;
                    oCBBlockCipher3.mainBlockPos = 0;
                    oCBBlockCipher3.hashBlockCount = 0L;
                    oCBBlockCipher3.mainBlockCount = 0L;
                    oCBBlockCipher3.OffsetHASH = new byte[16];
                    oCBBlockCipher3.Sum = new byte[16];
                    System.arraycopy(oCBBlockCipher3.OffsetMAIN_0, 0, this.OffsetMAIN, 0, 16);
                    oCBBlockCipher3.Checksum = new byte[16];
                    byte[] byArray3 = oCBBlockCipher3.initialAssociatedText;
                    if (oCBBlockCipher3.initialAssociatedText != null) {
                        int n9 = byArray3.length;
                        this.processAADBytes(byArray3, 0, n9);
                    }
                    return;
                }
                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
            }
            throw new IllegalArgumentException("IV must be no more than 15 bytes");
        }
        throw new IllegalArgumentException("invalid parameters passed to OCB");
    }

    public int processNonce(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = byArray2;
        int n3 = 16 - byArray.length;
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, byArray3, n3, n4);
        byArray3[0] = (byte)(this.macSize << 4);
        n3 = 15 - byArray.length;
        byArray2[n3] = (byte)(byArray2[n3] | 1);
        byte by = byArray2[15];
        n3 = by & 0x3F;
        byArray2[15] = (byte)(by & 0xC0);
        byte[] byArray4 = this.KtopInput;
        if (this.KtopInput == null || !Arrays.areEqual(byArray3, byArray4)) {
            byArray4 = new byte[16];
            OCBBlockCipher oCBBlockCipher = this;
            oCBBlockCipher.KtopInput = byArray3;
            oCBBlockCipher.hashCipher.processBlock(byArray3, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, oCBBlockCipher.Stretch, 0, 16);
            int n5 = 0;
            while (n5 < 8) {
                int n6 = n5++;
                int n7 = n6 + 16;
                this.Stretch[n7] = (byte)(byArray4[n6] ^ byArray4[n5]);
            }
        }
        return n3;
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = this.macBlock;
        if (this.macBlock == null) {
            return new byte[this.macSize];
        }
        return Arrays.clone(byArray);
    }

    @Override
    public int getOutputSize(int n3) {
        n3 += this.mainBlockPos;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        int n4 = this.macSize;
        return n3 < n4 ? 0 : n3 - n4;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        n3 += this.mainBlockPos;
        if (!this.forEncryption) {
            int n4 = this.macSize;
            if (n3 < n4) {
                return 0;
            }
            n3 -= n4;
        }
        int n5 = n3;
        return n5 - n5 % 16;
    }

    @Override
    public void processAADByte(byte by) {
        byte[] byArray = this.hashBlock;
        int n3 = this.hashBlockPos;
        this.hashBlock[n3] = by;
        int n4 = n3 + 1;
        by = (byte)n4;
        this.hashBlockPos = by;
        if (n4 == byArray.length) {
            this.processHashBlock();
        }
    }

    @Override
    public void processAADBytes(byte[] byArray, int n3, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            byte[] byArray2 = this.hashBlock;
            int n5 = this.hashBlockPos;
            this.hashBlock[n5] = byArray[n3 + i3];
            this.hashBlockPos = ++n5;
            if (n5 != byArray2.length) continue;
            this.processHashBlock();
        }
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        byte[] byArray2 = this.mainBlock;
        int n4 = this.mainBlockPos;
        this.mainBlock[n4] = by;
        int n5 = n4 + 1;
        by = (byte)n5;
        this.mainBlockPos = by;
        if (n5 == byArray2.length) {
            this.processMainBlock(byArray, n3);
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (byArray.length >= n3 + n4) {
            int n6 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                byte[] byArray3 = this.mainBlock;
                int n7 = this.mainBlockPos;
                this.mainBlock[n7] = byArray[n3 + i3];
                this.mainBlockPos = ++n7;
                if (n7 != byArray3.length) continue;
                this.processMainBlock(byArray2, n5 + n6);
                n6 += 16;
            }
            return n6;
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block16: {
            int n4;
            block15: {
                byte[] byArray2;
                block13: {
                    block14: {
                        byte[] byArray3;
                        byArray2 = null;
                        if (!this.forEncryption) {
                            int n5 = this.mainBlockPos;
                            n4 = this.macSize;
                            if (n5 >= n4) {
                                this.mainBlockPos = n5 -= n4;
                                byArray3 = new byte[n4];
                                System.arraycopy(this.mainBlock, n5, byArray3, 0, n4);
                                byArray2 = byArray3;
                            } else {
                                throw new InvalidCipherTextException("data too short");
                            }
                        }
                        if ((n4 = this.hashBlockPos) > 0) {
                            OCBBlockCipher oCBBlockCipher = this;
                            OCBBlockCipher.OCB_extend(oCBBlockCipher.hashBlock, n4);
                            oCBBlockCipher.updateHASH(oCBBlockCipher.L_Asterisk);
                        }
                        if ((n4 = this.mainBlockPos) > 0) {
                            if (this.forEncryption) {
                                OCBBlockCipher oCBBlockCipher = this;
                                OCBBlockCipher.OCB_extend(oCBBlockCipher.mainBlock, n4);
                                OCBBlockCipher.xor(oCBBlockCipher.Checksum, this.mainBlock);
                            }
                            OCBBlockCipher oCBBlockCipher = this;
                            OCBBlockCipher.xor(oCBBlockCipher.OffsetMAIN, this.L_Asterisk);
                            byte[] byArray4 = new byte[16];
                            oCBBlockCipher.hashCipher.processBlock(this.OffsetMAIN, 0, byArray4, 0);
                            OCBBlockCipher.xor(oCBBlockCipher.mainBlock, byArray4);
                            n4 = this.mainBlockPos;
                            if (byArray.length >= n3 + n4) {
                                OCBBlockCipher oCBBlockCipher2 = this;
                                System.arraycopy(oCBBlockCipher2.mainBlock, 0, byArray, n3, n4);
                                if (!oCBBlockCipher2.forEncryption) {
                                    OCBBlockCipher oCBBlockCipher3 = this;
                                    OCBBlockCipher.OCB_extend(oCBBlockCipher3.mainBlock, this.mainBlockPos);
                                    OCBBlockCipher.xor(oCBBlockCipher3.Checksum, this.mainBlock);
                                }
                            } else {
                                throw new OutputLengthException("Output buffer too short");
                            }
                        }
                        OCBBlockCipher oCBBlockCipher = this;
                        OCBBlockCipher.xor(oCBBlockCipher.Checksum, this.OffsetMAIN);
                        OCBBlockCipher.xor(oCBBlockCipher.Checksum, this.L_Dollar);
                        oCBBlockCipher.hashCipher.processBlock(this.Checksum, 0, this.Checksum, 0);
                        OCBBlockCipher.xor(oCBBlockCipher.Checksum, this.Sum);
                        n4 = oCBBlockCipher.macSize;
                        byArray3 = new byte[n4];
                        oCBBlockCipher.macBlock = byArray3;
                        System.arraycopy(oCBBlockCipher.Checksum, 0, byArray3, 0, n4);
                        n4 = oCBBlockCipher.mainBlockPos;
                        if (!oCBBlockCipher.forEncryption) break block13;
                        int n6 = this.macSize;
                        if (byArray.length < (n3 += n4) + n6) break block14;
                        OCBBlockCipher oCBBlockCipher4 = this;
                        System.arraycopy(oCBBlockCipher4.macBlock, 0, byArray, n3, n6);
                        n4 += oCBBlockCipher4.macSize;
                        break block15;
                    }
                    throw new OutputLengthException("Output buffer too short");
                }
                if (!Arrays.constantTimeAreEqual(this.macBlock, byArray2)) break block16;
            }
            this.reset(false);
            return n4;
        }
        throw new InvalidCipherTextException("mac check in OCB failed");
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    public void clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public byte[] getLSub(int n3) {
        while (n3 >= this.L.size()) {
            Vector vector = this.L;
            vector.addElement(OCBBlockCipher.OCB_double((byte[])vector.lastElement()));
        }
        return (byte[])this.L.elementAt(n3);
    }

    public void processHashBlock() {
        long l3;
        OCBBlockCipher oCBBlockCipher = this;
        oCBBlockCipher.hashBlockCount = l3 = oCBBlockCipher.hashBlockCount + 1L;
        oCBBlockCipher.updateHASH(oCBBlockCipher.getLSub(OCBBlockCipher.OCB_ntz(l3)));
        oCBBlockCipher.hashBlockPos = 0;
    }

    public void processMainBlock(byte[] byArray, int n3) {
        if (byArray.length >= n3 + 16) {
            long l3;
            if (this.forEncryption) {
                OCBBlockCipher.xor(this.Checksum, this.mainBlock);
                this.mainBlockPos = 0;
            }
            OCBBlockCipher oCBBlockCipher = this;
            OCBBlockCipher oCBBlockCipher2 = this;
            oCBBlockCipher2.mainBlockCount = l3 = oCBBlockCipher2.mainBlockCount + 1L;
            OCBBlockCipher.xor(oCBBlockCipher.OffsetMAIN, oCBBlockCipher2.getLSub(OCBBlockCipher.OCB_ntz(l3)));
            OCBBlockCipher.xor(oCBBlockCipher.mainBlock, this.OffsetMAIN);
            oCBBlockCipher.mainCipher.processBlock(this.mainBlock, 0, this.mainBlock, 0);
            OCBBlockCipher.xor(oCBBlockCipher.mainBlock, this.OffsetMAIN);
            System.arraycopy(oCBBlockCipher.mainBlock, 0, byArray, n3, 16);
            if (!oCBBlockCipher.forEncryption) {
                OCBBlockCipher oCBBlockCipher3 = this;
                OCBBlockCipher.xor(oCBBlockCipher3.Checksum, this.mainBlock);
                int n4 = this.macSize;
                System.arraycopy(oCBBlockCipher3.mainBlock, 16, oCBBlockCipher3.mainBlock, 0, n4);
                oCBBlockCipher3.mainBlockPos = oCBBlockCipher3.macSize;
            }
            return;
        }
        throw new OutputLengthException("Output buffer too short");
    }

    public void reset(boolean bl) {
        OCBBlockCipher oCBBlockCipher = this;
        oCBBlockCipher.hashCipher.reset();
        oCBBlockCipher.mainCipher.reset();
        oCBBlockCipher.clear(oCBBlockCipher.hashBlock);
        oCBBlockCipher.clear(oCBBlockCipher.mainBlock);
        oCBBlockCipher.hashBlockPos = 0;
        oCBBlockCipher.mainBlockPos = 0;
        oCBBlockCipher.hashBlockCount = 0L;
        oCBBlockCipher.mainBlockCount = 0L;
        oCBBlockCipher.clear(oCBBlockCipher.OffsetHASH);
        oCBBlockCipher.clear(oCBBlockCipher.Sum);
        System.arraycopy(oCBBlockCipher.OffsetMAIN_0, 0, this.OffsetMAIN, 0, 16);
        oCBBlockCipher.clear(oCBBlockCipher.Checksum);
        if (bl) {
            this.macBlock = null;
        }
        byte[] byArray = this.initialAssociatedText;
        if (this.initialAssociatedText != null) {
            int n3 = byArray.length;
            this.processAADBytes(byArray, 0, n3);
        }
    }

    public void updateHASH(byte[] byArray) {
        OCBBlockCipher oCBBlockCipher = this;
        OCBBlockCipher.xor(oCBBlockCipher.OffsetHASH, byArray);
        OCBBlockCipher.xor(oCBBlockCipher.hashBlock, this.OffsetHASH);
        oCBBlockCipher.hashCipher.processBlock(this.hashBlock, 0, this.hashBlock, 0);
        OCBBlockCipher.xor(oCBBlockCipher.Sum, this.hashBlock);
    }
}

