/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class OFBBlockCipher
extends StreamBlockCipher {
    private int byteCount;
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private final int blockSize;
    private final BlockCipher cipher;

    public OFBBlockCipher(BlockCipher blockCipher, int n3) {
        super(blockCipher);
        if (n3 <= blockCipher.getBlockSize() * 8 && n3 >= 8 && n3 % 8 == 0) {
            this.cipher = blockCipher;
            this.blockSize = n3 / 8;
            this.IV = new byte[blockCipher.getBlockSize()];
            this.ofbV = new byte[blockCipher.getBlockSize()];
            this.ofbOutV = new byte[blockCipher.getBlockSize()];
            return;
        }
        throw new IllegalArgumentException(f.a("0FB", n3, " not supported"));
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n3 = byArray2.length - ((Object)object).length;
                int n4 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n3, n4);
                int n5 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n5 < this.IV.length - ((Object)object).length) {
                        byArray3[n5] = 0;
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else {
                int n6 = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n6);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OFB" + this.blockSize * 8;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        OFBBlockCipher oFBBlockCipher = this;
        oFBBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return oFBBlockCipher.blockSize;
    }

    @Override
    public void reset() {
        OFBBlockCipher oFBBlockCipher = object;
        Object object = ((OFBBlockCipher)object).ofbV;
        int n3 = oFBBlockCipher.IV.length;
        System.arraycopy(oFBBlockCipher.IV, 0, object, 0, n3);
        oFBBlockCipher.byteCount = 0;
        oFBBlockCipher.cipher.reset();
    }

    @Override
    public byte calculateByte(byte by) {
        int n3;
        byte[] byArray;
        if (this.byteCount == 0) {
            OFBBlockCipher oFBBlockCipher = this;
            byArray = oFBBlockCipher.ofbV;
            byte[] byArray2 = oFBBlockCipher.ofbOutV;
            this.cipher.processBlock(byArray, 0, byArray2, 0);
        }
        OFBBlockCipher oFBBlockCipher = this;
        byArray = oFBBlockCipher.ofbOutV;
        int n4 = oFBBlockCipher.byteCount;
        this.byteCount = n3 = n4 + 1;
        by = (byte)(byArray[n4] ^ by);
        int n5 = this.blockSize;
        if (n3 == n5) {
            OFBBlockCipher oFBBlockCipher2 = this;
            oFBBlockCipher2.byteCount = 0;
            byte[] byArray3 = oFBBlockCipher2.ofbV;
            int n6 = n5;
            n5 = byArray3.length - n5;
            System.arraycopy(oFBBlockCipher2.ofbV, n6, byArray3, 0, n5);
            byte[] byArray4 = this.ofbV;
            int n7 = this.blockSize;
            int n8 = this.ofbV.length - n7;
            System.arraycopy(oFBBlockCipher2.ofbOutV, 0, byArray4, n8, n7);
        }
        return by;
    }
}

