/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class OpenPGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;

    public OpenPGPCFBBlockCipher(BlockCipher blockCipher) {
        int n3;
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
        this.cipher = blockCipher;
        openPGPCFBBlockCipher.blockSize = n3 = blockCipher.getBlockSize();
        openPGPCFBBlockCipher.IV = new byte[n3];
        openPGPCFBBlockCipher.FR = new byte[n3];
        openPGPCFBBlockCipher.FRE = new byte[n3];
    }

    private byte encryptByte(byte by, int n3) {
        return (byte)(this.FRE[n3] ^ by);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5;
        int n6 = this.blockSize;
        if (n3 + n6 > byArray.length) throw new DataLengthException("input buffer too short");
        if (n4 + n6 > byArray2.length) throw new OutputLengthException("output buffer too short");
        int n7 = this.count;
        if (n7 > n6) {
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            int n8 = n6;
            n7 = byArray[n3];
            byArray2[n4] = n7 = this.encryptByte((byte)n7, n8 - 2);
            openPGPCFBBlockCipher.FR[n6 -= 2] = n7;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher2 = this;
            int n9 = openPGPCFBBlockCipher2.blockSize;
            n6 = n9;
            n7 = n4 + 1;
            int n10 = byArray[n3 + 1];
            byArray2[n7] = n10 = openPGPCFBBlockCipher2.encryptByte((byte)n10, n9 - 1);
            openPGPCFBBlockCipher.FR[--n6] = n10;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher3 = this;
            byte[] byArray3 = openPGPCFBBlockCipher3.FR;
            byte[] byArray4 = openPGPCFBBlockCipher3.FRE;
            openPGPCFBBlockCipher.cipher.processBlock(byArray3, 0, byArray4, 0);
            int n11 = 2;
            while (n11 < this.blockSize) {
                byte by;
                int n12 = n11;
                int n13 = n12 - 2;
                n10 = n4 + n12;
                byArray2[n10] = by = this.encryptByte(byArray[n3 + n11], n13);
                this.FR[n13] = by;
                ++n11;
            }
            return this.blockSize;
        }
        if (n7 == 0) {
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            byte[] byArray5 = openPGPCFBBlockCipher.FR;
            byte[] byArray6 = openPGPCFBBlockCipher.FRE;
            this.cipher.processBlock(byArray5, 0, byArray6, 0);
            for (int i3 = 0; i3 < (n5 = this.blockSize); ++i3) {
                byte by;
                n5 = n4 + i3;
                byArray2[n5] = by = this.encryptByte(byArray[n3 + i3], i3);
                this.FR[i3] = by;
            }
        } else {
            if (n7 != n6) return this.blockSize;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher4 = this;
            byte[] byArray7 = openPGPCFBBlockCipher4.FR;
            byte[] byArray8 = openPGPCFBBlockCipher4.FRE;
            this.cipher.processBlock(byArray7, 0, byArray8, 0);
            byArray2[n4] = this.encryptByte(byArray[n3], 0);
            int n14 = n4 + 1;
            byArray2[n14] = this.encryptByte(byArray[n3 + 1], 1);
            n14 = this.blockSize - 2;
            System.arraycopy(openPGPCFBBlockCipher.FR, 2, openPGPCFBBlockCipher.FR, 0, n14);
            byte[] byArray9 = openPGPCFBBlockCipher.FR;
            System.arraycopy(byArray2, n4, byArray9, openPGPCFBBlockCipher.blockSize - 2, 2);
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher5 = this;
            byArray9 = openPGPCFBBlockCipher5.FR;
            byArray8 = openPGPCFBBlockCipher5.FRE;
            this.cipher.processBlock(byArray9, 0, byArray8, 0);
            for (int i4 = 2; i4 < (n5 = this.blockSize); ++i4) {
                byte by;
                int n15 = i4;
                n5 = n15 - 2;
                int n16 = n4 + n15;
                byArray2[n16] = by = this.encryptByte(byArray[n3 + i4], n5);
                this.FR[n5] = by;
            }
        }
        this.count += n5;
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blockSize;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                int n6 = this.count;
                if (n6 > n5) {
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    this.FR[n5 - 2] = n6 = byArray[n3];
                    byArray2[n4] = this.encryptByte((byte)n6, n5 - 2);
                    n5 = byArray[n3 + 1];
                    byte[] byArray3 = openPGPCFBBlockCipher.FR;
                    int n7 = openPGPCFBBlockCipher.blockSize;
                    int n8 = byArray3[n7 - 1] = n5;
                    n5 = n4 + 1;
                    byArray2[n5] = openPGPCFBBlockCipher.encryptByte((byte)n8, n7 - 1);
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher2 = this;
                    byte[] byArray4 = openPGPCFBBlockCipher2.FR;
                    byArray3 = openPGPCFBBlockCipher2.FRE;
                    this.cipher.processBlock(byArray4, 0, byArray3, 0);
                    for (int i3 = 2; i3 < this.blockSize; ++i3) {
                        byte by = byArray[n3 + i3];
                        n7 = i3 - 2;
                        this.FR[n7] = by;
                        int n9 = n4 + i3;
                        byArray2[n9] = this.encryptByte(by, n7);
                    }
                } else if (n6 == 0) {
                    int n10;
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    byte[] byArray5 = openPGPCFBBlockCipher.FR;
                    byte[] byArray6 = openPGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray5, 0, byArray6, 0);
                    for (int i4 = 0; i4 < (n10 = this.blockSize); ++i4) {
                        n10 = n3 + i4;
                        this.FR[i4] = byArray[n10];
                        byArray2[i4] = this.encryptByte(byArray[n10], i4);
                    }
                    this.count += n10;
                } else if (n6 == n5) {
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher3 = this;
                    byte[] byArray7 = openPGPCFBBlockCipher3.FR;
                    byte[] byArray8 = openPGPCFBBlockCipher3.FRE;
                    this.cipher.processBlock(byArray7, 0, byArray8, 0);
                    int n11 = byArray[n3];
                    int n12 = byArray[n3 + 1];
                    byArray2[n4] = this.encryptByte((byte)n11, 0);
                    int n13 = n4 + 1;
                    byArray2[n13] = this.encryptByte((byte)n12, 1);
                    n13 = this.blockSize - 2;
                    System.arraycopy(openPGPCFBBlockCipher.FR, 2, openPGPCFBBlockCipher.FR, 0, n13);
                    byte[] byArray9 = openPGPCFBBlockCipher.FR;
                    int n14 = this.blockSize;
                    byArray9[n14 - 2] = n11;
                    openPGPCFBBlockCipher.FR[n14 - 1] = n12;
                    openPGPCFBBlockCipher.cipher.processBlock(byArray9, 0, this.FRE, 0);
                    for (n11 = 2; n11 < (n12 = this.blockSize); ++n11) {
                        n12 = byArray[n3 + n11];
                        int n15 = n11 - 2;
                        this.FR[n15] = n12;
                        int n16 = n4 + n11;
                        byArray2[n16] = this.encryptByte((byte)n12, n15);
                    }
                    this.count += n12;
                }
                return this.blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OpenPGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        return this.forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
    }

    @Override
    public void reset() {
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = object;
        openPGPCFBBlockCipher.count = 0;
        Object object = ((OpenPGPCFBBlockCipher)object).FR;
        int n3 = ((OpenPGPCFBBlockCipher)object).FR.length;
        System.arraycopy(openPGPCFBBlockCipher.IV, 0, object, 0, n3);
        openPGPCFBBlockCipher.cipher.reset();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
        openPGPCFBBlockCipher.forEncryption = bl;
        openPGPCFBBlockCipher.reset();
        openPGPCFBBlockCipher.cipher.init(true, cipherParameters);
    }
}

