/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class PGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private byte[] tmp;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;
    private boolean inlineIv;

    public PGPCFBBlockCipher(BlockCipher blockCipher, boolean bl) {
        int n3;
        PGPCFBBlockCipher pGPCFBBlockCipher = this;
        this.cipher = blockCipher;
        this.inlineIv = bl;
        pGPCFBBlockCipher.blockSize = n3 = blockCipher.getBlockSize();
        pGPCFBBlockCipher.IV = new byte[n3];
        pGPCFBBlockCipher.FR = new byte[n3];
        pGPCFBBlockCipher.FRE = new byte[n3];
        pGPCFBBlockCipher.tmp = new byte[n3];
    }

    private byte encryptByte(byte by, int n3) {
        return (byte)(this.FRE[n3] ^ by);
    }

    private int encryptBlockWithIV(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blockSize;
        if (n3 + n5 <= byArray.length) {
            int n6 = this.count;
            if (n6 == 0) {
                if (n5 * 2 + n4 + 2 <= byArray2.length) {
                    int n7;
                    int n8;
                    PGPCFBBlockCipher pGPCFBBlockCipher = this;
                    byte[] byArray3 = pGPCFBBlockCipher.FR;
                    byte[] byArray4 = pGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray3, 0, byArray4, 0);
                    for (int i3 = 0; i3 < (n8 = this.blockSize); ++i3) {
                        PGPCFBBlockCipher pGPCFBBlockCipher2 = this;
                        n8 = n4 + i3;
                        byArray2[n8] = pGPCFBBlockCipher2.encryptByte(pGPCFBBlockCipher2.IV[i3], i3);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher3 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher4 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher5 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher6 = this;
                    System.arraycopy(byArray2, n4, this.FR, 0, n8);
                    PGPCFBBlockCipher pGPCFBBlockCipher7 = this;
                    byte[] byArray5 = pGPCFBBlockCipher7.FR;
                    byte[] byArray6 = pGPCFBBlockCipher7.FRE;
                    pGPCFBBlockCipher6.cipher.processBlock(byArray5, 0, byArray6, 0);
                    int n9 = pGPCFBBlockCipher6.blockSize;
                    int n10 = n4 + n9;
                    byArray2[n10] = pGPCFBBlockCipher5.encryptByte(pGPCFBBlockCipher5.IV[n9 - 2], 0);
                    n9 = this.blockSize;
                    n10 = n4 + n9 + 1;
                    byArray2[n10] = pGPCFBBlockCipher4.encryptByte(pGPCFBBlockCipher4.IV[n9 - 1], 1);
                    n9 = n4 + 2;
                    byte[] byArray7 = pGPCFBBlockCipher3.FR;
                    int n11 = pGPCFBBlockCipher3.blockSize;
                    System.arraycopy(byArray2, n9, byArray7, 0, n11);
                    PGPCFBBlockCipher pGPCFBBlockCipher8 = this;
                    byte[] byArray8 = pGPCFBBlockCipher8.FR;
                    byArray7 = pGPCFBBlockCipher8.FRE;
                    this.cipher.processBlock(byArray8, 0, byArray7, 0);
                    for (int i4 = 0; i4 < (n7 = this.blockSize); ++i4) {
                        n7 = b.a(n4, n7, 2, i4);
                        byArray2[n7] = this.encryptByte(byArray[n3 + i4], i4);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher9 = this;
                    int n12 = n4 + n7 + 2;
                    System.arraycopy(byArray2, n12, this.FR, 0, n7);
                    n12 = pGPCFBBlockCipher9.count;
                    int n13 = pGPCFBBlockCipher9.blockSize;
                    this.count = n13 * 2 + 2 + n12;
                    return n13 * 2 + 2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            if (n6 >= n5 + 2) {
                if (n4 + n5 <= byArray2.length) {
                    int n14;
                    PGPCFBBlockCipher pGPCFBBlockCipher = this;
                    byte[] byArray9 = pGPCFBBlockCipher.FR;
                    byte[] byArray10 = pGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray9, 0, byArray10, 0);
                    for (int i5 = 0; i5 < (n14 = this.blockSize); ++i5) {
                        n14 = n4 + i5;
                        byArray2[n14] = this.encryptByte(byArray[n3 + i5], i5);
                    }
                    System.arraycopy(byArray2, n4, this.FR, 0, n14);
                } else {
                    throw new OutputLengthException("output buffer too short");
                }
            }
            return this.blockSize;
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlockWithIV(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = ((PGPCFBBlockCipher)object).blockSize;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                int n6 = ((PGPCFBBlockCipher)object).count;
                if (n6 == 0) {
                    for (int i3 = 0; i3 < ((PGPCFBBlockCipher)object).blockSize; ++i3) {
                        ((PGPCFBBlockCipher)object).FR[i3] = byArray[n3 + i3];
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher2 = object;
                    byArray = pGPCFBBlockCipher2.FR;
                    byte[] byArray3 = pGPCFBBlockCipher2.FRE;
                    pGPCFBBlockCipher.cipher.processBlock(byArray, 0, byArray3, 0);
                    pGPCFBBlockCipher.count += ((PGPCFBBlockCipher)object).blockSize;
                    return 0;
                }
                if (n6 == n5) {
                    int n7;
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    System.arraycopy(byArray, n3, ((PGPCFBBlockCipher)object).tmp, 0, n5);
                    int n8 = ((PGPCFBBlockCipher)object).blockSize - 2;
                    System.arraycopy(pGPCFBBlockCipher.FR, 2, pGPCFBBlockCipher.FR, 0, n8);
                    byte[] byArray4 = pGPCFBBlockCipher.FR;
                    PGPCFBBlockCipher pGPCFBBlockCipher3 = object;
                    n3 = pGPCFBBlockCipher3.blockSize;
                    n5 = n3 - 2;
                    byte[] byArray5 = pGPCFBBlockCipher3.tmp;
                    byArray4[n5] = byArray5[0];
                    pGPCFBBlockCipher.FR[--n3] = pGPCFBBlockCipher3.tmp[1];
                    pGPCFBBlockCipher.cipher.processBlock(byArray4, 0, ((PGPCFBBlockCipher)object).FRE, 0);
                    for (n7 = 0; n7 < (n3 = ((PGPCFBBlockCipher)object).blockSize) - 2; ++n7) {
                        PGPCFBBlockCipher pGPCFBBlockCipher4 = object;
                        n3 = n4 + n7;
                        byArray2[n3] = pGPCFBBlockCipher4.encryptByte(pGPCFBBlockCipher4.tmp[n7 + 2], n7);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher5 = object;
                    Object object = ((PGPCFBBlockCipher)object).FR;
                    n7 = n3 - 2;
                    System.arraycopy(pGPCFBBlockCipher5.tmp, 2, object, 0, n7);
                    pGPCFBBlockCipher5.count += 2;
                    return pGPCFBBlockCipher5.blockSize - 2;
                }
                if (n6 >= n5 + 2) {
                    int n9;
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher6 = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher7 = object;
                    System.arraycopy(byArray, n3, ((PGPCFBBlockCipher)object).tmp, 0, n5);
                    int n10 = n4 + 0;
                    byArray2[n10] = pGPCFBBlockCipher7.encryptByte(pGPCFBBlockCipher7.tmp[0], ((PGPCFBBlockCipher)object).blockSize - 2);
                    n10 = n4 + 1;
                    byArray2[n10] = pGPCFBBlockCipher6.encryptByte(pGPCFBBlockCipher6.tmp[1], ((PGPCFBBlockCipher)object).blockSize - 1);
                    PGPCFBBlockCipher pGPCFBBlockCipher8 = object;
                    byte[] byArray6 = pGPCFBBlockCipher8.FR;
                    n3 = pGPCFBBlockCipher8.blockSize - 2;
                    System.arraycopy(pGPCFBBlockCipher.tmp, 0, byArray6, n3, 2);
                    PGPCFBBlockCipher pGPCFBBlockCipher9 = object;
                    byArray6 = pGPCFBBlockCipher9.FR;
                    byte[] byArray7 = pGPCFBBlockCipher9.FRE;
                    pGPCFBBlockCipher.cipher.processBlock(byArray6, 0, byArray7, 0);
                    for (int i4 = 0; i4 < (n9 = ((PGPCFBBlockCipher)object).blockSize) - 2; ++i4) {
                        Object object = object;
                        n9 = n4 + i4 + 2;
                        byArray2[n9] = super.encryptByte(((PGPCFBBlockCipher)object).tmp[i4 + 2], i4);
                    }
                    byte[] byArray8 = ((PGPCFBBlockCipher)object).FR;
                    System.arraycopy(((PGPCFBBlockCipher)object).tmp, 2, byArray8, 0, n9 -= 2);
                }
                return ((PGPCFBBlockCipher)object).blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blockSize;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                PGPCFBBlockCipher pGPCFBBlockCipher = this;
                byte[] byArray3 = pGPCFBBlockCipher.FR;
                byte[] byArray4 = pGPCFBBlockCipher.FRE;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int i3 = 0; i3 < this.blockSize; ++i3) {
                    int n6 = n4 + i3;
                    byArray2[n6] = this.encryptByte(byArray[n3 + i3], i3);
                }
                for (int i4 = 0; i4 < (n3 = this.blockSize); ++i4) {
                    this.FR[i4] = byArray2[n4 + i4];
                }
                return n3;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blockSize;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                PGPCFBBlockCipher pGPCFBBlockCipher = this;
                byte[] byArray3 = pGPCFBBlockCipher.FR;
                byte[] byArray4 = pGPCFBBlockCipher.FRE;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int i3 = 0; i3 < this.blockSize; ++i3) {
                    int n6 = n4 + i3;
                    byArray2[n6] = this.encryptByte(byArray[n3 + i3], i3);
                }
                for (int i4 = 0; i4 < (n4 = this.blockSize); ++i4) {
                    this.FR[i4] = byArray[n3 + i4];
                }
                return n4;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        if (this.inlineIv) {
            return this.cipher.getAlgorithmName() + "/PGPCFBwithIV";
        }
        return this.cipher.getAlgorithmName() + "/PGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.inlineIv) {
            return this.forEncryption ? this.encryptBlockWithIV(byArray, n3, byArray2, n4) : this.decryptBlockWithIV(byArray, n3, byArray2, n4);
        }
        return this.forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
    }

    @Override
    public void reset() {
        this.count = 0;
        int n3 = 0;
        while (true) {
            byte[] byArray = this.FR;
            if (n3 == this.FR.length) break;
            byArray[n3] = this.inlineIv ? (byte)0 : this.IV[n3];
            ++n3;
        }
        this.cipher.reset();
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.forEncryption = bl;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n3 = byArray2.length - ((Object)object).length;
                int n4 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n3, n4);
                int n5 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n5 < this.IV.length - ((Object)object).length) {
                        byArray3[n5] = 0;
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else {
                int n6 = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n6);
            }
            PGPCFBBlockCipher pGPCFBBlockCipher = this;
            pGPCFBBlockCipher.reset();
            pGPCFBBlockCipher.cipher.init(true, parametersWithIV.getParameters());
        } else {
            PGPCFBBlockCipher pGPCFBBlockCipher = this;
            pGPCFBBlockCipher.reset();
            pGPCFBBlockCipher.cipher.init(true, (CipherParameters)object);
        }
    }
}

