/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class PaddedBlockCipher
extends BufferedBlockCipher {
    public PaddedBlockCipher(BlockCipher blockCipher) {
        PaddedBlockCipher paddedBlockCipher = this;
        this.cipher = blockCipher;
        paddedBlockCipher.buf = new byte[blockCipher.getBlockSize()];
        paddedBlockCipher.bufOff = 0;
    }

    @Override
    public int getOutputSize(int n3) {
        byte[] byArray = this.buf;
        int n4 = (n3 += this.bufOff) % this.buf.length;
        if (n4 == 0) {
            if (this.forEncryption) {
                return n3 + byArray.length;
            }
            return n3;
        }
        return n3 - n4 + byArray.length;
    }

    @Override
    public int getUpdateOutputSize(int n3) {
        Object object = ((BufferedBlockCipher)object).buf;
        int n4 = (n3 += ((BufferedBlockCipher)object).bufOff) % ((BufferedBlockCipher)object).buf.length;
        if (n4 == 0) {
            return n3 - ((Object)object).length;
        }
        return n3 - n4;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n3) {
        int n4 = 0;
        byte[] byArray2 = this.buf;
        if (this.bufOff == this.buf.length) {
            n4 = this.cipher.processBlock(byArray2, 0, byArray, n3);
            this.bufOff = 0;
        }
        int n5 = this.bufOff;
        this.bufOff = n5 + 1;
        this.buf[n5] = by;
        return n4;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n4 >= 0) {
            PaddedBlockCipher paddedBlockCipher = object;
            int n6 = paddedBlockCipher.getBlockSize();
            int n7 = paddedBlockCipher.getUpdateOutputSize(n4);
            if (n7 > 0 && n5 + n7 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n7 = 0;
            byte[] byArray3 = ((BufferedBlockCipher)object).buf;
            int n8 = ((BufferedBlockCipher)object).bufOff;
            int n9 = ((BufferedBlockCipher)object).buf.length - n8;
            if (n4 > n9) {
                int n10 = n3;
                System.arraycopy(byArray, n3, byArray3, n8, n9);
                n3 = ((BufferedBlockCipher)object).cipher.processBlock(((BufferedBlockCipher)object).buf, 0, byArray2, n5) + n7;
                ((BufferedBlockCipher)object).bufOff = 0;
                n4 -= n9;
                int n11 = n7 = n10 + n9;
                n7 = n3;
                n3 = n11;
                while (n4 > ((BufferedBlockCipher)object).buf.length) {
                    int n12 = n3;
                    int n13 = n4;
                    n4 = n5 + n7;
                    n3 = ((BufferedBlockCipher)object).cipher.processBlock(byArray, n3, byArray2, n4) + n7;
                    n4 = n13 - n6;
                    int n14 = n7 = n12 + n6;
                    n7 = n3;
                    n3 = n14;
                }
            }
            PaddedBlockCipher paddedBlockCipher2 = object;
            PaddedBlockCipher paddedBlockCipher3 = object;
            Object object = paddedBlockCipher3.buf;
            System.arraycopy(byArray, n3, object, paddedBlockCipher3.bufOff, n4);
            paddedBlockCipher2.bufOff += n4;
            return n7;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        block9: {
            block10: {
                int n4;
                block8: {
                    int n5;
                    int n6;
                    block7: {
                        int n7;
                        PaddedBlockCipher paddedBlockCipher = this;
                        n6 = paddedBlockCipher.cipher.getBlockSize();
                        n5 = 0;
                        if (!paddedBlockCipher.forEncryption) break block7;
                        if (this.bufOff == n6) {
                            if (n6 * 2 + n3 <= byArray.length) {
                                n5 = this.cipher.processBlock(this.buf, 0, byArray, n3);
                                this.bufOff = 0;
                            } else {
                                throw new OutputLengthException("output buffer too short");
                            }
                        }
                        byte by = (byte)(n6 - this.bufOff);
                        while ((n7 = this.bufOff) < n6) {
                            this.buf[n7] = by;
                            this.bufOff = n7 + 1;
                        }
                        byte[] byArray2 = this.buf;
                        n6 = n3 + n5;
                        n4 = this.cipher.processBlock(byArray2, 0, byArray, n6) + n5;
                        break block8;
                    }
                    if (this.bufOff != n6) break block9;
                    PaddedBlockCipher paddedBlockCipher = this;
                    n5 = paddedBlockCipher.cipher.processBlock(this.buf, 0, this.buf, 0);
                    paddedBlockCipher.bufOff = 0;
                    byte[] byArray3 = paddedBlockCipher.buf;
                    int n8 = paddedBlockCipher.buf[n6 - 1] & 0xFF;
                    if (n8 > n6) break block10;
                    n6 = n5 - n8;
                    System.arraycopy(byArray3, 0, byArray, n3, n6);
                    n4 = n6;
                }
                this.reset();
                return n4;
            }
            throw new InvalidCipherTextException("pad block corrupted");
        }
        throw new DataLengthException("last block incomplete in decryption");
    }
}

