/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SkippingStreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher blockCipher) {
        int n3;
        SICBlockCipher sICBlockCipher = this;
        super(blockCipher);
        this.cipher = blockCipher;
        sICBlockCipher.blockSize = n3 = blockCipher.getBlockSize();
        sICBlockCipher.IV = new byte[n3];
        sICBlockCipher.counter = new byte[n3];
        sICBlockCipher.counterOut = new byte[n3];
        sICBlockCipher.byteCount = 0;
    }

    private void checkCounter() {
        block2: {
            if (this.IV.length < this.blockSize) {
                int n3 = 0;
                while (true) {
                    byte[] byArray = this.IV;
                    if (n3 == this.IV.length) break block2;
                    if (this.counter[n3] != byArray[n3]) break;
                    ++n3;
                }
                throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
            }
        }
    }

    private void incrementCounterAt(int n3) {
        n3 = this.counter.length - n3;
        while ((n3 += -1) >= 0) {
            byte by;
            byte[] byArray = this.counter;
            byArray[n3] = by = (byte)(this.counter[n3] + 1);
            if (by == 0) continue;
        }
    }

    private void incrementCounter(int n3) {
        byte[] byArray = this.counter;
        byte by = this.counter[byArray.length - 1];
        int n4 = byArray.length - 1;
        byArray[n4] = (byte)(byArray[n4] + n3);
        if (by != 0 && byArray[byArray.length - 1] < by) {
            this.incrementCounterAt(1);
        }
    }

    private void decrementCounterAt(int n3) {
        n3 = this.counter.length - n3;
        while ((n3 += -1) >= 0) {
            byte by;
            byte[] byArray = this.counter;
            byArray[n3] = by = (byte)(this.counter[n3] - 1);
            if (by == -1) continue;
            return;
        }
    }

    private void adjustCounter(long l3) {
        if (l3 >= 0L) {
            long l4;
            long l5 = (l3 + (long)this.byteCount) / (long)this.blockSize;
            if (l5 > 255L) {
                l4 = l5;
                for (int i3 = 5; i3 >= 1; --i3) {
                    int n3 = i3 * 8;
                    long l6 = 1L << n3;
                    while (l4 >= l6) {
                        this.incrementCounterAt(i3);
                        l4 -= l6;
                    }
                }
            } else {
                l4 = l5;
            }
            SICBlockCipher sICBlockCipher = this;
            sICBlockCipher.incrementCounter((int)l4);
            this.byteCount = (int)(l3 + (long)sICBlockCipher.byteCount - (long)this.blockSize * l5);
        } else {
            long l7;
            long l8;
            long l9 = (-l3 - (long)this.byteCount) / (long)this.blockSize;
            if (l9 > 255L) {
                l8 = l9;
                for (int i4 = 5; i4 >= 1; --i4) {
                    int n4 = i4 * 8;
                    l7 = 1L << n4;
                    while (l8 > l7) {
                        this.decrementCounterAt(i4);
                        l8 -= l7;
                    }
                }
            } else {
                l8 = l9;
            }
            for (l7 = 0L; l7 != l8; ++l7) {
                this.decrementCounterAt(0);
            }
            SICBlockCipher sICBlockCipher = this;
            int n5 = (int)((long)sICBlockCipher.blockSize * l9 + (l3 = (long)sICBlockCipher.byteCount + l3));
            if (n5 >= 0) {
                this.byteCount = 0;
            } else {
                SICBlockCipher sICBlockCipher2 = this;
                sICBlockCipher2.decrementCounterAt(0);
                sICBlockCipher2.byteCount = sICBlockCipher2.blockSize + n5;
            }
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = Arrays.clone(parametersWithIV.getIV());
            object = byArray;
            this.IV = byArray;
            int n3 = this.blockSize;
            if (n3 >= ((Object)object).length) {
                int n4 = 8 > n3 / 2 ? n3 / 2 : 8;
                if (n3 - ((Object)object).length <= n4) {
                    if (parametersWithIV.getParameters() != null) {
                        this.cipher.init(true, parametersWithIV.getParameters());
                    }
                    this.reset();
                    return;
                }
                throw new IllegalArgumentException(b.b.a("CTR/SIC mode requires IV of at least: ").append(this.blockSize - n4).append(" bytes.").toString());
            }
            throw new IllegalArgumentException(b.a(b.b.a("CTR/SIC mode requires IV no greater than: "), this.blockSize, " bytes."));
        }
        throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        SICBlockCipher sICBlockCipher = this;
        sICBlockCipher.processBytes(byArray, n3, this.blockSize, byArray2, n4);
        return sICBlockCipher.blockSize;
    }

    @Override
    public byte calculateByte(byte by) {
        int n3;
        int n4 = this.byteCount;
        if (n4 == 0) {
            SICBlockCipher sICBlockCipher = this;
            SICBlockCipher sICBlockCipher2 = this;
            byte[] byArray = sICBlockCipher2.counter;
            byte[] byArray2 = sICBlockCipher2.counterOut;
            sICBlockCipher.cipher.processBlock(byArray, 0, byArray2, 0);
            int n5 = this.byteCount;
            this.byteCount = n5 + 1;
            return (byte)(sICBlockCipher.counterOut[n5] ^ by);
        }
        byte[] byArray = this.counterOut;
        this.byteCount = n3 = n4 + 1;
        by = (byte)(byArray[n4] ^ by);
        if (n3 == this.counter.length) {
            SICBlockCipher sICBlockCipher = this;
            sICBlockCipher.byteCount = 0;
            sICBlockCipher.incrementCounterAt(0);
            sICBlockCipher.checkCounter();
        }
        return by;
    }

    @Override
    public void reset() {
        SICBlockCipher sICBlockCipher = object;
        Arrays.fill(sICBlockCipher.counter, (byte)0);
        Object object = ((SICBlockCipher)object).counter;
        int n3 = sICBlockCipher.IV.length;
        System.arraycopy(sICBlockCipher.IV, 0, object, 0, n3);
        sICBlockCipher.cipher.reset();
        sICBlockCipher.byteCount = 0;
    }

    @Override
    public long skip(long l3) {
        SICBlockCipher sICBlockCipher = object;
        sICBlockCipher.adjustCounter(l3);
        sICBlockCipher.checkCounter();
        SICBlockCipher sICBlockCipher2 = object;
        Object object = sICBlockCipher2.counter;
        byte[] byArray = sICBlockCipher2.counterOut;
        sICBlockCipher.cipher.processBlock((byte[])object, 0, byArray, 0);
        return l3;
    }

    @Override
    public long seekTo(long l3) {
        this.reset();
        return this.skip(l3);
    }

    @Override
    public long getPosition() {
        byte[] byArray = this.counter;
        int n3 = this.counter.length;
        byte[] byArray2 = byArray;
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        for (int i3 = n3 - 1; i3 >= 1; --i3) {
            byte[] byArray3 = this.IV;
            int n4 = i3 < this.IV.length ? (byArray[i3] & 0xFF) - (byArray3[i3] & 0xFF) : byArray[i3] & 0xFF;
            if (n4 < 0) {
                int n5 = n4;
                n4 = i3 - 1;
                byArray[n4] = (byte)(byArray[n4] - 1);
                n4 = n5 + 256;
            }
            byArray[i3] = (byte)n4;
        }
        return Pack.bigEndianToLong(byArray, n3 - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

