/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Longs;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class GCMUtil {
    private static final int E1 = -520093696;
    private static final long E1L = -2233785415175766016L;

    public static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    public static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    public static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    public static byte[] asBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(int[] nArray, byte[] byArray) {
        Pack.intToBigEndian(nArray, byArray, 0);
    }

    public static byte[] asBytes(long[] lArray) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(lArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(long[] lArray, byte[] byArray) {
        Pack.longToBigEndian(lArray, byArray, 0);
    }

    public static int[] asInts(byte[] byArray) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(byArray, 0, nArray);
        return nArray;
    }

    public static void asInts(byte[] byArray, int[] nArray) {
        Pack.bigEndianToInt(byArray, 0, nArray);
    }

    public static long[] asLongs(byte[] byArray) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(byArray, 0, lArray);
        return lArray;
    }

    public static void asLongs(byte[] byArray, long[] lArray) {
        Pack.bigEndianToLong(byArray, 0, lArray);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
    }

    public static void copy(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0];
        lArray2[1] = l3 = lArray[1];
    }

    public static void divideP(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l3;
        long l6 = l5 >> 63;
        lArray2[0] = l3 = (l5 ^ l6 & 0xE100000000000000L) << 1 | l4 >>> 63;
        lArray2[1] = l6 = l4 << 1 | -l6;
    }

    public static void multiply(byte[] byArray, byte[] byArray2) {
        long[] lArray = GCMUtil.asLongs(byArray);
        GCMUtil.multiply(lArray, GCMUtil.asLongs(byArray2));
        GCMUtil.asBytes(lArray, byArray);
    }

    public static void multiply(int[] nArray, int[] nArray2) {
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int n11 = nArray[i3];
            for (int i4 = 0; i4 < 32; ++i4) {
                int n12 = n3;
                int n13 = n4;
                int n14 = n5;
                int n15 = n6;
                int n16 = n6;
                int n17 = n11;
                n6 = n17 >> 31;
                n11 = n17 << 1;
                n7 ^= n3 & n6;
                n8 ^= n4 & n6;
                n9 ^= n5 & n6;
                n6 = n10 ^ n16 & n6;
                n10 = n15 << 31 >> 8;
                n5 = n15 >>> 1 | n5 << 31;
                n4 = n14 >>> 1 | n4 << 31;
                n3 = n13 >>> 1 | n3 << 31;
                n10 = n12 >>> 1 ^ n10 & 0xE1000000;
                int n18 = n6;
                n6 = n5;
                n5 = n4;
                n4 = n3;
                n3 = n10;
                n10 = n18;
            }
        }
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        nArray3[0] = n7;
        nArray4[1] = n8;
        nArray3[2] = n9;
        nArray4[3] = n10;
    }

    public static void multiply(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        long l3 = lArray3[0];
        long l4 = lArray[1];
        long l5 = lArray2[0];
        long l6 = lArray2[1];
        long l7 = Longs.reverse(l3);
        long l8 = Longs.reverse(l4);
        long l9 = Longs.reverse(l5);
        long l10 = Longs.reverse(l6);
        long l11 = Longs.reverse(GCMUtil.implMul64(l7, l9));
        long l12 = GCMUtil.implMul64(l3, l5) << 1;
        long l13 = l3;
        long l14 = l4;
        long l15 = l4;
        l4 = Longs.reverse(GCMUtil.implMul64(l8, l10));
        l3 = GCMUtil.implMul64(l15, l6) << 1;
        l7 = Longs.reverse(GCMUtil.implMul64(l7 ^ l8, l9 ^ l10));
        l5 = GCMUtil.implMul64(l13 ^ l14, l5 ^ l6) << 1;
        long l16 = l12 ^ l11 ^ l4 ^ l7;
        long l17 = l3;
        l4 = l4 ^ l12 ^ l3 ^ l5;
        long l18 = l16 ^ (l17 ^ l17 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7);
        long l19 = l4 ^= l3 << 62 ^ l3 << 57;
        l3 = l11 ^ (l19 ^ l19 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7);
        l4 = l18 ^ (l4 << 63 ^ l4 << 62 ^ l4 << 57);
        lArray3[0] = l3;
        lArray[1] = l4;
    }

    public static void multiplyP(int[] nArray) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = n6 << 31 >> 31;
        nArray[0] = n3 >>> 1 ^ n7 & 0xE1000000;
        nArray[1] = n4 >>> 1 | n3 << 31;
        nArray[2] = n5 >>> 1 | n4 << 31;
        nArray[3] = n6 >>> 1 | n5 << 31;
    }

    public static void multiplyP(int[] nArray, int[] nArray2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = n6 << 31 >> 31;
        nArray2[0] = n3 >>> 1 ^ n7 & 0xE1000000;
        nArray2[1] = n4 >>> 1 | n3 << 31;
        nArray2[2] = n5 >>> 1 | n4 << 31;
        nArray2[3] = n6 >>> 1 | n5 << 31;
    }

    public static void multiplyP(long[] lArray) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4;
        l5 = l5 << 63 >> 63;
        lArray[0] = l5 = l3 >>> 1 ^ l5 & 0xE100000000000000L;
        lArray[1] = l3 = l4 >>> 1 | l3 << 63;
    }

    public static void multiplyP(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4 << 63 >> 63;
        lArray2[0] = l5 = l3 >>> 1 ^ l5 & 0xE100000000000000L;
        lArray2[1] = l5 = l4 >>> 1 | l3 << 63;
    }

    public static void multiplyP3(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4 << 61;
        lArray2[0] = l5 = l3 >>> 3 ^ l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        lArray2[1] = l5 = l4 >>> 3 | l3 << 61;
    }

    public static void multiplyP4(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4 << 60;
        lArray2[0] = l5 = l3 >>> 4 ^ l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        lArray2[1] = l5 = l4 >>> 4 | l3 << 60;
    }

    public static void multiplyP7(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4 << 57;
        lArray2[0] = l5 = l3 >>> 7 ^ l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        lArray2[1] = l5 = l4 >>> 7 | l3 << 57;
    }

    public static void multiplyP8(int[] nArray) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = n6 << 24;
        nArray[0] = n3 >>> 8 ^ n7 ^ n7 >>> 1 ^ n7 >>> 2 ^ n7 >>> 7;
        nArray[1] = n4 >>> 8 | n3 << 24;
        nArray[2] = n5 >>> 8 | n4 << 24;
        nArray[3] = n6 >>> 8 | n5 << 24;
    }

    public static void multiplyP8(int[] nArray, int[] nArray2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = n6 << 24;
        nArray2[0] = n3 >>> 8 ^ n7 ^ n7 >>> 1 ^ n7 >>> 2 ^ n7 >>> 7;
        nArray2[1] = n4 >>> 8 | n3 << 24;
        nArray2[2] = n5 >>> 8 | n4 << 24;
        nArray2[3] = n6 >>> 8 | n5 << 24;
    }

    public static void multiplyP8(long[] lArray) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4;
        l5 <<= 56;
        lArray[0] = l5 = l3 >>> 8 ^ l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        lArray[1] = l3 = l4 >>> 8 | l3 << 56;
    }

    public static void multiplyP8(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = l4 << 56;
        lArray2[0] = l5 = l3 >>> 8 ^ l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        lArray2[1] = l5 = l4 >>> 8 | l3 << 56;
    }

    public static long[] pAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = 0x4000000000000000L;
        return lArray;
    }

    public static void square(long[] lArray, long[] lArray2) {
        lArray2 = new long[4];
        Interleave.expand64To128Rev(lArray[0], lArray2, 0);
        Interleave.expand64To128Rev(lArray[1], lArray2, 2);
        long l3 = lArray2[0];
        long l4 = lArray2[2];
        long l5 = lArray2[3];
        long l6 = l4 ^= l5 << 63 ^ l5 << 62 ^ l5 << 57;
        l3 ^= l6 ^ l6 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        l4 = lArray2[1] ^ (l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7) ^ (l4 << 63 ^ l4 << 62 ^ l4 << 57);
        lArray2[0] = l3;
        lArray2[1] = l4;
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        int n3 = 0;
        do {
            byte[] byArray3 = byArray;
            byArray3[n3] = (byte)(byArray[n3] ^ byArray2[n3]);
            byArray3[++n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
            byArray3[++n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
            byArray[++n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
        } while (++n3 < 16);
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n3) {
        int n4 = 0;
        do {
            byte[] byArray3 = byArray;
            byArray3[n4] = (byte)(byArray[n4] ^ byArray2[n3 + n4]);
            byArray3[++n4] = (byte)(byArray3[n4] ^ byArray2[n3 + n4]);
            byArray3[++n4] = (byte)(byArray3[n4] ^ byArray2[n3 + n4]);
            byArray[++n4] = (byte)(byArray3[n4] ^ byArray2[n3 + n4]);
        } while (++n4 < 16);
    }

    public static void xor(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, int n5) {
        int n6 = 0;
        do {
            int n7 = n5 + n6;
            byArray3[n7] = (byte)(byArray[n3 + n6] ^ byArray2[n4 + n6]);
            n7 = n5 + ++n6;
            byArray3[n7] = (byte)(byArray[n3 + n6] ^ byArray2[n4 + n6]);
            n7 = n5 + ++n6;
            byArray3[n7] = (byte)(byArray[n3 + n6] ^ byArray2[n4 + n6]);
            n7 = n5 + ++n6;
            byArray3[n7] = (byte)(byArray[n3 + n6] ^ byArray2[n4 + n6]);
        } while (++n6 < 16);
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n3, int n4) {
        while ((n4 += -1) >= 0) {
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n3 + n4]);
        }
    }

    public static void xor(byte[] byArray, int n3, byte[] byArray2, int n4, int n5) {
        while ((n5 += -1) >= 0) {
            int n6 = n3 + n5;
            byArray[n6] = (byte)(byArray[n6] ^ byArray2[n4 + n5]);
        }
    }

    public static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3 = 0;
        do {
            byArray3[n3] = (byte)(byArray[n3] ^ byArray2[n3]);
            byArray3[++n3] = (byte)(byArray[n3] ^ byArray2[n3]);
            byArray3[++n3] = (byte)(byArray[n3] ^ byArray2[n3]);
            byArray3[++n3] = (byte)(byArray[n3] ^ byArray2[n3]);
        } while (++n3 < 16);
    }

    public static void xor(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(long[] lArray, long[] lArray2) {
        long l3;
        long l4;
        long[] lArray3 = lArray;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l3 = lArray[1] ^ lArray2[1];
    }

    public static void xor(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l3 = lArray[1] ^ lArray2[1];
    }

    private static long implMul64(long l3, long l4) {
        long l5 = l3 & 0x1111111111111111L;
        long l6 = l4;
        long l7 = l3;
        l3 = l7 & 0x2222222222222222L;
        l4 = l7 & 0x4444444444444444L;
        long l8 = l7 & 0x8888888888888888L;
        long l9 = l6 & 0x1111111111111111L;
        long l10 = l6 & 0x2222222222222222L;
        long l11 = l6 & 0x4444444444444444L;
        long l12 = l6 & 0x8888888888888888L;
        long l13 = l5 * l9 ^ l3 * l12 ^ l4 * l11 ^ l8 * l10;
        long l14 = l5;
        long l15 = l12;
        long l16 = l5;
        l5 = l5 * l10 ^ l3 * l9 ^ l4 * l12 ^ l8 * l11;
        l12 = l16 * l11 ^ l3 * l10 ^ l4 * l9 ^ l8 * l12;
        long l17 = l3 = l14 * l15 ^ l3 * l11 ^ l4 * l10 ^ l8 * l9;
        l3 = l5 & 0x2222222222222222L;
        l4 = l12 & 0x4444444444444444L;
        l5 = l17 & 0x8888888888888888L;
        return l13 & 0x1111111111111111L | l3 | l4 | l5;
    }
}

